
@i ../copyright.w

@* uni\_strtok.

A sequence of calls to |uni\_strtok| breaks string to tokens delimited
by characters from |delim| set. First call should pass pointer to
subject string as |str|, subsequent calls should pass |NULL|. With
each call, next token of string is returned, with |NULL| when no
more left.

Example:

For string " \t word    next \n" and dilimiter set " \t\n" |uni\_strtok|
will return "word" and "next".

Note: New delimiter string may be passed with each call to function.

@c

#include <unicode.h>

Uchar*
uni_strtok(Uchar *str, const Uchar *delim){

        static Uchar *cur_str;
        static int len;

        int tok_pos;
        Uchar *tok;

	if (str) { cur_str=str; len=uni_strlen(str); }

        if (!cur_str) return NULL;

        tok_pos=uni_strspn(cur_str,delim);
        if (tok_pos==len) return NULL;
        len-=tok_pos;
        tok=cur_str+tok_pos;
        cur_str=uni_strpbrk(tok,delim);
        if (cur_str) { *cur_str++=0; len-=cur_str-tok; }
        return tok;
}

@* Index.