/* xml++.cc
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#include "libxml++/attribute.h"

namespace xmlpp {

Attribute::Attribute(const std::string& name, const std::string& value)
: _name(name), _value(value)
{ }

Attribute::Attribute(xmlAttrPtr attr)
{
  if(attr->name)
    _name = (const char*) attr->name;

  if(attr->children)
    _value = (const char*) attr->children->content;
}

const std::string&  Attribute::name() const
{
  return _name;
}

const std::string&  Attribute::value() const
{
  return _value;
}

void Attribute::set_value(const std::string& value)
{
  _value = value;
};


} // namespace xmlpp


