/* node.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_DTD_H
#define __LIBXMLPP_DTD_H

#include <libxml++/attribute.h>
#include <list>
#include <map>

#include <libxml/tree.h>

namespace xmlpp {

/** Represents XML DTDs.
 *
 */
class Dtd //TODO: Derive from Node?
{
public:
  Dtd(const std::string& name, const std::string& external_id, const std::string& system_id);
  ~Dtd();

  std::string get_name() const;
  std::string get_external_id() const;
  std::string get_system_id() const;

protected:
  std::string _name, _external_id, _system_id;
};

} // namespace xmlpp

#endif //__LIBXMLPP_DTD_H



