/* xml++.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_PARSERS_DOMPARSER_H
#define __LIBXMLPP_PARSERS_DOMPARSER_H

#include <libxml++/parsers/parser.h>
#include <libxml++/dtd.h>

#include <libxml/parser.h>
#include <libxml/tree.h>

namespace xmlpp {

/** XML DOM parser.
 *
 */
class DomParser : public Parser
{
public:
  DomParser();
  explicit DomParser(const std::string& filename);
  virtual ~DomParser();

  virtual void parse_file(const std::string& filename) throw(exception);
  virtual void parse_memory(const std::string& contents) throw(exception);
  virtual void parse_stream(std::istream& in) throw(exception);

  /// no exception indicates success.
  virtual void write_to_file(const std::string& filename, const std::string& encoding = std::string()) throw(exception);
  /// no exception indicates success.
  virtual std::string write_to_string(const std::string& encoding = std::string()) throw(exception);

  Node* get_root_node();
  const Node* get_root_node() const;
  Node* set_root_node(const std::string& name,  const std::string& ns_href = std::string(), const std::string& ns_href_prefix = std::string());

  std::string get_encoding() const;

  void set_internal_subset(const std::string& name, const std::string& external_id, const std::string& system_id);
  Dtd* get_internal_subset();
  const Dtd* get_internal_subset() const;

  /** Test whether a document has been parsed.
  */
  operator bool() const;

protected:
  void release_underlying();
  xmlDocPtr dump_to_c_doc(); //Caller should use xmlFreeDoc().

  xmlDocPtr _doc;
  Node* _pRootNode;
  Dtd* _pDtd;
};




} // namespace xmlpp

#endif //__LIBXMLPP_PARSERS_DOMPARSER_H



