/* xml++.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_PARSER_H
#define __LIBXMLPP_PARSER_H

#include <libxml++/node.h>
#include <libxml++/exceptions/parse_error.h>
#include <libxml++/exceptions/internal_error.h>

#include <istream>

namespace xmlpp {

/** XML parser.
 *
 */
class Parser
{
public:
  Parser();
  virtual ~Parser();

  virtual void parse_file(const std::string& filename) throw(exception) = 0;
  virtual void parse_memory(const std::string& contents) throw(exception) = 0;
  virtual void parse_stream(std::istream& in) throw(exception) = 0;
};

} // namespace xmlpp

#endif //__LIBXMLPP_PARSER_H



