// -*- C++ -*-

/* main.cc
 *
 * Copyright (C) 2002 The libxml++ development team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libxml++/libxml++.h>

#include <iostream>


int
main(int argc, char* argv[])
{
  try
  {
    xmlpp::DomParser parser;
    parser.set_internal_subset("example_xml_doc", "", "example_xml_doc.dtd");

    xmlpp::Node* nodeRoot = parser.set_root_node("exampleroot");

    xmlpp::Element* nodeChild = nodeRoot->add_child("examplechild");
    nodeChild->add_attribute("id", "1");
    nodeChild->set_child_content("Some content");

    nodeChild->add_child("child_of_child");

    nodeChild = nodeRoot->add_child("examplechild");
    nodeChild->add_attribute("id", "2");

    std::string whole = parser.write_to_string();
    std::cout << "XML built at runtime: " << std::endl << whole << std::endl;
  }
  catch(const std::exception& ex)
  {
    std::cout << "Exception caught: " << ex.what() << std::endl;
  }

  return 0;
}

