/* attribute.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_ATTRIBUTE_H
#define __LIBXMLPP_ATTRIBUTE_H


#include <string>

#include <libxml/tree.h>

namespace xmlpp {

/** Represents XML Node attributes.
 *
 */
class Attribute
{
public:
  explicit Attribute(const std::string& name, const std::string& value = std::string());
  explicit Attribute(xmlAttrPtr attr);

  std::string get_name() const;
  std::string get_value() const;
  void set_value(const std::string& value);

private:
  std::string _name;
  std::string _value;
};

} // namespace xmlpp

#endif //__LIBXMLPP_ATTRIBUTE_H

