/* xml++.cc
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#include <libxml++/dtd.h>

namespace xmlpp {

Dtd::Dtd(const std::string& name, const std::string& external_id, const std::string& system_id)
: _name(name), _external_id(external_id), _system_id(system_id)
{
}

Dtd::~Dtd()
{
}

std::string Dtd::get_name() const
{
  return _name;
}

std::string Dtd::get_external_id() const
{
  return _external_id;
}

std::string Dtd::get_system_id() const
{
  return _system_id;
}


} // namespace xmlpp


