/* xml++.cc
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#include <libxml++/nodes/commentnode.h>
#include <libxml++/exceptions/internal_error.h>

namespace xmlpp {


CommentNode::CommentNode(const std::string& comment)
  : Node("comment")
{
  set_comment(comment);
}

CommentNode::CommentNode(const CommentNode* from)
  : Node((Node*)from)
{
  set_comment(from->_comment);
}

CommentNode::CommentNode(xmlNodePtr node)
  : Node(node)
{
  if(XML_GET_CONTENT(node))
	  set_comment((char*) XML_GET_CONTENT(node));
}

CommentNode::~CommentNode()
{
}

void CommentNode::set_comment(const std::string& comment)
{
  _comment = comment;
}

std::string CommentNode::get_comment() const
{
  return _comment;
}


void CommentNode::write(xmlDocPtr doc, xmlNodePtr parent) const
{
  //parent will always have a value.

  //Call base class:
  //Node::write(doc, parent);

  //std::cout << "CommentNode::write: xmlNewTextChild" << _comment << std::endl;

  //xmlNodePtr node = xmlNewTextChild(parent, NULL /* ns */, 0, (const xmlChar*)_comment.c_str());
  xmlNodePtr node = xmlNewComment((const xmlChar*)_comment.c_str());
 
  if(!node)
    throw internal_error("xmlNewText() returned NULL");
  else
  {
     xmlNodePtr nodeChild = xmlAddChild(parent, node);
     if(!nodeChild)
       throw internal_error("xmlAddChild() returned NULL when adding a text node"); 
  }
}

} // namespace xmlpp


