/* node.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_NODES_COMMENTNODE_H
#define __LIBXMLPP_NODES_COMMENTNODE_H

#include <libxml++/nodes/node.h>

namespace xmlpp {

class CommentNode : public Node
{
public:
  explicit CommentNode(const std::string& content);
  explicit CommentNode(const CommentNode* from);
  explicit CommentNode(xmlNodePtr node);
  virtual ~CommentNode();

  std::string get_comment() const;
  void set_comment(const std::string& content);
  
  void write(xmlDocPtr doc, xmlNodePtr parent = 0) const;

protected:
  std::string _comment;
};

} // namespace xmlpp

#endif //__LIBXMLPP_NODES_COMMENTNODE_H



