/* node.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_NODES_ELEMENT_H
#define __LIBXMLPP_NODES_ELEMENT_H

#include <libxml++/nodes/node.h>
#include <libxml++/attribute.h>


namespace xmlpp {

class TextNode;

class Element : public Node
{
public:
  typedef std::list<Attribute*> AttributeList;
  typedef std::map<std::string, Attribute*> AttributeMap;

  explicit Element(const std::string& name);
  explicit Element(const Element* from);
  explicit Element(xmlNodePtr node);
  virtual ~Element();

  const AttributeList& get_attributes() const;
  Attribute* get_attribute(const std::string& name);
  const Attribute* get_attribute(const std::string& name) const;
  Attribute* add_attribute(const std::string& name, const std::string& value = std::string());

  /** Remove the child node.
   * @param node The child node to remove. The Attribute will be deleted by this method, so any references to it will be unusable.
   */
  void remove_attribute(const std::string& name);

  virtual void write(xmlDocPtr doc, xmlNodePtr parent = 0) const;

private:
  Attribute* add_attribute(xmlAttrPtr attr);

protected:
  AttributeList _attributes_list;
  AttributeMap _attributes_map;
};

} // namespace xmlpp

#endif //__LIBXMLPP_NODES_ELEMENT_H



