/* xml++.cc
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#include <libxml++/nodes/textnode.h>
#include <libxml++/exceptions/internal_error.h>
#include <iostream>

namespace xmlpp {


TextNode::TextNode(const std::string& content)
  : Node("text")
{
  set_content(content);
}

TextNode::TextNode(const TextNode* from)
  : Node((Node*)from)
{
  set_content(from->_content);
}

TextNode::TextNode(xmlNodePtr node)
  : Node(node)
{
  if(XML_GET_CONTENT(node))
	  set_content((char*) XML_GET_CONTENT(node));
}

TextNode::~TextNode()
{
}

void TextNode::set_content(const std::string& content)
{
  _content = content;
}

std::string TextNode::get_content() const
{
  return _content;
}


void TextNode::write(xmlDocPtr doc, xmlNodePtr parent) const
{
  //parent will always have a value.

  //Call base class:
  //Node::write(doc, parent);

  //std::cout << "TextNode::write: xmlNewTextChild" << _content << std::endl;

  //xmlNodePtr node = xmlNewTextChild(parent, NULL /* ns */, 0, (const xmlChar*)_content.c_str());
  xmlNodePtr node = xmlNewText((const xmlChar*)_content.c_str());
 
  if(!node)
    throw internal_error("xmlNewText() returned NULL");
  else
  {
     xmlNodePtr nodeChild = xmlAddChild(parent, node);
     if(!nodeChild)
       throw internal_error("xmlAddChild() returned NULL when adding a text node"); 
  }
}

} // namespace xmlpp


