/* node.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_NODES_ELEMENT_H
#define __LIBXMLPP_NODES_ELEMENT_H

#include <libxml++/nodes/node.h>
#include <libxml++/attribute.h>

namespace xmlpp
{

class Element : public Node
{
public:
  explicit Element(xmlNode* node);
  virtual ~Element();

  AttributeList get_attributes() const;
  
  // FIXME: the following only returns explicitely provided
  // attributes, not default ones declared in the dtd.
  Attribute* get_attribute(const std::string& name) const;
  Attribute* set_attribute(const std::string& name, const std::string& value);
  void remove_attribute(const std::string& name);
  
  Attribute* add_attribute(const std::string& name, const std::string& value);

  
  // FIXME: this should be reimplemented in two ways:
  // a) using iterators
  // b) returning a heap-allocated buffer containing the
  //    concatenation of all text node content
  //
  // for now only return the first text node (if any)
  TextNode* get_child_content();
  const TextNode* get_child_content() const;

  // Append a new text node
  TextNode* add_content(const std::string& content = std::string());
  void set_child_content(const std::string& content);

  bool Element::has_content() const;
};

} // namespace xmlpp

#endif //__LIBXMLPP_NODES_ELEMENT_H



