/* document.h
 * this file is part of libxml++
 *
 * copyright (C) 2003 by Stefan Seefeld
 *
 * this file is covered by the GNU Lesser General Public License,
 * which should be included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_DOCUMENT_H
#define __LIBXMLPP_DOCUMENT_H

#include <libxml/tree.h>
#include <libxml/parser.h>

#include <libxml++/exceptions/parse_error.h>
#include <libxml++/exceptions/internal_error.h>
#include <libxml++/nodes/element.h>
#include <libxml++/dtd.h>

namespace xmlpp 
{

class Document;

Document* parse_file(const std::string& filename) throw(exception);
Document* parse_memory(const std::string& contents) throw(exception);
Document* parse_stream(std::istream& is) throw(exception);

class Document
{
  struct Init { Init();};
  
  friend Document *parse_file(const std::string& filename) throw(exception);
  friend Document *parse_memory(const std::string& contents) throw(exception);
  friend Document *parse_stream(std::istream& is) throw(exception);
public:
  Document(const std::string& version = "1.0");
  virtual ~Document();
  
  std::string get_encoding() const;
  Dtd* get_internal_subset() const;
  void set_internal_subset(const std::string& name,
                           const std::string& external_id,
                           const std::string& system_id);
  Element* get_root_node() const;
  Element* create_root_node(const std::string& name,
                            const std::string& ns = std::string(),
                            const std::string& ns_prefix = std::string());

  virtual void write_to_file(const std::string& filename, const std::string& encoding = std::string()) throw(exception);
    
  virtual std::string write_to_string(const std::string& encoding = std::string()) throw(exception);
  
private:
  static Init _init;

  Document(xmlDoc*  doc);
  xmlDoc* _impl;
};

}

#endif
