/* xml++.cc
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#include <libxml++/nodes/commentnode.h>
#include <libxml++/exceptions/internal_error.h>

namespace xmlpp
{

CommentNode::CommentNode(xmlNode* node)
: Node(node)
{}

CommentNode::~CommentNode()
{}

std::string CommentNode::get_content() const
{
  //TODO: Add CommentNode/TextNode base class to share implementation? - It's what the DOM does.
  
  if(cobj()->type != XML_TEXT_NODE &&
      cobj()->type != XML_COMMENT_NODE)
    throw internal_error("this node type doesn't have content");

  return cobj()->content ? (char*)cobj()->content : "";
}

void CommentNode::set_content(const std::string& content)
{
  if(cobj()->type != XML_TEXT_NODE &&
       cobj()->type != XML_COMMENT_NODE)
      throw internal_error("can't set content for this node type");

   xmlNodeAddContent(cobj(), (xmlChar*)content.c_str());
}

} //namespace xmlpp

