/* xml++.cc
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#include <libxml++/nodes/textnode.h>
#include <libxml++/exceptions/internal_error.h>
#include <iostream>

namespace xmlpp
{
  
TextNode::TextNode(xmlNode* node)
: Node(node)
{}

TextNode::~TextNode()
{}

std::string TextNode::get_content() const
{
  if(cobj()->type != XML_TEXT_NODE &&
      cobj()->type != XML_COMMENT_NODE)
    throw internal_error("this node type doesn't have content");

  return cobj()->content ? (char*)cobj()->content : "";
}

void TextNode::set_content(const std::string& content)
{
   if(cobj()->type != XML_TEXT_NODE &&
       cobj()->type != XML_COMMENT_NODE)
      throw internal_error("can't set content for this node type");

   xmlNodeAddContent(cobj(), (xmlChar*)content.c_str());
}

} //namespace xmlpp
