/* xml++.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_PARSERS_DOMPARSER_H
#define __LIBXMLPP_PARSERS_DOMPARSER_H

#include <libxml++/parsers/parser.h>
#include <libxml++/dtd.h>
#include <libxml++/document.h>

#include <libxml/parser.h>
#include <libxml/tree.h>

namespace xmlpp {

/** XML DOM parser.
 *
 */
class DomParser : public Parser
{
public:
  DomParser();
  explicit DomParser(const std::string& filename, bool validate = false);
  virtual ~DomParser();
                                                                                                                        
  virtual void parse_file(const std::string& filename) throw(exception);
  virtual void parse_memory(const std::string& contents) throw(exception);
  virtual void parse_stream(std::istream& in) throw(exception);

  /** Test whether a document has been parsed.
  */
  operator bool() const;
  Document* get_document();
  const Document* get_document() const;
  
protected:
  virtual void parse_context() throw(exception);

  virtual void release_underlying();
  
  Document* _doc;
};




} // namespace xmlpp

#endif //__LIBXMLPP_PARSERS_DOMPARSER_H



