/* node.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_NODES_CONTENTNODE_H
#define __LIBXMLPP_NODES_CONTENTNODE_H

#include <libxml++/nodes/node.h>

namespace xmlpp
{

class ContentNode : public Node
{
public:
  explicit ContentNode(_xmlNode* node);
  virtual ~ContentNode();

  std::string get_content() const;
  void set_content(const std::string& content);

  /// Whether it contains just white space, or is empty.
  bool is_white_space() const;
};

} // namespace xmlpp

#endif //__LIBXMLPP_NODES_TEXTNODE_H




