/* node.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_NODES_NODE_H
#define __LIBXMLPP_NODES_NODE_H

#include <libxml++/noncopyable.h>
#include <string>
#include <list>
#include <map>
#include <vector>

extern "C" {
  struct _xmlNode;
};

namespace xmlpp {

class TextNode;
class Element;
class Attribute;

class Node;
typedef std::vector<Node*> NodeSet;

/** Represents XML Nodes.
 * You should never new or delete Nodes. The Parser will create and manage them for you.
 */
class Node : public NonCopyable
{
public:
  typedef std::list<Node*> NodeList;
  typedef std::list<Attribute*> AttributeList;

  explicit Node(_xmlNode* node);
  virtual ~Node();

  std::string get_name() const;
  void set_name(const std::string & name);

  int get_line() const;;
  
  NodeList get_children(const std::string& name = std::string());
  const NodeList get_children(const std::string& name = std::string()) const;

  Element* add_child(const std::string& name);
  // TODO: how should this work in general (depending on the exact types
  // of parent and child node)
  //   Node* add_child(Node* node);


  /** Remove the child node.
   * @param node The child node to remove. This Node will be deleted and therefore unusable after calling this method.
   */
  void remove_child(Node* node);

  std::string get_path() const;
  NodeSet find(const std::string& xpath) const;

  ///Access the underlying libxml implementation.
  _xmlNode* cobj();

  ///Access the underlying libxml implementation.
  const _xmlNode* cobj() const;

private:
  _xmlNode* _impl;
};

} // namespace xmlpp

#endif //__LIBXMLPP_NODES_NODE_H



