#include "exception.h"

namespace xmlpp {
  
exception::exception(const std::string& message)
: _message(message)
{
}

exception::~exception() throw()
{}

const char* exception::what() const throw()
{
  return _message.c_str();
}

void exception::Raise() const
{
  throw *this;
}

exception * exception::Clone() const
{
  return new exception(*this);
}

} //namespace xmlpp

