/* document.h
 * this file is part of libxml++
 *
 * copyright (C) 2003 by Stefan Seefeld
 *
 * this file is covered by the GNU Lesser General Public License,
 * which should be included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_DOCUMENT_H
#define __LIBXMLPP_DOCUMENT_H

#include <libxml++/exceptions/parse_error.h>
#include <libxml++/exceptions/internal_error.h>
#include <libxml++/nodes/element.h>
#include <libxml++/dtd.h>

extern "C" {
  struct _xmlDoc;
};

namespace xmlpp 
{

class Document;

class Document : NonCopyable
{
  //Ensure that libxml is properly initialised:
  class Init
  {
  public:
    Init();
  };
  
  friend class DomParser;
  
public:
  explicit Document(const std::string& version = "1.0");
  virtual ~Document();
  
  std::string get_encoding() const;
  Dtd* get_internal_subset() const;
  void set_internal_subset(const std::string& name,
                           const std::string& external_id,
                           const std::string& system_id);
  Element* get_root_node() const;

  /** Creates the root node.
   * @param name The node's name.
   * @param ns_uri The namespace URI. A namspace declaration will be added to this node, because it could not have
     been declared before.
   * @param ns_prefix The namespace prefix to associate with the namespace. If no namespace prefix is specified then
     the namespace URI will be the default namespace.
   */
  Element* create_root_node(const std::string& name,
                            const std::string& ns_uri = std::string(),
                            const std::string& ns_prefix = std::string() );

  virtual void write_to_file(const std::string& filename, const std::string& encoding = std::string());
  virtual void write_to_file_formatted(const std::string& filename, const std::string& encoding = std::string());

  virtual std::string write_to_string(const std::string& encoding = std::string());
  virtual std::string write_to_string_formatted(const std::string& encoding = std::string());

private:
  static Init _init;

  Document(_xmlDoc* doc);
  _xmlDoc* _impl;
};

} //namespace xmlpp

#endif //__LIBXMLPP_DOCUMENT_H
