/* xml++.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_PARSER_H
#define __LIBXMLPP_PARSER_H

#ifdef WIN32 //TODO: Why do we do this? murrayc.
#pragma warning (disable : 4786)
#endif

#include <libxml++/nodes/element.h>
#include <libxml++/exceptions/validity_error.h>
#include <libxml++/exceptions/internal_error.h>

#ifdef WIN32 //TODO: Why do we do this? murrayc.
#define vsnprintf _vsnprintf
#endif

extern "C" {
  struct _xmlParserCtxt;
};

namespace xmlpp {

/** XML parser.
 *
 */
class Parser : NonCopyable
{
public:
  Parser();
  virtual ~Parser();

  virtual void set_validate(bool val = true);
  virtual bool get_validate() const;

  virtual void parse_file(const std::string& filename) = 0;
  virtual void parse_memory(const std::string& contents) = 0;
  virtual void parse_stream(std::istream& in) = 0;

protected:
  virtual void initialize_context();
  virtual void release_underlying();

  virtual void on_validity_error(const std::string& message);
  virtual void on_validity_warning(const std::string& message);

  virtual void handleException(const exception& e);
  virtual void check_for_exception();
  virtual void check_for_validity_messages();
  
  static void _callback_validity_error(void* ctx, const char* msg, ...);
  static void _callback_validity_warning(void* ctx, const char* msg, ...);
  
  _xmlParserCtxt* _context;
  exception* _exception;
  std::string _validate_error, _validate_warning; //Built gradually - used in an exception at the end of parsing.

  bool _validate;
};

} // namespace xmlpp

#endif //__LIBXMLPP_PARSER_H



