/* lpp.h --- 23 Oct 1992 Fredric Ihren, <fred@nada.kth.se>  */

#ifdef BSDF
#define LPCOMMAND   "lpr"
#define LPDEVICE    "-P%s"
#define UMASK       077
#else
#define LPCOMMAND   "lp"
#define LPDEVICE    "-d%s"
#define UMASK       022
#endif

#define TMPDIR      "/tmp"
#define LPPPROLOG   "/lpp.ps"
#define LPPOPROLOG  "/lppo.ps"
#define LPPTMP      "/lppXXXXXX"
#define LPPHELP     "/lpp.help"
#define ARGS "#:02456AaBbC:c:D:dEe:F:f:GH:hIiK:k:Ll:M:NnO:o:P:p:qRrSsT:t:U:uVW:w:X:x:Y:z:Z"
#define USAGE "[-02456AaBbdGhIiLNnqrSsuVZ] [-{#CcDFfHKlMOoPpTtUWwXxYz}arg] [files]"

#define STDIN (char *) NULL
#define fprintc(f,c) (void) fputc(c,f)
#define fprints(f,s) (void) fputs(s,f)
#define vfprintf (void) fprintf
#define vsprintf (void) sprintf
#define vstrcat (void) strcat
#define ends(s) s + strlen(s)
#define NL (!quiet && files) ? "\n" : ""
#ifndef OSFF
#define TRUE  (1)
#define FALSE (0)
extern long time();
#endif /* OSFF */

extern int exit();
extern char *mktemp();
extern char *malloc();
extern char *getenv();
