.TH LPP 1 "14 Dec 1994" ""
.SH NAME
lpp \- convert textfiles to PostScript and print with many different formats
.SH SYNOPSIS
.B lpp
[
.B \-02456AaBbdGhIiLNnqRrSuV \]
[
.BI \-# copies \ ]
[
.BI \-C string \ ]
.br
[
.BI \-c number \ ]
[
.BI \-D datestring \ ]
[
.BI \-e number=glyphname \ ]
.br
[
.BI \-F fontspec \ ]
[
.BI \-f fontsize \ ]
[
.BI \-H fontspec \ ]
[
.BI \-K number \ ]
.br
[
.BI \-k number \ ]
[
.BI \-l number \ ]
[
.BI \-M number \ ]
[
.BI \-O number \ ]
.br
[
.BI \-o numbers \ ]
[
.BI \-T title \ ]
[
.BI \-t number \ ]
[
.BI \-U userstring \ ]
.br
[
.BI \-W datestring \ ]
[
.BI \-w number \ ]
[
.BI \-X string \ ]
[
.BI \-x file \ ]
.br
[
.BI \-Y number \ ]
[
.BI \-z number \ ]
[
.BI \-p outfile \ ]
[
.BI \-P printer \ ]
.br
[
.I file \]
[
.I options \ ]
[
.I file
|
.I \- \] ...
.SH DESCRIPTION
.I lpp
reads textfiles, converts them into PostScript and spools
them to a PostScript printer. Options make it possible to change
between different formats, decide how to treat long lines, change fonts,
change headings, and so on.
.sp
The following command
.RS
% lpp example.c
.RE
prints the file example.c on the printer defined by the environment
variable PRINTER
using the default format, i.e., 72 lines per page, borders, information
about current date, last modification date of the file and users name.
.RS
% lpp \-V \-Plw fish \-5 fish.p \-4Sbi \-FHelvetica brev.txt
.RE
prints a very compact listing (300 lines per page in two columns) of
the file called fish on the printer ``lw'' together with
an A5 listing of fish.p and finally the file brev.txt in A4 format, with
swedish characters, no border or heading at all in a proportional font.
.sp
Options can be added anywhere on the command line mixed with files.
Everything is sent to the printer
as one large job rather than several small ones.
Options usually apply to
.I all
remaining files on the command line,
so the order of options and files is important.
The only exceptions are
.br
.B \-A
(append),
.B \-T
(title),
.B \-W
(writedate),
.B \-C
(comment) and
.B \-G
(banner). These five options will only affect the
very next file on the command line.
.sp
The environment variable LPP may be used to specify defaults. It is
parsed as a string of options before the arguments on the commandline
are read. For example
.RS
% setenv LPP '\-a \-n'
.RE
sets the pagesize to be US letter and layout to be ``enscript-like''.
.sp
Piped input is detected in two ways: as usual a commandline without
file arguments causes
.I lpp
to read stdin (i.e., the keyboard or from a pipe)
but stdin can also be indicated with `\-' (a single dash). This makes it
possible to mix files and stdin input. However, a `\-' after a
.B \-p
option (output to file) is interpreted as ``output to stdout''. So
.RS
% lpp \-p\- \- file2
.RE
means output stdin and file2 on stdout.
.B \-p \-
is ``output to stdout'' and the second dash means ``input from stdin''.
.SH OPTIONS
.TP
.B \-4 \-5 \-6 \-L \-V
Use the page formats A4, A5, A6, Landscape and Very Compact
respectively.
The table below summarize the formats. Page format options
will change fontsize, baselineskip, pagelength, wraplength and margins.
Previous
.I f, Y, O
and
.I M
options will be cancelled.
.sp
.ta +0.4iC +0.9iR +1.2iR +1.2iR +1.6iR
.I 	name	fsize	lines/page	char/line	landscape	
.br
	-4	10	72	82	portrait
.br
	-5	7.5	2* 66	82	landscape
.br
	-6	5	4* 72	82	portrait
.br
	-L	10	48	128	landscape
.br
	-V	5	2*150	82	portrait
.TP
.B \-a
Use US pagesize letter (8.5x11") instead of default A4.
This option should be placed
.I before
any file arguments and format options, because the page formats
change somewhat (and A4, A5 and A6 are no longer good names).
.sp
.ta +0.4iC +0.9iR +1.2iR +1.2iR +1.6iR
.I 	name	fsize	lines/page	char/line	landscape	
.br
	-4	10	67	85	portrait
.br
	-5	7	2* 73	82	landscape
.br
	-6	5	4* 66	82	portrait
.br
	-L	10	49	120	landscape
.br
	-V	5	2*140	82	portrait
.TP
.B \-0
Delete the output when done instead of spooling it. This is useful for
checking the amount of lines and pages without actually printing anything.
.TP
.B \-2
Make output doublesided (if possible) by using the
setduplexmode feature available on (at least) DEC ps20.
.TP
.B \-A \-AA
Simply append next file to the present one instead of treating it as a new
file. So
.ti +1i
% lpp file1 \-A file2 \-A file3
.br
is identical to
.ti +1i
% cat file2 file3 | lpp file1 -
.br
.B \-AA
is like
.B \-A
but a logical formfeed is inserted before appending the file.
.TP
.B \-B \-b
.B \-B
means draw border lines (default).
.B \-b
turns it off.
.TP
.BI \-C comment
Print the string
.I comment
after the title.
.TP
.BI \-c number\  \-c number,x
Use a pageformat with
.I number
columns in same orientation (portrait or landscape) and with same fontsize,
pagelength and margins as previous format.
If previous format had only one column (-4, -L or -c1) the current value
of wraplength will determine the width of the resulting columns, otherwise
default values will be used. If a second parameter
.I x
is specified, it will be the spacing between columns in mm (default 5).
.TP
.BI \-D datestring
Use
.I datestring
instead of the system date information.
.TP
.BI \-d
Don't print the date- and user-information.
.TP
.BI \-e number=name
Set the encoding entry for character
.I number
to be
.I name.
Example: all numbersigns will print as the pound sterling symbol
with option -e35=sterling. Note that if the character specified as
.I name
isn't available in the font, it will print as a blank.
.TP
.BI \-F fontname
Use the font
.I fontname
instead of Courier. Example: Times-Roman, Courier-Bold...
.TP
.BI -f number
Use
.I number
as the fontsize and adjust the numbers of lines per page and characters
per line (wraplength).
Fontsizes are measured in points (1 pt = 1/72 inch).
.TP
.BI \-G
Generates an extra bannerpage after the file with the title written
in a large fancy font and with comment and information below.
.TP
.BI \-H font
Set font for title.
.TP
.B \-h
Help. Display short info about
.I lpp
and quit.
.TP
.B \-I \-i
With option
.B \-i
info-header and border lines are omitted for lineprinter imitation.
Opposite is
.B \-I
(default).
.TP
.BI \-K number
Kills parts of lines longer than
.I number
characters.
.TP
.BI -k number
Set wraplength to
.I number
characters per line and adjust the pagelength so same length of page is used.
If
.B \-R
otion has been used the resulting values is printed.
.TP
.BI \-l number
Set pagelength to
.I number
lines. No check is made if this fits on the page.
.TP
.BI \-M x \ \-M x,y
moves the output text
.I x
mm right (25.4 mm = 1 inch) or
moves
the output text both
.I x
mm right and
.I y
mm down.
.TP
.B \-N
Number the output lines.
.TP
.BI \-n
Use ``enscript-like'' layout. Gray field under title, thin lines,
no border, different information. This option
can only be used before first file argument.
.TP
.BI \-O number
Wrap lines longer than
.IR number
characters into two (or more) lines.
.BI -O 0
means don't wrap at all.
.TP
.B \-o 'a b c d ...'
Define a new pageformat. The argument
should be a list of integers within quotes:
.ti +0.5i
number of logical pages (columns etc),
.ti +0.5i
pagelength (lines per logical page),
.ti +0.5i
linelength (wraplength),
.ti +0.5i
fontsize,
.ti +0.5i
drawlines,
.ti +0.5i
X and Y (in pt) for first line of logical pages
.br
The integer drawlines should be a sum of any of these options:
vertical line = 1, horisontal line = 2, landscape vertical line = 4,
landscape mode = 8
.br
Example:
.br
% lpp -o'3 150 52 5 0 46 778 223 778 400 778'
.br
makes a 3 column, 150 lines per column, 52 characters per line format.
.TP
.B \-R
causes 
.I lpp
to report the calculated values of subsequent
.B \-f \-k \-w and \-Y
options.
.TP
.BI \-P printer
causes the output to be sent to the named printer rather than to
the default printer (defined by the environment variable PRINTER).
.TP
.BI -p outfile
causes the PostScript file to be written to the named
file rather than being spooled for printing. This can only be used
before the first file argument.
Specially,
.B \-p\-
will send to the standard output.
.TP
.B \-q
Causes
.I lpp
to be quiet. Normally
.I lpp
informs you of lines and pages of files, total pages, and which printer
or file the output is sent to.
.TP
.B \-S \-SS \-s \-r
.B \-S
changes character encoding to swedish ISO 646
.br
   (characters }{|][\\)
.br
.B \-SS
changes character encoding to swedish ISO 646
.br
   nameversion (characters @`^~}{|][\\).
.br
.B \-s
changes back to default character encoding
.br
.B \-r
By default
.I lpp
uses character encoding
.I ISO 8859-1
which is identical to
ASCII for characters 0-127.
This option turns off this encoding-switching so that the device
default encoding will be used. For fonts specified with the
.I \-F
option after this option the font default encoding will be used
(this is necessary for fonts with special encoding, like Symbol).
.TP
.BI \-T string
Supply title. Default is the filename specified on the
commandline. This option applies only to the next file.
.TP
.BI \-t number
Set tabstop width (default 8).
.TP
.B \-ts \-tx
With the option
.I \-ts
lpp will insert spaces at tabs so the number of characters will be a multiple
of the tabstop width. This affects proportional fonts only. Option
.I \-tx
is the default, which is instead inserting space so that
the position will be a multiple of the tabstop width, measured in widths
of the character 'X'. This will try to keep tabstop columns straight also in
a proportional font.
.TP
.BI \-U string
Supply user information string.
Default is "real name <user@host>".
.TP
.B \-u
Suppress printing user information on output.
.TP
.BI \-W string
Supply file write date for the next file.
.TP
.BI \-w number
Adjust font size so exactly
.I number
lines is written on each logical page and adjust wraplength.
.TP	
.BI \-X 'code'
Execute PostScript.
The parameter should be PostScript code within quotes.
Example:
.br
% lpp -X'0 setlinewidth' radium.ddt
.br
prints the file with extra thin border lines.
.TP
.BI \-x file
Read
.I postscript
commands from
.IR file [.ps]
and insert into output. Current directory is searched first,
then library directory (can be overruled with environment
variable PSLIBDIR, see ENVIRONMENT).
.TP
.BI \-Y number
Change baselineskip to
.I number
pt. Pagelength is adjusted accordingly.
.TP
.B \-Z
Normally control characters (code 0-31) are output as they are, and
print as blanks unless changed with option -e. With option -Z they print as
``^X'' where X is the the character corresponding to the code plus 64.
.TP
.BI \-z number
Set maximum allowed number of control characters (code 0-31 except newline,
return, formfeed, tab, backspace) in file. If more than
.I number
are found in a file, it will be considered to be a non text file and
printing will be aborted. If
.I number
is 0 no control character check will be made. Default is 5.
.TP
.BI \-# number
Causes
.I number
copies of the output to be produced. The default is one.
.SH ENVIRONMENT
.IP LPP
String of options to be used by
.I lpp.
.IP PSLIBDIR
Path name of a directory to use instead of @LIBDIR@
for
.I lpp
prologue and other files.
.IP PSTEMPDIR
Path name of temp directory to use instead of /tmp.
.IP PRINTER
The name of the printer
.I lpr
should use. The
.B \-P
option to
.I lpp
overrides this.
.SH FILES
.TP 2.2i
@LIBDIR@/lpp.ps
The PostScript prologue sent ahead of the file.
.TP
@LIBDIR@/lpp.help
A short help file typed on the screen when invoking
.I lpp
with the
.B \-h
option.
.SH "SEE ALSO"
enscript(1), lpr(1), lpq(1), lprm(1).
.SH AUTHORS
.I lpp
program and PostScript prologue by Fredric Ihren <fred@nada.kth.se>.
Initial help by Johan Ihren, NADA, KTH <johani@nada.kth.se>.
.SH NOTES
PostScript is a trademark of Adobe Systems Incorporated.
Times and Helvetica are registered trademarks of Linotype.
