#include <stdio.h>
#include "lpp.h"

extern int quiet; /* for NL */
extern int files; /* for NL */

/* Global variables. */
static char EMSG[] = "";
int    getoptindex = 1;	/* index into argv vector     */
int    optopt;		/* char checked for validity  */
char   *optarg;		/* arg associated with option */

char   *getoptp = EMSG; /* debug option letter processing */

/* Linked in later. */
extern char *strchr();	/* This may be strchr */

getopts(nargc,nargv,ostr)
  int nargc;
  char **nargv;
  char *ostr;
  {
  register char	*oli;		/* option letter list index */

  if (!*getoptp)			/* update scanning pointer */
    {
    if (getoptindex >= nargc || *(getoptp = nargv[getoptindex]) != '-'
      || !*++getoptp)  return(EOF);
    if (*getoptp == '-')		/* found "--" */
      {
      getoptindex++;
      return(EOF);
      }
    }
  /* option letter okay? */
  if ((optopt = *getoptp++) == ':' || (oli = strchr(ostr, optopt)) == NULL)
    {
    if (!*getoptp)
      getoptindex++;
    vfprintf(stderr,"%s%s: illegal option -%c\n",NL,*nargv,optopt);
    goto Bad;
    }
  if (*++oli != ':')		/* don't need argument */
    {
    optarg = NULL;
    if (!*getoptp) getoptindex++;
    }
    else			/* need an argument */
    {
	if (*getoptp)
          optarg = getoptp;	/* no white space */
	else
	  if (nargc <= ++getoptindex)
	  {
	    getoptp = EMSG;
            vfprintf(stderr,"%s%s: option -%c requires an argument.\n",
              NL,*nargv,optopt);
	    goto Bad;
	  }
	  else
	    optarg = nargv[getoptindex];	/* white space */
	getoptp = EMSG;
	getoptindex++;
    }
    return(optopt);		/* dump back option letter */
Bad:
    return('?');
}
