(defun extract-configuration-option (option)
  (if (string-match (concat "\\([\"']\\)?"
			    (regexp-quote option) "\\(=\\|\\s-+\\)")
		    system-configuration-options)
    (let ((start (match-end 0))
	  (dquot nil)
	  (squot nil)
	  (i nil)
	  (start (match-end 0))
	  (end nil)
	  (result nil))
      (setq i start)
      (if (match-beginning 1)
	  (if (eq (elt system-configuration-options (match-beginning 1)) ?')
	      (setq squot t)
	    (setq dquot t)))
      (while (and (not end) (< i (length system-configuration-options)))
	(let ((c (elt system-configuration-options i)))
	  (cond ((and (eq c ?')  (not dquot)) (setq squot (not squot)))
		((and (eq c ?\") (not squot)) (setq dquot (not dquot)))
		((eq c ?\\) (setq start (1+ start)))
		((and (or (eq c ?\ ) (eq c ?\t) (eq c ?\r) (eq c ?\n))
		      (not squot)
		      (not dquot))
		 (setq end i))
		(t (setq result (cons c result)))))
	(setq i (1+ i)))
      (concat (nreverse result)))))


(defun extract-site-lisp-dir ()
  (let ((path load-path)
	(result nil))
    (while path
      (if (string-match "/site-lisp" (car path))
	  (progn (setq result (car path))
                 (setq path nil))
	(setq path (cdr path))))
    result))

(defun extract-autoconf-data ()
  (let ((prefix (extract-configuration-option "--prefix"))
	(datadir (extract-configuration-option "--datadir"))
	(infodir (extract-configuration-option "--infodir"))
	(lispdir (extract-site-lisp-dir))
	(version (format "%S.%S" emacs-major-version emacs-minor-version)))
    (and prefix  (message "xprefix=%s"  prefix))
    (and datadir (message "xdatadir=%s" datadir))
    (and infodir (message "xinfodir=%s" infodir))
    (and lispdir (message "xlispdir=%s" lispdir))
    (and version (message "xversion=%s" version))))
