;;;;; -*-coding: raw-text;mode: emacs-lisp;-*-
;;;;; $Id: vars.el.in,v 44.123 2000/09/01 14:13:27 byers Exp $
;;;;; Copyright (C) 1991, 1996  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM server.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: vars.el
;;;;
;;;; This file contains almost all the variables used in lyskom.
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: vars.el.in,v 44.123 2000/09/01 14:13:27 byers Exp $\n"))

(defvar lyskom-mule-compiled
  (eval-when-compile (and (fboundp 'multibyte-string-p)
                          (multibyte-string-p "")))
  "Non-nil if the client was compiled with multibyte characters enabled")

(provide 'lyskom)

(require 'lyskom-defvar "defvar")

(defconst lyskom-global-boolean-variables '(
  kom-created-texts-are-read
  kom-dashed-lines
  kom-presence-messages
  kom-print-number-of-unread-on-entrance
  kom-read-depth-first
  kom-reading-puts-comments-in-pointers-last
  kom-confirm-multiple-recipients
)
  "List of flags that are to be saved as booleans in the common block.

Dont change this. These are defined by the protocol.")
				  
(defconst lyskom-global-non-boolean-variables '(
  kom-default-mark
)
  "List of flags that are to be saved in the common block.
These are the non-boolean ones. See: lyskom-global-boolean-variables.

Dont change these. These are defined by the protocol.")



(defun lyskom-protect-variable (sym) 
  (put sym 'permanent-local t)
  (lyskom-local-variable sym)
  (add-to-list 'lyskom-protected-variables sym))

(defun lyskom-local-variable (sym)
  (add-to-list 'lyskom-local-variables sym))

(defun lyskom-inherited-variable (sym)
  (add-to-list 'lyskom-inherited-variable sym)
  (lyskom-protect-variable sym))

(defun lyskom-setup-local-variables ()
  (mapcar 'make-local-variable lyskom-local-variables)
  (mapcar 'make-local-hook lyskom-local-hooks))

(defvar lyskom-is-loaded nil
  "Non-nil when lyskom has been loaded.")


(def-kom-var kom-dont-read-saved-variables '(kom-dont-read-saved-variables
                                             lyskom-login-hook)
  "*Non nil means don't read some variables from the server.
t means don't read any variables. A list means don't read variables that
are in the list.")



;;;; ================================================================
;;;;                     Variables and constants.


;;; User flags

(def-kom-var kom-allow-incompleteness nil
  "*If nil, commands like kom-list-news will wait for the prefetch.
If this flag is set to t, some commands may give incomplete answers,
but it might give them faster, especially during the login phase."
  server
)

(def-kom-var kom-bury-buffers t
  "*Controls the behaviour of kom-next-kom and its cousins.
If this variable is non-nil the current buffer is sent to the back
of the buffer list when one of the commands `kom-next-kom',
`kom-previous-kom' or `kom-next-unread-kom' is invoked."
  server)

(def-kom-var kom-write-texts-in-window nil
  "*Where to edit texts. One of nil, other, new-frame, other-frame, a string
or a buffer.

nil means edit texts in the same window as the LysKOM buffer.
other means edit in another window, creating it if necessary.
other-frame means edit in another frame, if there is one.
new-frame means create a new frame for editing. The frame will be removed 
          when editing is finished.
a string or buffer means edit in the indicated buffer."
  server)

(def-kom-var kom-view-commented-in-window 'other
  "*Where to view commented texts. See kom-write-texts-in-window for details"
  server)

(def-kom-var kom-edit-filters-in-window nil
  "*Where to edit filters. See kom-write-texts-in-window for
more information."
  server)

(def-kom-var kom-list-membership-in-window 'other
  "*Where to list membership. See kom-write-texts-in-window for
more information."
  server)

(def-kom-var kom-personal-messages-in-window 'other
  "*Where to display personal messages. See kom-write-texts-in-window 
for more information."
  server)

(def-kom-var kom-customize-format 'long
  "*Format of the customize buffer. Must be long or short."
  server)

(def-kom-var kom-user-prompt-format "%[%c% %m%] - "
  "*Format of LysKOM prompt when waiting for input."
  server)


(def-kom-var kom-user-prompt-format-executing "%[%c% %m%]."
  "*Format of LysKOM prompt when executing a default command"
  server)


(def-kom-var kom-enabled-prompt-format "%[%c% %m%] # "
  "*Format of LysKOM prompt when in enabled mode."
  server)


(def-kom-var kom-enabled-prompt-format-executing "%[%c% %m%]."
  "*Format of LysKOM prompt when executing a default command in 
enabled mode."
  server)

(def-kom-var kom-anonymous-prompt-format "%[%c% %m%] (%a) - "
  "*Format of the LysKOM prompt when running anonymously."
  server)

(def-kom-var kom-anonymous-prompt-format-executing "%[%c% %m%] (%a)."
  "*Format of the LysKOM prompt when executing a command anonymously."
  server)

(def-kom-var kom-show-week-number t
  "*If non-nil show the ISO week number when displaying the time."
  server)


(def-kom-var kom-cite-string ">"
  "*String to insert before each line of a commented text."
  server)

(def-kom-var kom-created-texts-are-saved nil
  "*If non-nil, save all created texts to a file. 
The value of this variable is the file name on which to save new texts."
  server
  inherited)

(def-kom-var kom-created-texts-are-read t
  "*Non-nil means automatically mark texts that you create as read."
  server)

(def-kom-var kom-customize-in-window nil
  "*Where to customize LysKOM. See kom-write-texts-in-window"
  server)

(def-kom-var kom-prioritize-in-window nil
  "*Where to prioritize conferences. See kom-write-texts-in-window"
  server)

(def-kom-var kom-default-mark 100
  "*If non-nil (must be an integer) then the user is not asked for type of mark."
  server)

(def-kom-var kom-reading-puts-comments-in-pointers-last t
  "*If Non-nil the texts are shown with comments references at the end."
  server
  inherited)

(def-kom-var kom-postpone-default 17
  "*The number of articles to postpone by default."
  server)


(def-kom-var kom-dashed-lines t
  "*If Non-nil then all texts will be surrounded by lines of dashes."
  server
  inherited)

(def-kom-var kom-long-lines nil
  "*If non-nil, then some lines and borders will be made longer."
  server
  inherited)

(def-kom-var kom-text-footer-dash-length 52
  "*If non-nil, the total length of the text footer, when dashes are in use.
Note that the footer may end up longer than this if one or more elements
together are longer than this length.

This length is currently ignored when kom-text-footer-format is used."
  server
  inherited)

(def-kom-var kom-text-header-dash-length 60
  "*If non-nil, the total length of the dashes before a text body.
If kom-dashed-lines is non-nil, this is ignored."
  server
  inherited)



(def-kom-var kom-text-footer-format nil
  "*If non-nil, this specifies the format of a text footer.

The following format directives are legal:

    %n      The text number.
    %p      The number of the author.
    %P      The name of the author
    %-      A bunch of dashes
    %f      Information about the text in parentheses.

Format letters can be prefixed with a number specifying the minimum
field width. The field width can be prefixed with an equals sign which
means that the field is exactly as wide as specified (contents may be
truncated.) A negative field width means left justify the contents.

The field width of %- is special. It specifies the maximum number of
dashes the print. The actual number will be the maximum minus the
length of the author's name, if it is included anywhere in the format
string.

When set, this variable overrides kom-dashed-lines and
kom-show-author-at-end.

The default format is equivalent to the following strings, depending on 
the settings of kom-dashed-lines and kom-show-author-at-end.

kom-dashed-lines    kom-show-author-at-end      Format
t                   t                           \"(%n) /%P/%42-%f\"
t                   nil                         \"(%n) %42-%f\"
nil                 t                           \"(%n) /%P/ %f\"
nil                 nil                         \"(%n) %f\"
"
  server
  inherited)



(def-kom-var kom-show-creating-software nil
  "*If non-nil then show the creating software of each text, if specitfied."
  server
  inherited)

(def-kom-var kom-show-author-at-end t
  "*If non-nil then the author will be shown at the end of each text."
  server
  inherited)

(def-kom-var kom-truncate-threshold nil
  "*If non-nil, truncate long texts when revieiwing.
If the text is longer (in lines) then the threshold it will be
truncated to `kom-truncate-show-lines' length."
  server)

(def-kom-var kom-truncate-show-lines 10
  "*How many lines to show after truncating.
If the text is truncated by `kom-truncate-threshold', show this many
lines.  If this is greater than the threshold, the threshold will be
used."
  server)


(def-kom-var kom-print-number-of-unread-on-entrance t
  "*If Non-nil then print automatically the number of unread articles when
entering a conference."
  server)

(def-kom-var kom-show-unread-in-frame-title t
  "*If non-nil, then show an unread indicator in the frame title of each
LysKOM session."
  server)

(def-kom-var kom-presence-messages t
  "*If non-nil, lyskom prints continuous info about what other people are doing.
Info is printed on the message line and never in the buffer. If minibuffer is
used then no message is printed.

A list of integers means show messages for those users.

The value 'friends means show messages for the users in kom-friends.

The value 'morons means show messages for the users in kom-morons.

The value 'friends-and-morons means show messages for the users in 
kom-friends and kom-morons.

If you want the messages in the buffer you could set the variable 
kom-presence-messages-in-buffer."
  server)

(def-kom-var kom-presence-messages-in-buffer nil
  "*If t, lyskom prints information about what other people are doing in buffer.
All printing is done just before the prompt.
If nil no messages are printed.
If 'presence then messages about people logging in, out and people 
changing name is printed."
  server)

(def-kom-var kom-show-where-and-what t
  "*Non-nil means kom-who-is-on shows from which machine the user is running
and what he is doing."
  server)

(def-kom-var kom-show-since-and-when nil
  "*Non-nil means kom-who-is-on shows when the user connected and when
he was active last."
  server)

(def-kom-var kom-idle-hide 30
  "*The number of minutes of idle-time before a user is excluded from the list
of users. This can be overridden by a prefix argument to `kom-who-is-on'."
  server)

(def-kom-var kom-show-footnotes-immediately t
  "*Non-nil means show footnotes immediately following the text."
  server)

(def-kom-var kom-follow-comments-outside-membership nil
  "*Show comments in conferences you are not a member of.

If this variable is nil, texts with no recipient you are a member of
will not be shown."
  server)

(def-kom-var kom-follow-attachments t
  "*Follow attachments as if they are regular comments."
  server)

;;(def-kom-var kom-who-buffer-size-when-displaying 10
;;  "Size of window to display the who-buffer.
;;This is used when executing the kom-display-who-buffer command."
;;  server)

(def-kom-var kom-read-depth-first t
  "*Non-nil means read comments and footnotes to a text before other texts."
  server)

(def-kom-var kom-continuous-scrolling t
  "*Non-nil means scroll LysKOM window as text is inserted. The last viewed
position (generally the most recent prompt) will always be visible."
  server)


;; Should this be set to nil if baud-rate is low?
(def-kom-var kom-deferred-printing t
  "*Non-nil means delay printing of some information not in the cache.
You might want to turn this off to have the old, linear behaviour."
  server)

(def-kom-var lyskom-defer-indicator "[...]"
  "String to display while LysKOM is waiting for the real string.")

(def-kom-var kom-review-priority nil
  "*If non-nil, the priority to use when reviewing texts. Set this to
255 or higher to avoid texts and conferences with higher priority to
break in while reviewing."
  server)

(def-kom-var kom-higher-priority-breaks nil
  "*Non-nil means allow texts from conferences with highter priority to break in.
If the value is 'express then texts are allowed to break in the middle of a
comment chain.  Otherwise we don't let them in until the end of the comment
tree."
  server)

(def-kom-var kom-server-priority-breaks nil
  "*Non-nil means allow servers with a higher priority to break in.
Valid values are express, express-letters, letters, after-conf, 
after-conf-letters, t and when-done.

express means break immediately when a text arrives in a prioritized
session.

express-letters means break immediately when a letter arrives in a 
prioritized session.

t means break after the current comment chain when a text arrives in 
a prioritized session.

letters means break after the current comment chain when a letter
arrives in a prioritized session.

after-conf means break after the current conference when a text
arrives in a prioritized session.

after-conf-letters means break after the current conference when a
letter arrives in a prioritized session.

when-done means prompt user to go to the next session with unreads
after everything has been read. This overrides kom-do-when-done as
long as there are sessions with unread texts.
"
  server)

(def-kom-var lyskom-view-text-hook nil
  "*Hook that is called before a text is shown. When the hooks are
called, lyskom-view-text-text is bound to the text mass of the 
text and lyskom-view-text-text-stat to the text-stat of the text
to be shown."
  local-hook)


(def-kom-var lyskom-send-message-hook '(lyskom-send-message-trim-newlines)
  "*Hook that is called before a personal, group or common message is sent. 

When called, lyskom-message-string is bound to the message that will be sent
and lyskom-message-recipient to the conf-stat of the recipient or nil if
the recipient does not exist or if the message is a common message.

If lyskom-message-string is set to nil by a hook, the message will not
be sent."
  local-hook)

(def-kom-var lyskom-send-message-setup-hook nil
  "*Hook that is called when the minibuffer is entered to read a message."
  local-hook)

(def-kom-var lyskom-send-message-exit-hook nil
  "*Hook that is called when the minibuffer is exited after reading a message."
  local-hook)

(def-kom-var lyskom-send-text-hook nil
  "*Hook that is called before sending a text. Hook functions return t to
signal suggess and nil to prevent the text from being sent."
  local-hook)

(def-kom-var lyskom-after-load-hook nil
  "*Hook to run once after lyskom is loaded.")

(def-kom-var lyskom-change-conf-hook nil
  "*Hook to run when changing conferences.
The functions in this list are run with two arguments. The first is the 
current conf-no and the second is the conf-no being changed to."
  local-hook)

(def-kom-var lyskom-login-hook nil
  "*What to do when logged in.
This hook is called after we have logged in but before and command is
accepted from the keyboard. It is called immediately before
kom-login-hook."
  local-hook)

(def-kom-var kom-login-hook nil
  "*What to do when logged in.
This is a list of commands that are executed after we have logged in but before
any command is accepted from the keyboard. See also lyskom-login-hook."
  server)

(def-kom-var kom-confirm-add-recipients t
  "*When non-nil, offer to add cc-recipient instead of full recipient."
  server)


(def-kom-var kom-do-when-done '(kom-review-all-marked-texts kom-display-time)
  "*What to do when all texts are read.
This is a list of commands and lists of commands that are prompted for
and executed when there are no more new texts.  The last element in
the list is the one that will never be removed from the list.
A command can be one of:
type			prompt
lyskom-function		from the lyskom-command-name function.
command			\"Kommandot:\" name of function or definition of
			lambda expression
keyboard macro		\"Kommandot:\" keyboard macro definition."
  server)

(def-kom-var kom-page-before-command nil
  "*This is a list of all commands before which the screen is cleared.
If it isn't a list and isn't nil the screen is cleared before all commands."
  server)

(def-kom-var kom-permissive-completion t
  "*If t, completion on logged-in persons will usually also include
persons who are not logged in. Values other than t or nil are reserved
for future use."
  server)

(def-kom-var kom-unsubscribe-makes-passive t
  "*If non-nil subtracting oneself from a conference makes the membership
passive. A second leave will actually remove the membership."
  server)

(def-kom-var kom-membership-default-priority 'ask
  "*Default priority when joining a new conference.
If a valid priority then new conferences are read with this priority. 
Otherwise ask the user for a priority.

Valid priorities are only the range 0-255."
  server)

(def-kom-var kom-membership-default-placement 'last
  "*Tells the system where to put new conferences.
The value can be one of the following:
'first => before all other conferences.
'last => after all other conferences.
a number => at that position
otherwise => the new conf is entered after all conferences."
  server)

(def-kom-var lyskom-current-prompt nil
  "The current prompt or nil.
This is either nil, indicating that there is currently no prompt, or
one a symbol indcating which command is prompted in the LysKOM buffer."
  local)

(def-kom-var lyskom-current-prompt-text nil
  "The current prompt text or nil.
This is either nil, indicating that there is currently no prompt, or
a string indicating the prompt shown in the LysKOM buffer."
  local)

(def-kom-var lyskom-current-prompt-args nil
  "The current prompt arguments
These are arguments used to format the current prompt."
  local)

(def-kom-var lyskom-need-prompt-update nil
  "Non-nil if all prompts need to be updated."
  local)

(def-kom-var kom-show-personal-messages-in-buffer t
  "*Buffer to show personal messages in.
If nil, discard them.
If t, insert them in the *kom* buffert.
If non-nil and non-t this should be a buffer or a name of a (possibly
nonexistent) buffer in which the message is inserted."
  server)

(def-kom-var kom-pop-personal-messages nil
  "*Non-nil means pop up a buffer with personal messages as they arrive.
kom-show-personal-messages-in-buffer decides which buffer to pop."
  server)

(def-kom-var kom-ding-pause-amount 0.1
  "*Amount of time to wait between successive beeps.")

(def-kom-var kom-ding-on-new-letter nil
  "*Non-nil means ding if a message arrives in the letter box. See 
kom-ding-on-priority-break for valid values."
  server)


(def-kom-var kom-ding-on-priority-break 1
  "*Non-nil means ding if a higher priority text or conference breaks in.
A number means the number of times to ding. A string is an argument for the
program named by kom-audio-player."
  server)

(def-kom-var kom-ding-on-wait-done 1
  "*Non-nil means ding when busy-waiting finishes.
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as a 
function to call."
  server)

(def-kom-var kom-ding-on-common-messages 0
  "*Non-nil means ding as alarm messages arrive. 
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as
a function to call. A list consisting of pairs (KEY . VALUE) is used
for fine-grained control. The list is searched for a pair where KEY
matches the sender identity. The corresponding VALUE is used as the
specification on how to beep."
  server)

(def-kom-var kom-ding-on-group-messages 1
  "*Non-nil means ding as group messages arrive.
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as
a function to call. A list consisting of pairs (KEY . VALUE) is used
for fine-grained control. The list is searched for a pair where KEY
matches the recipient identity. The corresponding VALUE is used as the
specification on how to beep."
  server)

(def-kom-var kom-ding-on-personal-messages 2
  "*Non-nil means ding as personal messages arrive.
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as
a function to call. A list consisting of pairs (KEY . VALUE) is used
for fine-grained control. The list is searched for a pair where KEY
matches the sender identity. The corresponding VALUE is used as the
specification on how to beep."
  server)


(def-kom-var kom-ding-on-no-subject 2
  "*How to ding if the user has not entered a subject line.
A number means the number of times to ding. A string is an argument for the
program named by kom-audio-player. A symbol is interpreted as a function 
to call."
  server)


(def-kom-var kom-audio-player "audioplay"
  "*Program to play audio files."
  server)


(def-kom-var kom-ignore-message-senders nil
  "*List of senders whose personal, group and alarm messages are ignored."
  server)

(def-kom-var kom-ignore-message-recipients nil
  "*List of recipients you do not want group messages to."
  server)

(def-kom-var kom-show-personal-message-date t
  "*Show date on personal messages is non-nil."
  server)

(def-kom-var kom-default-message-recipient 'group
  "*Determines default recipient of personal messages.

everybody means the default recipient is everybody.
group     means the default recipient is the group to which the last
          message was sent, if it was a group message. If the last message
          was a personal message or a common message, it means the same as 
          sender. 
sender    means the sender of the last message received."
  server)


(def-kom-var lyskom-filter-outgoing-messages t
  "*t if outgoing remote-control messages and automatic replies are not
to be displayed in the buffer."
  server)


(def-kom-var kom-friends nil
  "*List of people whose names should be formatted using kom-friends-face."
  server)

(def-kom-var kom-morons nil
  "*List of people whose names should be formatted using kom-morons-face."
  server)

(def-kom-var kom-dont-check-commented-authors nil
  "*List of recipients who do not need to be added to comments that they
might not see. Typically this list consists of import agents."
  server)

(def-kom-var kom-default-face-scheme nil  
  "*Face scheme to use per default for new logins.")

(def-kom-var kom-smileys t
  "*Non-nil means to reformat smileys in text."
  server)

(def-kom-var kom-text-properties t
  "*Non-nil means to insert text properties in the Emacs buffer for
various LysKOM elements.")

(def-kom-var kom-use-button-hints t
  "*Non-nil means use button hints for overriding default actions.")

(def-kom-var kom-autowrap t
  "*Non-nil means auto wrap articles with discretion.
A number means wrap articles shorter than the number (in bytes)."
  server)

(def-kom-var kom-keep-alive-interval 180
  "*The number of seconds between periodic requests used to keep the session alive"
  server)

(defvar lyskom-transforming-external-text nil
  "Dynamically bound to non-nil when transforming text in which text,
conference and person buttons are not expected.")

(def-kom-var lyskom-url-protocol-regexp
  "\\(file\\|ftp\\|gopher\\|http\\|https\\|news\\|wais\\|mailto\\|telnet\\):"
  "Regexp to match the protocol part of a URL.")

(def-kom-var lyskom-text-buttons
  '(
    ;; Text numbers
    ("\\(\\<[0-9][0-9][0-9][0-9]\\([0-9]\\)?\\([0-9]\\)?\\([0-9]\\)?\\>\\)" 
                                        ; Match
     text                               ; Button type
     0                                  ; Portion that's a button
     1                                  ; Portion that's the arg
     nil                                ; Face or nil (=default)
     )

    ;; Email

    ("\\(\\b\\|^\\)[^()<>@,;:\"\\\\\000- ]+@[^\000- <>;,.'\"!:?) \t\012\014]+\\(\\.[^\000- <>;,.'\"!:?)]+\\)+"
     email 0 0 kom-url-face)

    ;; URLs

    ("\\(www\\|ftp\\|home\\)\\.[^\t \012\014\"<>|\\]*[^\t \012\014\"<>|.,!(){}?'`:]" 
     pseudo-url 0 nil kom-url-face)

    ("\\(file://\\|ftp://\\|gopher://\\|http://\\|https://\\|news:\\|wais://\\|mailto:\\|telnet:\\)[^\t \012\014\"<>|\\]*[^\t \012\014\"<>|.,!(){}?'`:]" 
     url 0 nil kom-url-face)
    ("<URL:\\s-*\\([^>]*\\)\\s-*>"
     url 1 1 kom-url-face)

    ;; JySKom enhancements

    ("<(?m[|]te *\\([0-9]+\\)[^0-9>]*)?>" conf 0 1 nil)
    ("<(?text *\\([0-9]+\\)[^0-9>]*)?>" text 0 1 nil)
    ("<(?person *\\([0-9]+\\)[^0-9>]*)?>" pers 0 1 nil)

    ;; Info node reference

    ("\\*Note[ \n\t]+\\([^:\n]*\\(\n[^:\n]*\\)?\\):\\s-*\\(\\(([^\)]+)\\)?[^.,\t\n]*\\(\n[^.,\t\n]*\\)?\\)[.,\t]" 
     info-node 1 3 kom-url-face)

    )
  "List of buttons to install in the text mass of LysKOM objects. Each element is
a list consisting of REGEXP TYPE BUTTON-MATCH BUTTON-ARG-MATCH FACE.
REGEXP is the regexp to look for in the text.
TYPE is the button type. Valid button types are defined in lyskom-button-actions
BUTTON-MATCH is the number of the parenthesized expression that is the actual button.
BUTTON-ARG-MATCH is the number of the expression to used as the button argument.
FACE is the text face to apply to the button, or nil to use the default face.")

(def-kom-var kom-url-viewer-preferences '("emacs"
                                          "windows"
                                          "w3")

  "*LysKOM will attempt to use URL viewers in the order specified here.
kom-url-managers is a list of all available viewers. Note that the elements
are all strings.

When you select an URL, this list is used to determine which URL
viewer to use in the following manner: Each element is in turn matched
against the manager regexp for each manager in kom-url-managers, and the
first manager found that matches is used to display the URL.

See kom-url-managers for a list of all available URL viewers. See
kom-netscape-command and kom-mosaic-command for information specific 
to some URL viewers."
  server)


(def-kom-var kom-url-managers '(("default"
                            ".*"
                            "Browse-URL"
                            lyskom-view-url-browse-url)
                           ("w3" 
			    "\\(http\\|gopher\\|ftp\\)"
			    "Emacs W3" 
			    lyskom-view-url-w3)
                           ("windows"
                            ".*"
                            "web brower"
                            lyskom-view-url-windows)
			   ("netscape"
			    ".*"
			    "Netscape Navigator"
			    lyskom-view-url-netscape)
			   ("\\(emacs\\|dired\\)"
			    "\\(ftp\\|file\\)"
			    "dired"
			    lyskom-view-url-dired)
			   ("\\(emacs\\|telnet-mode\\)"
			    "telnet"
			    "emacs telnet"
			    lyskom-view-url-telnet)
			   ("\\(emacs\\|mail-mode\\)"
			    "mailto"
			    "mail-mode"
			    lyskom-view-url-mailmode)
			   ("mosaic"
			    "\\(http\\|gopher\\|ftp\\|mailto\\|news\\|wais\\|file\\|telnet\\)"
			    "NCSA Mosaic"
			    lyskom-view-url-mosaic)
			   ("lynx"
			    "\\(http\\|gopher\\|ftp\\|mailto\\|news\\|wais\\|file\\|telnet\\)"
			    "Lynx"
			    lyskom-view-url-lynx))

  "List of URL managers. Each element is a list consisting of
(MANAGER-REGEXP PROTOCOLS NAME VIEW-FUNCTION). When LysKOM attempts to
view an URL, kom-url-viewer-preferences is scanned, and the URL
manager whose MANAGER-REGEXP first matches an element in
kom-url-viewer-preferences and whose PROTOCOLS matches the protocol of
the selected URL is used to view the URL by calling its VIEW-FUNCTION
with the URL and the manager entry as arguments.")

(def-kom-var kom-mosaic-command "/usr/local/bin/mosaic"
  "*Command to run to start Mosaic"
  server)

(def-kom-var kom-netscape-command "netscape"
  "*Command to run to start Netscape.

If a string, it should be a command that starts Netscape with no
arguments. If a list, the first element must be a command that starts
Netscape. The remaining elements are used as arguments to Netscape.

For instance, a value of \"netscape\" is valid, but \"netscape -d host:0\"
is not. Instead, the latter should be \(\"netscape\" \"-d\" \"host:0\"\)"
  server)

(def-kom-var kom-lynx-terminal 'xterm
  "*Where to start Lynx.
Valid values are 'xterm (start Lynx in an xterm) and 'terminal (start
Lynx in Emacs terminal mode.")

(def-kom-var kom-lynx-xterm-command
  '("xterm" "-geometry" "90x50+100+100" "-e" "lynx")
  "*Command to run to start Lynx in an xterm.
Must be a list of strings, where the first element is the name of the
xterm program, and the remaining elements are arguments to the
xterm. The last elements should be \"-e\" \"lynx\", or something similar,
to start Lynx.")

(def-kom-var kom-lynx-terminal-command "lynx"
  "*Command to run Lynx in Emacs terminal mode.

This can be either a string, to start Lynx with no arguments, or a
list of strings, where the first element is the command, and the rest
are arguments to Lynx.")

(def-kom-var kom-confirm-multiple-recipients 'after
  "*Non-nil means ask the user for confirmation about recipients.
When the user writes a comment to a text with more than one recipient
he gets a y-or-n-p question for all recipients. 'before means check
before opening the edit buffer. Anything else means check before
sending the article."
  server)

(def-kom-var kom-check-for-new-comments t
  "*Non-nil means check that no new comments have been written to a commented
texts since the last check. A list means check in all conferences except
those listed. A function means call the function and check if non-nil is
returned. The function is called with the commented text's text-stat as
an argument."
  server)

(def-kom-var kom-check-commented-author-membership t
  "*Non-nil means check that the authors of the commented texts are
members of at least one of the recipient conferences. If not, offer to
add them as recipients."
  server)

(def-kom-var kom-inhibit-typeahead nil
  "*If non-nil, discard keyboard input that arrives while a LysKOM command is
executing. "
  server)

(def-kom-var kom-max-buffer-size nil
  "*If non-nil, ensure that buffers won't grow any larger than this"
  server)

(def-kom-var lyskom-print-complex-dates t
  "If non-nil, print today and yesterday using a special format.")

(def-kom-var kom-show-namedays nil
  "*Non-nil means display namedays when running in swedish.
This variable will eventually be replaced with something else."
  server)

(def-kom-var kom-www-proxy nil
  "*Non-nil indicates a WWW proxy to use for the connection.
This is useful behind a firewall if the proxy supports the CONNECT
method. 

If this variable is a string, it is assumed to be a proxy
specification for all LysKOM servers. If it is a list, it is assumed
to be a list of pairs, (SERVER . PROXY) where SERVER is the server for
which PROXY, a proxy specification is to be used. The special value t
can be used for SERVER to indicate a default proxy.

A proxy specification has the form \"HOST:PORT\" where HOST is the
host name of the proxy and PORT is the port to connect to. The :PORT
part is optional. If it is not specified, port 80 is assumed.")

(def-kom-var kom-www-proxy-headers
  "User-Agent: Mozilla/4.7C-CCK-MCD  [en] (X11; I; SunOS 5.6 sun4u)"
  "*Headers to send to the proxy when connecting to LysKOM through a WWW
proxy. The value of this variable should either be a single string, which
is sent verbatim to the proxy, or a list of strings which will be sent to
the proxy separated by CRLF, or a list of elements like (NAME H1 H2 ... Hn)
where NAME is the name of a proxy and the remaining elements are headers
to send when connecting through that proxy.

Do not use this variable for proxy authentication.")



(def-kom-var kom-server-aliases
  '(("kom.lysator.liu.se" . "LysKOM")
    ("kom.ludd.luth.se" . "LuddKOM")
    ("rydkom.rydnet.lysator.liu.se" . "RydKOM")
    ("kom.csd.uu.se" . "CSD-KOM")
    ("striterax.medio.mh.se" . "MedioKOM")
    ("kom.mds.mdh.se" . "MdS-KOM")
    ("kom.stacken.kth.se" . "TokKOM")
    ("com.helsinki.fi" . "HelKOM")
    ("kom.cd.chalmers.se" . "CD-KOM")
    ("community.roxen.com" . "Roxen Community KOM"))
  "*An alist mapping server names to shorter identification strings")

(def-kom-var kom-ansaphone-on nil
  "t if automatic replies to personal messages are in effect."
  local)

(def-kom-var kom-silent-ansaphone nil
  "*Non-nil if messages should not cause beeps when the ansaphone is on."
  server)

(def-kom-var kom-ansaphone-record-messages t
  "*t if messages are recorded while the ansaphone is on."
  server)

(def-kom-var kom-ansaphone-show-messages t
  "*t if messages are to be shown when they are recorded."
  server)


(def-kom-var lyskom-ansaphone-messages nil
  "Messages collected by the automatic reply facility.
The most recent message is the first message in the list."
  local)

(def-kom-var lyskom-ansaphone-when-set (current-time-string)
  "Time when the auto-reply facility was enabled."
  local)

(def-kom-var kom-remote-control t
  "*t if LysKOM may be remotely controlled."
  server)

(def-kom-var kom-remote-controllers nil 
  "*Persons who may control LysKOM using messages.By default you can
always control your own sessions. See kom-self-control for more
information."
  server)

(def-kom-var kom-self-control t
  "*If non-nil, remote control commands are accepted from sessions logged
in as the same user as the current session."
  server)

(def-kom-var kom-ansaphone-replies
  '((group nil nil nil nil)
    (common nil nil nil nil))
  "*List of automatic replies to various messages.

A list of (MESSAGE-TYPE SENDER RECIPIENT TEXT REPLY)
    MESSAGE-TYPE is one of personal, group or common or nil
    SENDER is a list of integers or a single integer or nil
    RECIPIENT is a list of integers or a single integer or nil
    TEXT is a regular expression or nil
    REPLY is a string or nil

When an incoming message arrives and the auto-reply facility is on,
this list is checked for automatic replies. The message type, sender,
recipient and text of the incoming messages is matched against the 
elements of this list. If a match is found, the corresponding reply is
send. A nil in one of the message-type, sender, recipient or text
components in the list is taken to mean a wildcard. A null reply means
don't send a reply.

If none of the elements match, KOM-ANSAPHONE-DEFAULT-REPLY is sent."
  server)

(def-kom-var kom-agree-text nil
  "*If non-nil the default text to use when agreeing with a text.
This variable can be a string, function or list. If a string, the
string is used as the message. If a function, the function is called
and the return value is used. If a list, one of the elements is selected
at random and used. This element may be a string, function or list."
  server)

(def-kom-var kom-default-language nil
  "*Which language to use for new sessions."
  server 
  inherited
  protected)

(def-kom-var lyskom-language kom-default-language
  "The language currently in use."
  local
  inherited
  protected)


(def-kom-var lyskom-edit-mode-map nil
  "Mode map for LysKOM edit."
  local)

(def-kom-var lyskom-edit-prefix nil
  "Mode-map for lyskom edit mode.")

(def-kom-var lyskom-customize-map nil
  "Keymap for the customize buffer"
  local)

(def-kom-var lyskom-command-alternatives nil
  "Possible command completions."
  local
  minibuffer)

(def-kom-var kom-trim-buffer-minimum 4096
  "*This number of bytes rounded to a whole line is the amount of text trimmed
each time ." 
  server)


;;; =================================================================
;;;
;;; Language-dependent variables
;;;

(def-kom-var lyskom-onoff-table nil
  "A completion table for on and off selections."
  local)

(def-kom-var lyskom-language-codes nil
  "A list of ISO 639 language codes"
  local)
(put 'lyskom-language-codes 'lyskom-language-force t)

(def-kom-var lyskom-filter-predicate-list nil
      "A list of legal filter comparison predicates."
      local)

(def-kom-var lyskom-filter-what nil
      "A list of legal filter conditions and their textual representation."
      local)

(def-kom-var lyskom-filter-actions nil
      "A list of legal filter actions an their textual representation."
      local)

(def-kom-var lyskom-filter-edit-map nil
  "Keymap for LysKOM filter edit"
  local)

(def-kom-var lyskom-prioritize-mode-map nil
  "Keymap used in lyskom-prioritize-mode."
  local)

(def-kom-var lyskom-prioritize-header-lines nil
  "Number of lines in the header of the prioritization buffer"
  local)

(def-kom-var lyskom-prioritize-header nil
  "Header for the reprioritization buffer"
  inherited)

(def-kom-var kom-ansaphone-default-reply nil
  "*Default message to send when the ansaphone is on."
  server)

(def-kom-var kom-ispell-dictionary nil
  "*Dictionary to use for spell checking."
  server
  inherited)

(def-kom-var lyskom-button-actions
  '((text
     text-popup-title
     lyskom-button-view-text
     ((lyskom-button-view-text-action . lyskom-button-view-text)
      (lyskom-button-review-noconversion-action . lyskom-button-review-noconversion)
      (lyskom-button-review-tree-action . lyskom-button-review-tree)
      (lyskom-button-find-root-action . lyskom-button-find-root)
      (lyskom-button-comment-text-action . lyskom-button-comment-text)
      (lyskom-button-private-comment-text-action . lyskom-button-private-comment-text)
      (lyskom-button-mark-text-action . lyskom-button-mark-text)
      (lyskom-button-unmark-text-action . lyskom-button-unmark-text)
      (lyskom-button-save-text-action . lyskom-button-save-text)
      (lyskom-button-save-text-body-action . lyskom-button-save-text-body)
      )
     nil
     ;; ((nil lyskom-print-text footer lyskom-button-comment-text))
     )
    (conf 
     conf-popup-title
     lyskom-button-view-conf-presentation
     ((lyskom-button-view-conf-presentation-action . lyskom-button-view-conf-presentation)
      (lyskom-button-view-conf-status-action . lyskom-button-view-conf-status)
      (lyskom-button-goto-conf-action . lyskom-button-goto-conf)
      (lyskom-button-send-message-action . lyskom-button-send-message)
      (lyskom-button-add-self-action . lyskom-button-add-self)
      (lyskom-button-sub-self-action . lyskom-button-sub-self))
     ((kom-list-news . lyskom-button-goto-conf)
      (kom-membership . lyskom-button-goto-conf)))
    (pers 
     pers-popup-title
     lyskom-button-view-pers-presentation
     ((lyskom-button-view-pers-presentation-action . lyskom-button-view-pers-presentation)
      (lyskom-button-view-pers-status-action . lyskom-button-view-pers-status)
      (lyskom-button-mail-action . lyskom-button-mail)
      (lyskom-button-send-message-action . lyskom-button-send-message))
     nil)
    (url 
     url-popup-title
     lyskom-button-open-url
     ((lyskom-button-open-url-action . lyskom-button-open-url)
      (lyskom-button-copy-url-action . lyskom-button-copy-url))
     nil)
    (info-node 
     generic-popup-title
     lyskom-button-goto-info-node
     ((lyskom-button-goto-info-node-action . lyskom-button-goto-info-node))
     nil)
    (email
     generic-popup-title
     lyskom-button-open-email
     ((lyskom-button-open-email-action . lyskom-button-open-email)
      (lyskom-button-copy-email-action . lyskom-button-copy-email))
     nil)
    (aux
     aux-popup-title
     lyskom-button-info-aux
     ((lyskom-button-info-aux-action . lyskom-button-info-aux)
      (lyskom-button-delete-aux-action . lyskom-button-delete-aux))
     nil)
    (aux-edit-menu
     nil
     aux-edit-menu-text
     ((lyskom-edit-toggle-secret-aux-action . lyskom-edit-toggle-secret-aux)
      (lyskom-edit-toggle-anonymous-aux-action . lyskom-edit-toggle-anonymous-aux)
      (lyskom-edit-toggle-inherit-aux-action . lyskom-edit-toggle-inherit-aux)
      (lyskom-edit-delete-aux-action . lyskom-edit-delete-aux))
     nil)
    (prioritize-flag-menu
     nil
     lyskom-prioritize-flag-toggle
     ((lyskom-prioritize-flag-toggle-action . lyskom-prioritize-flag-toggle)
      (lyskom-prioritize-flag-set-action . lyskom-prioritize-flag-set)
      (lyskom-prioritize-flag-clear-action . lyskom-prioritize-flag-clear))
     nil)
    (func
     nil
     lyskom-button-apply
     nil
     nil)
    )
  "This variable defines valid button types in LysKOM. Each element is a
list consisting of (TYPE LABEL DEFAULT ACTIONS HINTS).
TYPE is the button type the entry defines
LABEL is a textual representation for the button type, used in menu titles. If
      it is a symbol, that symbol will be looked up using lyskom-get-string.
DEFAULT is the default action to take on a click. It must be a function.
ACTIONS are other possible actions. The format of this entry is described 
        below.
HINTS is a list of hints to override the default action. This is described 
      below.

The ACTIONS entry is used to construct a pop-up menu. It is a list consisting 
of lists with the format (STRING . FUNCTION). STRING is the menu label and
FUNCTION is the function to call when the menu item is selected.

The HINTS entry is used to generate hints that the default action should be 
overridden. It is a list containing elements (COMMAND . HINT) where COMMAND is
as interactive LysKOM command and HINT is a function to call. When a button
is generated while the command COMMAND is being executed, HINT is used as a 
hint for a new default action. The user has the option to ignore or used the 
hint.

Also see the function \"lyskom-add-button-action\"."
  local
  inherited)

(def-kom-var kom-show-imported-envelope-sender t
  "*If non-nil, show the envelope sender of texts imported by komimportmail."
  server)

(def-kom-var kom-show-imported-importer t
  "*If non-nil, show the name of the importer of an imported text."
  server)

(def-kom-var kom-show-imported-external-recipients t
  "*If non-nil, show the external recipients to an imported text."
  server)

(def-kom-var kom-complete-numbers-before-names t
  "*If non-nil, reading conference and user names accepts the special 
forms ``m 4711'' or ``p 42'' as numeric references to conference 4711
and person 42 instead of trying to look for an object with a matching
name. If nil, any name matching the input will be preferred to a
numeric reference."
  server)


(def-kom-var kom-mercial nil
  "*When the user has seen all texts and has reached the view-time prompt,
this string is used as the argument to lyskom-tell-server.
Users are encouraged to use their best sense of humor."
  server)


(defconst lyskom-commands
  '(
    describe-mode
    kom-slow-mode
    kom-quick-mode
    kom-send-message
    kom-create-conf
    kom-delete-conf
    kom-delete-text
    kom-display-time
    kom-go-to-conf
    kom-go-to-next-conf
    kom-jump
    kom-list-created-conferences
    kom-list-conferences 
    kom-list-persons
    kom-list-news
    kom-list-re
    kom-membership
    kom-list-marks
    kom-postpone
    kom-set-session-priority
    kom-prioritize
    kom-status-person
    kom-status-conf
    kom-add-self
    kom-change-priority
    kom-list-summary
    kom-sub-self
    kom-quit
    kom-recover 
    kom-start-anew
    kom-view
    kom-find-root-review
    kom-review-comments
    kom-review-tree
    kom-review-clear
    kom-review-last-normally-read
    kom-review-noconversion
    kom-review-next
    kom-find-root
    kom-review-by-to
    kom-review-more
    kom-review-first
    kom-review-all
    kom-view-commented-text
    kom-view-previous-commented-text
    kom-review-stack
    kom-review-presentation
    kom-review-backward
    kom-view-next-text
    kom-who-is-on
    kom-who-is-on-in-conference
    kom-who-am-i
    ;;   kom-display-who-buffer
    kom-list-clients
    kom-busy-wait
    kom-write-comment
    kom-comment-previous
    kom-write-footnote
    kom-private-answer
    kom-private-answer-previous
    kom-set-unread
    kom-write-text
    kom-send-letter
    kom-change-name
    kom-change-parenthesis
    kom-change-password
    kom-change-supervisor
    kom-change-presentation
    kom-get-appreciation
    kom-get-abuse
    kom-mark-text
    kom-unmark-text
    kom-review-marked-texts
    kom-review-all-marked-texts
    kom-add-recipient
    kom-add-copy
    kom-add-bcc
    kom-sub-recipient
    kom-move-text
    kom-add-comment
    kom-sub-comment
    kom-add-member
    kom-sub-member
    kom-change-conf-motd
    kom-set-garb-nice
    kom-set-super-conf
    kom-set-permitted-submitters
    kom-unset-conf-motd
    kom-save-text
    kom-save-text-body
    kom-save-options
    kom-shutdown-server
    kom-sync-database
    kom-enable-adm-caps
    kom-disable-adm-caps
    kom-set-motd
    kom-remove-motd
    kom-force-logout
    kom-filter-author
    kom-filter-subject
    kom-filter-text
    kom-super-jump
    kom-filter-edit
    kom-list-filters
    kom-show-user-area
    kom-change-conf-type

    kom-change-auto-reply
    kom-toggle-auto-reply
    kom-list-messages
    kom-erase-messages

    kom-remote-autoreply
    kom-remote-set-message
    kom-remote-list-messages
    kom-remote-erase-messages
    kom-remote-quit

    kom-status-session
    kom-customize
    kom-change-language
    kom-calculate

    kom-where-is

    kom-next-kom
    kom-previous-kom
    kom-next-unread-kom

    kom-send-alarm
    kom-agree
    kom-fast-reply
    kom-add-faq
    kom-del-faq
    kom-review-faq

    kom-add-footnote
    kom-sub-footnote

    kom-add-private-answer
    kom-add-no-comments
    kom-add-request-confirm

    kom-review-mail-headers
    kom-become-anonymous
    kom-become-nonanonymous

    kom-keep-alive
    kom-stop-keep-alive

    kom-is-person-member-of-conference
    kom-change-conf-faq
    ))

;;; ================================================================
;;;                  Internal variables and constants


(defconst lyskom-clientversion "0.46"
  "Version of the LysKOM elisp client.")

(defconst lyskom-max-int 8388607
  "The largest int emacs, and thus this LysKOM client, can handle.")

(defconst lyskom-server-features
  '((10 lyskom-bcc-flag
        lyskom-extended-types-flag)
    (9  lyskom-accept-async-flag
        lyskom-dynamic-session-info-flag
        lyskom-idle-time-flag)
    (8  lyskom-long-conf-types-flag 
        lyskom-set-last-read-flag 
        lyskom-uconf-stats-flag
        lyskom-set-last-read-flag)
    (7  lyskom-z-lookup-flag))
  "List describing which features a certain server has. Each
element is a list containing the protocol version and what
it supports. The format of each element is:

\(VERSION . SUPPORTS\)

Version is simply a protocol version. Protocol equal to or above the
version support the supports list.

SUPPORTS is a list of pairs and symbols. Cons pairs are treated as
arguments to setq, symbols are interpreted as variable names set
 to 't'.")

;;;(defconst lyskom-server-features
;;;  '(((>= 2 0 0) (lyskom-bcc-flag
;;;                 lyskom-aux-items-flag))
;;;    ((>= 1 9 0) (lyskom-accept-async-flag
;;;                 lyskom-dynamic-session-info-flag
;;;                 lyskom-idle-time-flag))
;;;    ((>= 1 8 0) (lyskom-long-conf-types-flag 
;;;                 lyskom-set-last-read-flag
;;;                 lyskom-uconf-stats-flag))
;;;    ((>= 1 7 0) (lyskom-z-lookup-flag))
;;;    ((= 2 0 0) ((protocol-version 10)))
;;;    ((= 1 9 0) ((protocol-version 9)))
;;;    ((= 1 8 0) ((protocol-version 8)))
;;;    ((= 1 7 0) ((protocol-version 7)))
;;;    ((= 1 7 1) ((protocol-version 7)))
;;;    ((< 1 7 0) ((protocol-version 6))))
;;;  "List describing which features a certain server version has.
;;;Each element is a list containing the server version and what it
;;;supports:
;;;")


(def-kom-var lyskom-server-version '(0 0 0)
  "The version of the server.  A list of three integers, major
version, minor version and revision."
  local)

(def-kom-var lyskom-server-coding-system 'iso-8859-1
  "The default coding system used by the server for all strings."
  inherited)

(def-kom-var lyskom-max-packet-size lyskom-max-int
  "The largest possible packet size that can be transmitted to a
TCP/IP connection. This should be unlimited, but in practise there
are systems that limits this. This variable is automatically adjusted
if any problems are detected.")

(def-kom-var lyskom-pending-commands nil
  "Commands pending to be executed.
When a command finishes, it checks this variable to see if another command
should be run.

It should be a lest where each element should be either a symbol or an
expression. If it is a symbol it is invoked with `call-interactively', and
an expression is evaluated with `eval'."
  local)

(def-kom-var lyskom-do-when-done nil
  "Internal of kom-do-when-done."
  local)

(def-kom-var lyskom-do-when-starting nil
  "Internal of kom-do-when-starting. Obsolete")

(def-kom-var lyskom-sessions-with-unread nil
  "List of lyskom-sessions with unread texts.
This is not buffer-local.")

(def-kom-var lyskom-sessions-with-unread-letters nil
  "List of lyskom-sessions with unread letters.
This is not buffer-local.")

(def-kom-var lyskom-session-has-unread-letters nil
  "Non-nil if this session has unread letters."
  local
  protected
  inherited)

(def-kom-var lyskom-session-has-unreads nil
  "Non-nil if this session has unread texts."
  local
  protected
  inherited)

(def-kom-var lyskom-buffer nil
  "What is the lyskom-buffer we are connected to."
  inherited
  minibuffer)

(def-kom-var lyskom-buffer-type nil
  "What type of buffer is the current buffer."
  local
  protected)

(def-kom-var output nil
  "Uaark. Just to omit a warning...")

(def-kom-var lyskom-errno nil
  "Errno of last lyskom error."
  local)

(def-kom-var lyskom-err-stat nil
  "Err-stat of last lyskom error."
  local)

(def-kom-var lyskom-parse-pos nil
  "Position of parsing.")

(def-kom-var lyskom-unparsed-buffer nil
  "Buffer containing unparsed information from the server."
  local)

(def-kom-var lyskom-unparsed-marker nil
  "Here are we inserting now."
  local)

(def-kom-var lyskom-to-be-printed-before-prompt nil
  "Contains the strings to be printed out before the next prompt."
  local)

(def-kom-var lyskom-other-clients-user-areas nil
  "Contains the parts of the user areas of unknown klients.
The area is a pair: name . info (both strings)."
  local)

(def-kom-var lyskom-pending-calls nil
  "Assoc-list of calls to LysKOM server that have not yet completed.
Each element on the list has the format
	(REF-NO . KOM-QUEUE)
REF-NO	   unique number assigned by lyskom-send-packet.
KOM-QUEUE is a kom-queue. (See lyskom-call-data)."
  local)

(def-kom-var lyskom-output-queues nil
  "Pending output to the server.
This is a vector of ten elements, each of which is a kom-queue. calls from
queues with a higher index (priority) are always sent first.

At most lyskom-max-pending-calls calls are sent at once."
  local)

(def-kom-var lyskom-max-pending-calls 20
  "*Max number of calls that are transmitted to the server at once.
Extra calls are queued in lyskom-output-queue and sent when the replies
returns.

This variable is not saved in the LysKOM server.")

(def-kom-var lyskom-number-of-pending-calls 0
  "Number of pending calls that are transmitted to the server."
  local)

;; This variable is used to prevent "starvation" of the blocking-do call.
;; When there are heavy prefetch going on in the background and a
;; blocking-do call is made there is a good chance that the
;; accept-process-output call will not return within a reasonable
;; time, because there will always be data to read from the server,
;; which means that Emacs will call lyskom-filter instead of returning
;; from accept-process-output.
(defvar lyskom-ok-to-send-new-calls t
  "This variable controls whether calls are passed to the server.
If it is nil, all outgoing calls are inhibited.")

(def-kom-var lyskom-ref-no 0
  "Next ref-no to use. These ref-nos are used to keep track of the
different packets.")

(def-kom-var lyskom-pers-no 0
  "The pers-no of the current user."
  inherited)

(def-kom-var lyskom-session-no 0
  "Session number in the server for this connection"
  local)

(def-kom-var kom-default-session-priority 1
  "*The default session priority.
Only texts in conferences with a priority equal to or higher than this
will be shown by default.

To set the session priority in a running session, set the variable
lyskom-session-priority instead. The value of this variable is used
to initialize lyskom-session-priority when a new session is started."
  local
  server)

(def-kom-var kom-server-priority -1
  "*The default server priority.
When kom-server-priority-breaks is set, this priority is used to decide
when to go to a prioritized session. For a session to be prioritized its
priority must be higher than the current session's kom-server-priority 
and higher than the priority of whatever is currently being read."
  server)


(def-kom-var lyskom-session-priority 0
  "*This sessions priority.
Only texts in conferences with a priority equal to or higher than this
will be shown."
  local)

(def-kom-var lyskom-proc nil
  "The process (network connection) that is associated with this buffer."
  inherited
  minibuffer)

(def-kom-var lyskom-server-info nil
  "Info about the server"
  local)

(def-kom-var lyskom-server-version-info nil
  "Version information about the client"
  local)

(def-kom-var lyskom-server-name ""
  "The name of the server"
  inherited)

(def-kom-var lyskom-server-port nil
  "The port we are connected to."
  local)

(def-kom-var lyskom-buffer-list nil
  "List of all LysKOM buffers.")

(def-kom-var lyskom-static-session-info-cache nil
  "Cache of session."
  local)

(def-kom-var lyskom-conf-cache nil
  "Cache of conference statuses."
  local)

(def-kom-var lyskom-uconf-cache nil
  "Cache of small conference statuses."
  local)

(def-kom-var lyskom-pers-cache nil
  "Cache of person statuses."
  local)

(def-kom-var lyskom-text-cache nil
  "Cache of text statuses."
  local)

(def-kom-var lyskom-text-mass-cache nil
  "Cache of texts."
  local)

(def-kom-var lyskom-marked-text-cache nil
  "Cache of marks of all texts the current user has marked. "
  local)

(def-kom-var lyskom-who-info-cache nil
  "Cache of people presently logged in in LysKOM."
  local)

(def-kom-var lyskom-who-info-buffer nil
  "Buffer for the who info presentation."
  local)

(def-kom-var lyskom-who-info-buffer-is-on nil
  "Says wether we are collecting who-information or not."
  local)


(def-kom-var lyskom-is-parsing t
  "True when parsing a result.
This is used to prevent parallell parsing since the parser is not reentrant."
  local)

(def-kom-var lyskom-string-bytes-missing 0
  "Number of bytes missing in the unparsed buffer when parsing a string.
Set when parsing a string and there were not enough bytes in the buffer
with the unparsed bytes. This variable is used to prevent reparsing before 
the string is complete.
This variable is buffer-local in the unparsed-buffer."
  local
  inherited)

(def-kom-var lyskom-last-viewed 0       ;
  "Postition of the first char of the last line that the user has had
time to view. This is normally the pos of the first char of the prompt."
  local)

(def-kom-var lyskom-mode-map nil
  "Keymap used in LysKOM mode."
  local)


(def-kom-var lyskom-reading-list nil
  "List of articles to read in the current conference.
Each element is a read-info. Only one of the elements is of the type CONF.
This one is located last in the list (except for the elements of the type 
REVIEW, REVIEW-TREE or REVIEW-MARK).
When reading an article with comments a list of the comments is built
recursively if the flag kom-read-depth-first is non-nil.
This is to keep track of the reading order.
Articles can exist in several of the read-info elements. All unread articles
in the conference are always present in the CONF type entry in this list even
if also in other entries. (COMM-IN, FOOTN-IN)

Some powerful reviewing commands requires to construct a list of articles that
should be read. These use the type REVIEW. When reviewing trees and when
every viewed article is supposed to be followed by all its comments then the
type REVIEW-TREE is used.

The first element is a dummy."
  local)

(def-kom-var lyskom-to-do-list nil
  "List of conferences with unread texts.
Each element is a read-info. All have the type 'CONF and there is one for
every conference with unread articles that have been prefetched already.
The list is sorted in falling priority. 
When going to a conference the first element (the one with the highest
priority) is copied from this list to lyskom-reading-list.

The first element is a dummy."
  local)

(def-kom-var lyskom-quit-flag nil
  "A flag indicating if the filter was interrupted by C-g.
 It is set to the same value as quit-flag on filter exit.")

(def-kom-var lyskom-ignoring-async-list nil
  "A list of async messages we are currently ignoring.
Each element is a list. The car of the list is the message and the
remaining elements are whatever is suitable for that type of message.
See the checks in lyskom-parse-async for details."
  local)

(def-kom-var lyskom-inhibit-minibuffer-messages nil
  "A flag indicating whether asynchronous minibuffer messages are allowed.
If this variable is non-nil, no asynchronous messages will appear.")

(def-kom-var lyskom-is-saving nil
  "A flag indicating whether the server is saving at the moment.")

;;; These variables control prefetch of conf-stats, text-stats and texts:

(def-kom-var lyskom-prefetch-conf-tresh 50
  "If fewer than lyskom-prefetch-conf-tresh texts are known, ask for more
conf-stats from server.

This is currently not used."
  local)

(def-kom-var lyskom-prefetch-confs 10
  "Number of confs to ask about at once when checking for unread texts.

This is currently not used."
  local)

(def-kom-var lyskom-fetch-map-nos 50
  "Number of text-nos lyskom will fetch when fetching maps."
  local)

(def-kom-var lyskom-fetch-membership-length 6
  "*Number of entries in the membership-list that is fetched at a time.
This should be optimized depending on how often you read lyskom and
the activity in the first groups in you membership list.

Best performance is achieved if you, when logging in, always have an unread
article in one of the first lyskom-fetch-membership-length conferences.")

(def-kom-var lyskom-prefetch-limit 10
  "Number of prefetch requests the client will try to keep going
at a time.")


;;;

(def-kom-var lyskom-membership nil
  "Sorted membership-list of the logged in person."
  local)

(def-kom-var lyskom-unread-confs nil
  "List containing all unread confs."
  local)

(def-kom-var lyskom-dont-change-prompt nil
  "Non-nil during the entry of a text."
  local)

(def-kom-var lyskom-command-to-do 'unknown
  "Atom describing what command to do. See the function lyskom-what-to-do."
  local)

(def-kom-var lyskom-is-waiting nil
  "If non-nil then this is the condition for the waiting to be stopped.
If t however just meaning user is waiting for a text with prompt.
It is a form that will be evaluated (using eval) every time the asynchronous
message \"new text\" is received.

This is used by the command kom-busy-wait."
  local)

(def-kom-var lyskom-current-conf 0
  "Current conference. 0 means user is not reading any conf."
  local)

(def-kom-var lyskom-current-text nil
  "Text-no of current text. nil means no text is current."
  local)

(def-kom-var lyskom-last-written nil
  "Text-no of last text written. nil means no text written."
  local)

(def-kom-var lyskom-last-seen-written nil
  "Text-no of last text read or written by the current user.
When a new text is written, this is set to the text number of that text.
When a text is read that was written by the current user, this is
set to that text."
  local)

(def-kom-var lyskom-previous-text nil
  "Text-no of previous text.  Nil means no text."
  local)

(def-kom-var lyskom-normally-read-texts nil
  "Stack of texts that are read normally. Used for kom-review-last-normally-read."
  local)

(def-kom-var lyskom-current-subject ""
  "Current subject."
  local)

(def-kom-var lyskom-last-added-rcpt 0
  "The default conference when adding a recipient or moving a text."
  local)

(def-kom-var lyskom-last-added-ccrcpt 0
  "The default conference when adding a ccrecipient."
  local)

(def-kom-var lyskom-last-added-bccrcpt 0
  "The default conference when adding a bccrecipient."
  local)

(def-kom-var lyskom-last-sub-rcpt 0
  "The default conference when removing a recipient."
  local)

(def-kom-var kom-saved-file-name (concat default-directory "kom-text")
  "*The default file name when saving a LysKOM text."
  server)

(def-kom-var lyskom-saved-file-name nil
  "After saving once, the default file name when saving a LysKOM text."
  local)

(def-kom-var lyskom-mode-hook nil
  "*Hook to run when lyskom-mode is entered.")

(def-kom-var kom-quit-hook nil
  "*Hook to run when the LysKOM session is correctly ended."
  server-hook)

(def-kom-var kom-quit-when-idle t
  "Non-nil to automatically quit when LysKOM is full and the session is idle")

(def-kom-var kom-permanent-filter-list nil
  "List of patterns to filter permanently"
  server)

(def-kom-var kom-session-filter-list nil
  "List of patterns to filter during this session"
  local)

(def-kom-var kom-prompt-for-text-no 
  '(kom-delete-text
    kom-view
    kom-write-footnote
    kom-mark-text
    kom-unmark-text
    kom-add-recipient
    kom-add-copy
    kom-add-bcc
    kom-sub-recipient
    kom-move-text
    kom-add-comment
    kom-sub-comment
    kom-save-text-body
    kom-add-footnote
    kom-sub-footnote
    kom-add-faq
    kom-add-no-comments
    kom-add-private-answer
    kom-add-request-confirm)
  "*Commands that prompt for a text number rather than assume a default"
  server
  inherited)


(def-kom-var lyskom-filter-list nil
  "List of patterns that are filtered."
  local)

(def-kom-var lyskom-create-text-hook nil
  "Hook to run before creating a new text.
This hook is run just before the server call to create the text is made.

The hook is currently called with the following arguments:
MESSAGE         The message text
MISC-LIST       The misc-info list
AUX-LIST        The aux-item list
BUFFER          The edit buffer
IS-ANONYMOUS    Non-nil if the user is currently anonymous.
&rest RESERVED  Additional arguments may be added in the future.

The hook can change the message by modifying the variable
full-message, the misc-info list my modifying misc-list and the
aux-item list by modifying aux-list. This is not encouraged."
  local-hook)



(def-kom-var lyskom-new-text-hook nil
  "Hook to run when a new text is created.
This hook is run after the prompt is removed if it shall be changed but before
the text Text 4711 r skapad! is printed in the message area. And before the
new prompt is printed."
  local-hook)

(def-kom-var lyskom-deleted-text-hook nil
  "Hook to run when a text is deleted.
This hook is run after the prompt is removed if it shall be changed but 
before the new prompt is printed."
  local-hook)

(def-kom-var lyskom-new-recipient-hook nil
  "Hook to run when a text gains a new recipient.
This hook is run after the prompt is removed if it shall be changed but before
the new prompt is printed. It is not run if the text has been marked as read
in any conference other than the person's letterbox."
  local-hook)

;;(def-kom-var lyskom-who-info-has-changed-hook nil
;;  "Hook to run every time the who-info-buffer has changed.
;;The hook is run with current-buffer the lyskom buffer, not the 
;;who-info-buffer."
;;  server)

(def-kom-var lyskom-personal-message-hook nil
  "*Hook to run when a personal message is received.
When the hook is run 'sender' is bound to the pers-stat of the sender
of the message (or possibly nil), 'recipient' is 0 if the message is a
public message and otherwise the pers-no of the user, and 'message' is
a string that holds the message."
  local-hook)


(def-kom-var lyskom-executing-command t
  "Non-nil means the client is executing a command.
Most commands can't be interrupted by another command."
  local)

(def-kom-var lyskom-current-command nil
  "The command currently being executed."
  local)

(def-kom-var lyskom-current-function nil
  "Sometimes set to the current high-level function being executed."
  local)

(def-kom-var lyskom-current-function-phase nil
  "Sometimes set to the phase of the curreht high-level function being
executed."
  local)

(def-kom-var kom-low-priority -1
  "*Priority that the current conference are set to when they are
aborted. nil means don't alter priority. (That means that
kom-go-to-next-conf might go to the same conference again.)")

(def-kom-var lyskom-membership-is-read nil
  "T when the membership has been read."
  local)

(def-kom-var lyskom-is-writing nil
  "t when the user is writing a text."
  local)

(def-kom-var lyskom-debug-communications-to-buffer nil
  "Non-nil means all communications with the server is stored in a buffer.
The name is stored in lyskom-debug-communications-to-buffer-buffer.")

(def-kom-var lyskom-backtrace-list nil
  "List containing debugging information")
  
(def-kom-var lyskom-debug-what-i-am-doing t
  "Non-nil means asynchronous message 5 will be logged to the debug
  buffer. ")

(def-kom-var lyskom-is-anonymous nil
  "Non-nil means be a bit secretive about things. Not totally
  secretive of course, since the server doesn't allow that yet."
  local)

(def-kom-var lyskom-debug-communications-to-buffer-buffer "*kom*-debugs"
  "Name of the buffer to insert the communications with the server into if
lyskom-debug-communications-to-buffer is non-nil.")

(def-kom-var lyskom-doing-default-command nil
  "Non-nil if LysKOM is executing the default command."
  local)

(def-kom-var lyskom-first-time-around nil
  "Non-nil if LysKOM is being entered for the first time."
  local)

(def-kom-var lyskom-experimental-features nil
  "If non-nil, LysKOM is likely to blow up in your face."
  local)

(def-kom-var lyskom-format-experimental nil
  "If non-nil, LysKOM is likely to make a fool out of you."
  local)

(def-kom-var lyskom-count-var 0
  "This variable is used for counting things in the client, such as
unread texts in list-unread."
  local)

(def-kom-var lyskom-default-conf-string nil
  "The default string to use for an unknown conference.
Set this locally when inserting a conference name using
lyskom-format-insert if you want to replace the usual description of
an unknown conference.")

(def-kom-var lyskom-default-pers-string nil
  "The default string to use for an unknown person
Set this locally when inserting a conference name using
lyskom-format-insert if you want to replace the usual description of
an unknown person.")


(def-kom-var lyskom-is-administrator nil
  "This variable is t if the user is in administrator mode and nil otherwise."
  local
  minibuffer)

(def-kom-var lyskom-last-personal-message-sender ""
  "Name of sender of last personal message received"
  local)

(def-kom-var lyskom-last-group-message-recipient ""
  "Name of target for last group message received"
  local)

(def-kom-var lyskom-last-message-recipient nil
  "Number of last async message recipient sent to."
  local)

(def-kom-var lyskom-is-new-user nil
  "An internal variable used in kom-start-anew")

(def-kom-var lyskom-apo-timeout-s 1
  "Seconds timeout for accept-process-output")

(def-kom-var lyskom-apo-timeout-ms nil
  "Microseconds timeout for accept-process-output")

(def-kom-var lyskom-collate-table nil
  "Table mapping characters to equivalent characters."
  inherited)

(def-kom-var lyskom-dont-read-user-area nil
  "If non-nil the user area will not be read on login."
  local)

(def-kom-var lyskom-allow-missing-subject nil
             "If non-nil allow texts without subjects.")

(def-kom-var kom-w3-simplify-body t
  "*Strip color information from body tag."
  server)

(def-kom-var lyskom-format-special 
  '(("html"               . lyskom-format-html)
    ("enriched"           . lyskom-format-enriched)
    ("text/html"          . lyskom-format-html)
    ("text/enriched"      . lyskom-format-enriched)
    ("text/plain"         . nil)
    ("x-kom/basic"        . nil)
    ("x-kom/\\."         . lyskom-format-))
  "AList of (FORMAT . FUNCTION) specifying functions that format texts
of that type. FORMAT is a symbol and FUNCTION is a function taking one
argument and returning a formatted string.")

(def-kom-var lyskom-send-text-transform-function nil
  "Function to call to transform text before sending it to the server.
The function should accept a single argument and return the transformed
texts that is to be sent to the server.")

(def-kom-var lyskom-slow-mode nil
  "Non-nil when in slow mode"
  local)

(def-kom-var lyskom-saved-read-only nil
  "Saved value of buffer-read-only when in slow mode."
  local)

(defvar lyskom-line-start-chars-string
  "\"$&'()*+-./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]_`abcdefghijklmnopqrstuvwxyz"
  "Characters that may start a line in a paragraph to be broken.")

(def-kom-var lyskom-line-start-chars nil
  "Computer-friendly version of lyskom-line-start-string")


(def-kom-var lyskom-last-text-format-flags nil
  "List of flags specifying how the last text was reformatted. This variable
should be dynamically bound whenever it needs to be used.")

(defvar lyskom-xface-cache (make-vector 29 0))


;;; ======================================================================
;;; Event hooks
;;;

(def-kom-var lyskom-add-membership-hook nil
  "Functions to call when a membership is added"
  local-hook)

(def-kom-var lyskom-replace-membership-hook nil
  "Functions to call when a membership is replaced"
  local-hook)

(def-kom-var lyskom-remove-membership-hook nil
  "Functions to call when a membership is removed"
  local-hook)

(def-kom-var lyskom-new-membership-list-hook nil
  "Functions to call when the entire membership list is replaced."
  local-hook)


;;; ======================================================================
;;;; lyskom-tell-phrases-validation-keyword-list
;;; This is a list of keywords for kom-tell-phrases.
;;; These are the only keywords that are allowed in kom-tell-phrases.

;;; To coders of the elisp-client:
;;; If you add/delete a reference to any of these keywords make sure
;;; you update these changes.

;;; To everyone:
;;; The kom-tell-phrases list is checked against this list when the
;;; client is loaded, i.e. by lyskom-tell-phrases-validate that causes
;;; an error if any keyword is not present or any non-keyword is
;;; present.

(defvar kom-tell-phrases nil
  "*A list of phrases describing what the client is doing. Each element in
the list is a pair \(KEY . PHRASE\) where KEY is one of the keywords in
lykom-tell-phrases-validation-keyword-list and PHRASE is the phrase to
sent to the server then the client is doing what KEY describes.

If the value of this variable is nil, suitable defaults for the currently
selected language will be selected.")

(defconst lyskom-tell-phrases-validation-keyword-list
  '(
    (kom-tell-silence)
    (kom-tell-send)
    (kom-tell-login)
    (kom-tell-read)
    (kom-tell-1st-pres)
    (kom-tell-write-comment)
    (kom-tell-write-footnote)
    (kom-tell-write-letter)
    (kom-tell-write-reply)
    (kom-tell-write-text)
    (kom-tell-conf-pres)
    (kom-tell-recover)
    (kom-tell-wait)
    (kom-tell-regret)
    (kom-tell-review)
    (kom-tell-change-name)
    (kom-tell-change-supervisor)
    (kom-tell-next-lyskom)
    )
  "Users must not change this constant, but are encouraged to change
the value of  kom-tell-phrases  for fun.")

;;; ================================================================
;;; Commands lists that are removed from extended command depending on
;;; administrator status.

(defconst lyskom-admin-removed-commands
  '(kom-enable-adm-caps))
(defconst lyskom-noadmin-removed-commands
  '(kom-disable-adm-caps kom-remove-motd kom-set-motd kom-shutdown-server
                         kom-sync-database))


;;; ================================================================
;;;          Externally defined variables (environment)


(def-kom-var lyskom-default-server "kom.lysator.liu.se"
  "*Default LysKOM server.")

(def-kom-var lyskom-default-user-name nil
  "*Default LysKOM user name."
  local)

(def-kom-var lyskom-default-password nil
  "Default LysKOM PASSWORD."
  local)

(def-kom-var mode-line-conf-name nil
  "Conf name that is present on the mode-line."
  local)

;;
;; Set up default faces in case no face scheme is selected
;;

(def-kom-var lyskom-faces
  '(kom-active-face kom-url-face kom-me-face kom-highlight-face
		    kom-text-face kom-subject-face kom-text-no-face
		    kom-friends-face kom-morons-face kom-presence-face
		    kom-first-line-face kom-warning-face kom-mark-face)
  "This is a list of the faces that LysKOM uses.")

(def-kom-var lyskom-face-schemes
  '((default
     (kom-active-face default "blue4" nil)
     (kom-url-face default "BlueViolet" nil)
     (kom-me-face bold "blue3" "lavender")
     (kom-highlight-face highlight nil)
     (kom-text-face default nil nil)
     (kom-subject-face default nil nil)
     (kom-text-no-face kom-active-face nil nil)
     (kom-friends-face default "blue3" "lavender")
     (kom-morons-face default "blue3" "yellow")
     (kom-presence-face italic "dim gray" nil)
     (kom-mark-face bold "blue3" "lavender")
     (kom-warning-face bold "red" nil)
     (kom-first-line-face default nil nil))
    (inverse
     (kom-active-face default "lightblue" nil)
     (kom-url-face default "Moccasin" nil)
     (kom-me-face bold "gold" "black")
     (kom-highlight-face highlight nil nil)
     (kom-text-face default nil nil)
     (kom-subject-face default "Khaki" nil)
     (kom-text-no-face kom-active-face nil nil)
     (kom-friends-face default "red" nil)
     (kom-morons-face default "yellow" nil)
     (kom-presence-face italic "grey" nil)
     (kom-mark-face default "gold" "black")
     (kom-warning-face bold "red" nil)
     (kom-first-line-face default nil nil))
    (monochrome
     (kom-active-face default nil nil)
     (kom-url-face default nil nil)
     (kom-me-face bold nil nil)
     (kom-highlight-face highlight nil nil)
     (kom-text-face default nil nil)
     (kom-subject-face default nil nil)
     (kom-text-no-face kom-active-face nil nil)
     (kom-friends-face underline nil nil)
     (kom-morons-face strikethrough nil nil)
     (kom-presence-face italic nil nil)
     (kom-mark-face bold nil "black")
     (kom-warning-face bold nil nil)
     (kom-first-line-face default nil nil))
    (minimal
     (kom-active-face default nil nil)
     (kom-url-face default nil nil)
     (kom-me-face default nil "lavender")
     (kom-highlight-face highlight nil nil)
     (kom-text-face default nil nil)
     (kom-subject-face default nil nil)
     (kom-text-no-face default nil nil)
     (kom-friends-face default nil "alice blue")
     (kom-morons-face default nil "red")
     (kom-presence-face italic "dim gray" nil)
     (kom-mark-face default nil "black")
     (kom-warning-face bold nil nil)
     (kom-first-line-face default nil nil))
    (highlight
     (kom-active-face    default   nil          "aliceblue")
     (kom-url-face       default   nil          "yellow")
     (kom-me-face        bold      "darkblue"   "thistle")
     (kom-highlight-face highlight nil          nil)
     (kom-text-face      default   nil          nil)
     (kom-text-no-face   default   nil          nil)
     (kom-friends-face   default   "darkblue"   "thistle")
     (kom-morons-face    strikethrough   "red"        "seagreen")
     (kom-subject-face   default   nil          nil)
     (kom-presence-face  italic    "dim gray"   nil)
     (kom-mark-face      bold      "darkblue"   "thistle")
     (kom-warning-face   bold      "yellow"     "red")
     (kom-first-line-face default  nil          "lavender")))
  "Face schemes for LysKOM.

This variable is an association list that defines the face and color
schemes in LysKOM. The car of each element is the scheme key, a
symbol, and the cdr is a list of face definitions. Each face
definition in tur, is a list of four elements: the face name, the base
face, foreground color and background color. When LysKOM defines a
face from such a specification, the base face is first copied and then
the foreground and background colors are set. If it permissible to
substitute nil for any element except the face name.

For instance, (kom-me-face bold \"yellow\" \"red\") will cause kom-me-face
to be bold with yellow text on a red background."
)


;;; ============================================================
;;; History lists
;;;

(defvar lyskom-command-history nil)
(defvar lyskom-expression-history nil)
(defvar lyskom-message-history nil)
(defvar lyskom-language-history nil)
(defvar lyskom-fast-reply-history nil)



(eval-and-compile (provide 'lyskom-vars))

;;; vars.el ends here
