// -*- C++ -*-
/* This file is part of
 * =================================================
 * 
 *          LyX, The Document Processor
 *          Copyright 1995 Matthias Ettrich.
 *          Copyright 1995-2000 The LyX Team.
 *
 * ================================================= 
 *
 * \author Michael Koziarski
 * */

#ifndef GPREAMBLE_H
#define GPREAMBLE_H

#ifdef __GNUG__
#pragma interface
#endif

#include "ControlPreamble.h"
#include "GnomeBase.h"

namespace Gtk {
class Button;
class Text;
}

/**
 * This class implements the dialog to modify the LaTeX preamble
 */
class GPreamble : public FormCB<ControlPreamble> {
public:
	///
	GPreamble(ControlPreamble & c);
	///
	~GPreamble();

	void apply();
	void update();
	
private:
	/// Build the dialog
	void build();

	/// Returns true if the dialog input is in a valid state.
	bool validate() const;
	
	///
	void connect_signals();
	///
	void disconnect_signals();

	/// generated by accessors.py
	Gtk::Button * ok_btn() const;
	/// generated by accessors.py
	Gtk::Button * apply_btn() const;
	/// generated by accessors.py
	Gtk::Button * cancel_btn() const;
	/// generated by accessors.py
	Gtk::Text * preamble() const;

	/// 
	SigC::Connection slot_preamble_;

	
};

#endif
