// -*- C++ -*-
/**
 * \file Toolbar_pimpl.h
 * Copyright 2002 the LyX Team
 * Copyright 1996-2001 Lars Gullik Bjnnes
 * Read the file COPYING
 *
 * \author Lars Gullik Bjnnes, larsbj@lyx.org
 */

#ifndef TOOLBAR_PIMPL_H
#define TOOLBAR_PIMPL_H

#include <vector>
#include FORMS_H_LOCATION

#include "frontends/Toolbar.h"

#include "commandtags.h"
#include "combox.h"
#include "ToolbarDefaults.h"

#ifdef __GNUG__
#pragma interface
#endif

class XFormsView;
class Tooltips;

/** The LyX xforms toolbar class
  */
struct Toolbar::Pimpl {
public:
	/// called when user selects a layout from combox
	static void layoutSelectedCB(int, void *, Combox *);
	///
	Pimpl(LyXView * o, int x, int y);
	///
	~Pimpl();

	/// (re)sets the toolbar
	void set(bool doingmain = false);

	/** this is to be the entry point to the toolbar
	    frame, where you can change the toolbar realtime.
	*/
	void edit();
	/// add a new button to the toolbar.
	void add(int, bool doclean = true);
	/// invokes the n'th icon in the toolbar
	void push(int);
	/// activates the toolbar
	void activate();
	/// deactivates the toolbar
	void deactivate();
	/// update the state of the icons
	void update();

	/// select the right layout in the combox
	void setLayout(string const & layout);
	/// Populate the layout combox; re-do everything if force is true.
	void updateLayoutList(bool force);
	/// Drop down the layout list
	void openLayoutList();
	/// Erase the layout list
	void clearLayoutList();
	/// the non-static version of layoutSelectedCB
	void layoutSelected();

	///
	struct toolbarItem
	{
		///
		int action;
		///
		FL_OBJECT * icon;
		///
		toolbarItem();
		///
		void clean();
		///
		~toolbarItem();
		///
		toolbarItem & operator=(toolbarItem const & ti);
	};

	/// typedef to simplify things
	typedef std::vector<toolbarItem> ToolbarList;
	/// The list containing all the buttons
	ToolbarList toollist;
	///
	XFormsView * owner;
	///
	Tooltips * tooltip_;
	///
	Combox * combox;
	/// Starting position
	int sxpos;
	///
	int sypos;
	///
	int xpos;
	///
	int ypos;
	///
	bool cleaned;

	/// removes all toolbar buttons from the toolbar.
	void clean();

	/// more...
	void reset();

	/// more...
	void lightReset();

	/** This is a fudge needed to overcome some wierd xforms behaviour.
	    If the tooltips are set before the dialog is visible, then they
	    are not displayed. No, I don't understand either.

	    This is a fix for LyX branch 1_2_X. It will not be ported forward
	    into 1.3 and beyond; a better fix should be found.
	 */
	void setTooltips();
};

#endif
