/* This file is part of
 * =================================================
 * 
 *          LyX, The Document Processor
 *          Copyright 1995-2000 The LyX Team.
 *
 * ================================================= 
 *
 * \author Michael Koziarski
 * \author Baruch Even
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include <config.h>

#include "gnomeBC.h"
#include "GError.h"

#include <gtk--/button.h>
#include <gtk--/text.h>

GError::GError(ControlError & c)
	: FormCB<ControlError>(c, "GError")
{}


void GError::build()
{
	// Connect the buttons.
	button_close()->clicked.connect(SigC::slot(this, &GError::CloseClicked));

	// Manage the buttons state
	bc().setCancel(button_close());

	// Make sure everything is in the correct state.
	bc().refresh();
}


void GError::update()
{
	textarea()->insert(controller().params());
}

Gtk::Button * GError::button_close() const 
{
        return getWidget<Gtk::Button>("r_button_close");
}

Gtk::Text * GError::textarea() const 
{
        return getWidget<Gtk::Text>("r_textarea");
}
