/**
 * \file xforms/GUIRunTime.C
 * Copyright 2000-2001 The LyX Team.
 * See the file COPYING.
 *
 * \author unknown
 */

#include <config.h>

#include FORMS_H_LOCATION

#ifdef __GNUG__
#pragma implementation
#endif

#include "GUIRunTime.h"
#include "XFormsView.h"
#include "debug.h"

#ifdef USE_XFORMS_IMAGE_LOADER
#include "xformsGImage.h"
#else
#include "graphics/GraphicsImageXPM.h"
#endif

using std::endl;
using std::hex;


extern bool finished;

namespace {

int const xforms_include_version = FL_INCLUDE_VERSION;

} // namespace anon


int GUIRunTime::initApplication(int &, char * [])
{
	// Check the XForms version in the forms.h header against
	// the one in the libforms. If they don't match quit the
	// execution of LyX. Better with a clean fast exit than
	// a strange segfault later.
	// I realize that this check have to be moved when we
	// support several toolkits, but IMO all the toolkits
	// should try to have the same kind of check. This could
	// be done by having a CheckHeaderAndLib function in
	// all the toolkit implementations, this function is
	// responsible for notifing the user.
	// if (!CheckHeaderAndLib()) {
	//         // header vs. lib version failed
	//         return 1;
	// }
	int xforms_lib_version = fl_library_version(0, 0);
	if (xforms_include_version != xforms_lib_version) {
		lyxerr << "You are either running LyX with wrong "
			"version of a dynamic XForms library\n"
			"or you have build LyX with conflicting header "
			"and library (different\n"
			"versions of XForms. Sorry but there is no point "
			"in continuing executing LyX!" << endl;
		return 1;
	}
	return 0;
}


void GUIRunTime::processEvents()
{
	if (fl_do_forms() == FL_EVENT) {
		XEvent ev;
		fl_XNextEvent(&ev);
		lyxerr << "Received unhandled X11 event" << endl;
		lyxerr << "Type: 0x" << hex << ev.xany.type <<
			" Target: 0x" << hex << ev.xany.window << endl;
	}
}


void GUIRunTime::runTime()
{
	while (!finished) {
		if (fl_check_forms() == FL_EVENT) {
			XEvent ev;
			fl_XNextEvent(&ev);
			lyxerr << "Received unhandled X11 event" << endl;
			lyxerr << "Type: 0x" << hex << ev.xany.type <<
				" Target: 0x" << hex << ev.xany.window << endl;
		}
	}
}


void GUIRunTime::setDefaults()
{
	FL_IOPT cntl;
	cntl.buttonFontSize = FL_NORMAL_SIZE;
	cntl.browserFontSize = FL_NORMAL_SIZE;
	cntl.labelFontSize = FL_NORMAL_SIZE;
	cntl.choiceFontSize = FL_NORMAL_SIZE;
	cntl.inputFontSize = FL_NORMAL_SIZE;
	cntl.menuFontSize  = FL_NORMAL_SIZE;
	cntl.borderWidth = -1;
	cntl.vclass = FL_DefaultVisual;
	fl_set_defaults(FL_PDVisual
			| FL_PDButtonFontSize
			| FL_PDBrowserFontSize
			| FL_PDLabelFontSize
			| FL_PDChoiceFontSize
			| FL_PDInputFontSize
			| FL_PDMenuFontSize
			| FL_PDBorderWidth, &cntl);
}


LyXView * GUIRunTime::createMainView(int w, int h)
{
	return new XFormsView(w, h);
}



// Called by the graphics cache to connect the appropriate frontend
// image loading routines to the LyX kernel.
void GUIRunTime::initialiseGraphics()
{
	using namespace grfx;
	using SigC::slot;

#ifdef USE_XFORMS_IMAGE_LOADER
	// connect the image loader based on the xforms library
	GImage::newImage.connect(slot(&xformsGImage::newImage));
	GImage::loadableFormats.connect(slot(&xformsGImage::loadableFormats));
#else
	// connect the image loader based on the XPM library
	GImage::newImage.connect(slot(&GImageXPM::newImage));
	GImage::loadableFormats.connect(slot(&GImageXPM::loadableFormats));
#endif
}


Display * GUIRunTime::x11Display()
{
	return fl_get_display();
}


int GUIRunTime::x11Screen()
{
	return fl_screen;
}


Colormap GUIRunTime::x11Colormap()
{
	return fl_state[fl_get_vclass()].colormap;
}


int GUIRunTime::x11VisualDepth()
{
	return fl_get_visual_depth();
}

float GUIRunTime::getScreenDPI()
{
	Screen * scr = ScreenOfDisplay(fl_get_display(), fl_screen);
	return ((HeightOfScreen(scr) * 25.4 / HeightMMOfScreen(scr)) +
		(WidthOfScreen(scr) * 25.4 / WidthMMOfScreen(scr))) / 2;
}
