--document { symbol WeylAlgebra,
--     TT "WeylAlgebra", " --
--     name for an optional argument for a monoid that
--     specifies that a PolynomialRing created from it will
--     be a Weyl Algebra.",

--     PARA,
--     "The n-th Weyl algebra is the associative ring on 2n variables,
--     e.g. K<x_1..x_n, D_1..D_n>, where all the variables commute except
--     for (D_i x_i = x_i D_i + 1).  It can be viewed as the ring
--     of algebraic differential operators on affine space K^n.",

--     PARA,
--     "A simple example:",
--     EXAMPLE "W = QQ[x,y,Dx,Dy, WeylAlgebra => {x=>Dx,y=>Dy}]",
--     EXAMPLE "x*Dx", 
--     EXAMPLE "Dx*x",
     
--     PARA,
--     "Caveats and known problems:",
--     MENU{"The variables can be called by any name, but for each
--	  pair such as x => Dx, the commutative variable (in this case x)
--	  must be listed before the derivation variable (in this case Dx)"}
--     }



document { symbol createDpairs,
     TT "createDpairs W", " -- 
     attaches to a Weyl algebra W a pair of keys to help distinguish the
     coordinate variables from the derivation variables.",
     
     PARA,
     "Since the Weyl algebra has commutation rules, this routine
     attaches to the Weyl algebra two keys to organize the
     variables.  The first key 'dpairVars' contains 3 lists: a list of the coordinate
     variables, a list of the derivative variables, and a list
     of the central variables.  The second key 'dpairInds' also contains 3 lists
     of the corresponding indices to 'dpairVars'.",

     PARA,
     "A simple example:",
     EXAMPLE "W = QQ[x,y,Dx,Dy, WeylAlgebra => {x=>Dx,y=>Dy}]",
     EXAMPLE "createDpairs W", 
     EXAMPLE "W.dpairVars",
     EXAMPLE "W.dpairInds",

     PARA,
     SEEALSO {"WeylAlgebra"}

--     "Ways to use ", TO "createDpairs",
--     MENU {"createDpairs (PolynomialRing) -- creates the variable and index lists
--          and attaches them to a Weyl algebra W"}, 
--     "Caveats and known problems :",
--     MENU{"Input should be a Weyl algebra"},
--     "See also :",
--     MENU{HREF{"/HOME/WeylAlgebra.html","WeylAlgebra"}}
     },

document { symbol Fourier,
     TT "Fourier L", " -- computes the Fourier transform of a ring element L",
     BR, NOINDENT,
     TT "Fourier I", " -- computes the Fourier transform of an ideal I",
     BR, NOINDENT,
     TT "Fourier m", " -- computes the Fourier transform of a matrix m",

     PARA,
     "The Fourier transform is the automorphism of the Weyl algebra
     which sends x_i to D_i and D_i to -x_i.",

     PARA,
     "A simple example:",
     EXAMPLE "W = QQ[x,y,Dx,Dy, WeylAlgebra => {x=>Dx,y=>Dy}]",
     EXAMPLE "L = x^2*Dy + y*Dy^2 + 3*Dx^5*Dy",       
     EXAMPLE "Fourier L",

     PARA,
     SEEALSO {"WeylAlgebra"}

--     "Ways to use ", TO "Fourier",
--     MENU {"Fourier (RingElement) -- returns the Fourier transform
--	  of an element L of the Weyl algebra",
--	  "Fourier (Ideal) -- returns the Fourier transform
--	  of an ideal I of the Weyl algebra",
--	  "Fourier (Matrix) -- returns the Fourier transform
--	  of a matrix m of the Weyl algebra"},
--     "See also :",
--     MENU{HREF{"/HOME/WeylAlgebra.html","WeylAlgebra"}}     
     },

document { symbol Dtransposition,
     --BIG "Drestriction",
     TT "Dtransposition L", " -- computes the standard transposition of a ring element L",
     BR, NOINDENT,
     TT "Dtransposition I", " -- computes the standard transposition of an ideal I", 
     BR, NOINDENT,
     TT "Dtransposition m", " -- computes the standard transposition of a matrix L",
     BR, NOINDENT,
     TT "Dtransposition C", " -- computes the standard transposition of a chain complex C",

     PARA,
     "The standard transposition is the involution of the Weyl algebra
     which sends x^a d^b to (-d)^b x^a.
     It provides the equivalence in the Weyl algebra between left
     and right D-modules.",

     PARA,
     "A simple example:",
     EXAMPLE "W = QQ[x,y,Dx,Dy, WeylAlgebra => {x=>Dx,y=>Dy}]",
     EXAMPLE "L = x^2*Dy + y*Dy^2 + 3*Dx^5*Dy",       
     EXAMPLE "Dtransposition L",

     PARA,
     "Caveats and known problems :",
     MENU{"The standard transposition of a left ideal should be a right
	  ideal, however M2 currently doesn't support right modules.
	  Thus the output is left ideal generated by the transposition
	  of the previous generators."},

     SEEALSO {"WeylAlgebra"}

--     "Ways to use ", TO "Dtransposition",
--     MENU {"Dtransposition (RingElement) -- returns the standard transposition
--	  of an element L of the Weyl algebra",
--	  "Dtransposition (Ideal) -- returns the standard transposition
--	  of the generators of an ideal I of the Weyl algebra",
--	  "Dtransposition (Matrix) -- returns the standard transposition
--	  of a matrix m of the Weyl algebra"},
--     "See also :",
--     MENU{HREF{"/HOME/WeylAlgebra.html","WeylAlgebra"}}
     },

document { symbol singLocus,
     TT "singLocus M", " -- 
     computes the singular locus of a D-module M",
     BR, NOINDENT,
     TT "singLocus M", " -- 
     computes the singular locus of the quotient module D/I",

     PARA,
     "The singular locus of the system of PDE's given by I
     generalizes the notion of singular point of an ODE.
     Geometrically, the singular locus of a D-module M equals the projection
     of the characteristic variety of M minus the zero section
     of the cotangent bundle to the base affine space C^n.",
     
--     PARA,
--     "The algorithm to compute singular locus  consists of computing
--     the characteristic ideal of M, which lives in a commutative ring with
--     variables x's and xi's -- where the xi's are the prinicipal symbols
--     of the d's.  The characteristic ideal is next saturated with respect
--     to the ideal (xi_1,...,xi_n), which corresponds to subtracting
--     the zero section, and finally is intersected with the subring
--     C[x_1,...,x_n], which corresponds to projection onto the base space.
--     See the book 'Grobner deformations
--     of hypergeometric differential equations' by 
--     Saito-Sturmfels-Takayama (1999) for more details.",

     PARA,
     "A simple example:",
     EXAMPLE "W = QQ[x,y,Dx,Dy, WeylAlgebra => {x=>Dx,y=>Dy}]",
     EXAMPLE "I = ideal (x*Dx+2*y*Dy-3, Dx^2-Dy)", 
     EXAMPLE "singLocus I",

     PARA,
     SEEALSO {"charIdeal", "Drank", "Ddim"}

--     "Ways to use ", TO "singLocus",
--     MENU {"singLocus (Ideal) -- returns the singular locus of D/I",
--	  "singLocus (Module) -- returns the singular locus of M"},
--     "See also :",
--     MENU{HREF{"/HOME/charIdeal.html","charIdeal"},
--	  HREF{"/HOME/Drank.html","Drank"}}
     },

document { symbol charIdeal,
     TT "charIdeal M", " -- 
     computes the characteristic ideal of a D-module M",
     BR, NOINDENT,
     TT "charIdeal I", " -- 
     computes the characteristic ideal of the quotiet module D/I",

     PARA,
     "The characteristic ideal of M is the annihilator of
     gr(M) under a good filtration with respect to the order
     filtration .  If D is the Weyl
     algebra C<x_1,....,x_n,d_1,...,d_n>, then the order filtration
     corresponds to the weight vector (0,...,0,1...,1).
     The characteristic ideal
     lives in the associated graded ring of D with respect to
     the order filtration, and this is a commutative polynomial ring 
     C[x_1,....,x_n,xi_1,...,xi_n] -- here the xi's are
     the symbols of the d's.
     The zero locus of the characteristic
     ideal is equal to the characteristic variety of (D/I), which
     is an invariant of a D-module.",
     
--     PARA,
--     "The algorithm to compute the characteristic ideal consists of computing
--     the initial ideal of I with respect to the weight vector
--     (0,...,0,1...,1).  See the book 'Grobner deformations
--     of hypergeometric differential equations' by 
--     Saito-Sturmfels-Takayama (1999) for more details.",

     PARA,
     "A simple example:",
     EXAMPLE "W = QQ[x,y,Dx,Dy, WeylAlgebra => {x=>Dx,y=>Dy}]",
     EXAMPLE "I = ideal (x*Dx+2*y*Dy-3, Dx^2-Dy)", 
     EXAMPLE "charIdeal I",

     PARA,
     SEEALSO {"Ddim", "singLocus", "Drank"}

--     "Ways to use ", TO "charIdeal",
--     MENU {"charIdeal (Ideal) -- returns the characteristic ideal
--	  of an ideal I of the Weyl algebra",
--	  "charIdeal (Module) -- returns the characteristic ideal
--	  of a module M over the Weyl algebra"},
--     "See also :",
--     MENU{HREF{"/HOME/inw.html","inw"},
--	  HREF{"/HOME/singLocus.html","singLocus"},
--	  HREF{"/HOME/Drank.html","Drank"}}
     },

document { symbol Drank,
     --BIG "Drestriction",
     TT "Drank M", "-- calculates the rank of a D-module M",
     BR, NOINDENT,
     TT "Drank I", "-- calculates the rank of the quotient module D/I",

     PARA,
     "The rank of a D-module M = D^r/N provides analytic information
     about the system of PDE's given by N.  In particular, a theorem of 
     Cauchy states that the dimension of holomorphic solutions to N in a
     neighborhood of a nonsinugular point is equal to the rank.",
     
     PARA,
     "The rank of a D-module is defined algebraically as follows. 
     Let D denote
     the Weyl algebra C<x_1,...,x_n,d_1,...,d_n> and let
     R denote the ring of differential operators
     C(x_1,...,x_n)<d_1,...,d_n> with rational function coefficients.
     Then the rank of M = (D^r/N) is equal to the dimension of (R^r/RN)
     as a vector space over C(x_1,...,x_n).",
    
     PARA,
--     "The algorithm to compute rank consists of computing
--     gr(M) with respect to the order filtration, which is a module
--     over a commutative ring with
--     variables x's and xi's -- where the xi's are the prinicipal symbols
--     of the d's.  The x's are then all set to 1 to give a module J
--     over the polynomial ring C[xi_1,...,xi_n], and the rank
--     is equal to the dimension of J as a
--     vector space over C.  See the book 'Grobner deformations
--     of hypergeometric differential equations' by 
--     Saito-Sturmfels-Takayama (1999) for more details.",

     PARA,
     "A simple example:",
     EXAMPLE "W = QQ[x,y,Dx,Dy, WeylAlgebra => {x=>Dx,y=>Dy}]",
     EXAMPLE "I = ideal (x*Dx+2*y*Dy-3, Dx^2-Dy)", 
     EXAMPLE "Drank I",

     PARA,
     SEEALSO {"charIdeal", "singLocus", "Ddim"}

--     "Ways to use ", TO "Drank",

--     MENU {"Drank (Ideal) -- returns the rank of D/I",
--	  "Drank (Module) -- returns the rank of M"},

--     "See also:",
     
--     MENU{HREF{"/HOME/charIdeal.html","charIdeal"},
--	  HREF{"/HOME/singLocus.html","singLocus"}}	  
     },

document { symbol Ddim,
     TT "Ddim M", "-- calculate the dimension of a D-module M ",
     BR, NOINDENT, 
     TT "Ddim I", "-- calculate the dimension of the quotient D/I",

     PARA,
     "The dimension of M is equal to the dimension of
     the associated graded module with respect to the Bernstein 
     filtration. A module is holonomic if it has dimension n
     where D = C<x_1,...,x_n,d_1,...,d_n>.",

     PARA,
     "A simple example:",
     EXAMPLE "W = QQ[x,y,Dx,Dy, WeylAlgebra => {x=>Dx,y=>Dy}]",
     EXAMPLE "I = ideal (x*Dx+2*y*Dy-3, Dx^2-Dy)", 
     EXAMPLE "Ddim I",

     PARA,
     SEEALSO {"charIdeal", "Drank", "singLocus"}

     --"Ways to use ", TO "Ddim",

     --MENU {"Ddim (Ideal) -- returns the dimension of the D-module D/I",
     --  "Ddim (Module) -- returns the dimension of the D-module M"},

     --"See also :",
     
     --MENU{HREF{"/HOME/inw.html","inw"}}
     },

document { symbol makeWeylAlgebra,
     TT "makeWeylAlgebra R", " -- 
     makes the Weyl algebra corresponding to a commutative polynomial
     ring R.",
     
     PARA,
     "Given a polynomial ring R with variables x_1,..,x_n, this
     routine returns a Weyl algebra with variables x_1,..,x_n
     and dx_1,..,dx_n.",
     
     PARA,
     "A simple example:",
     EXAMPLE "R = QQ[x,y,z]",
     EXAMPLE "W = makeWeylAlgebra R",

     PARA,
     "Caveats and known problems :",
     MENU{"The polynomial ring R must be commutative."},

     PARA,
     "Abbreviations :",
     MENU{"makeWA"},
 
     PARA,
     SEEALSO {"WeylAlgebra"}

     }
