clearAll();
path = join( path, {"../"} );
load "Dloadfile.m2";

----------------- TESTS for Drestriction & Dintegration--------------------

--Example 1: Derived restriction of a GKZ hypergeometric system
I = gkz(matrix{{1,1,1},{0,1,3}}, {1/2,1/3});
W = ring I;

-- No integer roots in b-function
assert(DrestrictionIdeal(I, {1,3,5}) == ideal 1_QQ);
assert(Drestriction(0, I, {1,3,5}) == QQ^0);
Dr = Drestriction(I, {1,3,5});
assert(all(toList(0..3), i -> (Dr#i == QQ^0)));
Dc = DrestrictionComplex(I, {1,3,5});
assert(all(toList(0..3), i -> (Dc.dd#i == map QQ^0)) );

assert(DintegrationIdeal(I, {1,3,5}) == ideal 1_QQ);
assert(Dintegration(0, I, {1,3,5}) == QQ^0);
Dr = Dintegration(I, {1,3,5});
assert(all(toList(0..3), i -> (Dr#i == QQ^0)));
Dc = DintegrationComplex(I, {1,3,5});
assert(all(toList(0..3), i -> (Dc.dd#i == map QQ^0)) );


--Example 2: Derived restriction of a GKZ hypergeometric system
I = gkz(matrix{{1,2,4}},{1});
J = gkz(matrix{{1,3,4}},{-3});

F1 = DrestrictionIdeal(I, {1,5,0});
F2 = DrestrictionIdeal(I, {25,6,0});
assert(F1 == substitute(F2, ring F1));

F1 = Drestriction(I, {1,5,0});
F2 = Drestriction(I, {1,6,0});

assert(all (toList(0..2), i -> (F1#i == map(ring F1#i, ring F2#i) ** F2#i)));

-- Example 3: Restriction and Integration of a rational function
W = QQ[y,t,Dy,Dt, WeylAlgebra => {y=>Dy, t=>Dt}];
I = ideal(2*t*Dy+Dt, t*Dt+2*y*Dy+2); -- annihilator of 1/(t^2-y)
resI = DrestrictionIdeal(I, {1,0});
assert(resI == substitute(ideal(t*Dt + 2), ring resI));
assert(DintegrationIdeal(I, {1,4}) == DintegrationIdeal(I, {3,1}));

--Example 4: Derived integration of a GKZ hypergeometric system
I = gkz(matrix{{1,1,1},{0,1,3}}, {-3,-2});
W = ring I;
F = DintegrationAll(I, {1,3,5});
FV = F#VResolution;
FC = F#GenCycles;
assert all(toList(0..3), i -> (
	  apps = Dtransposition ((FV.dd#i)*(FC#i));
	  if (apps == 0) then true
	  else (apps % directSum apply(toList(1..rank target apps), 
		    j -> matrix{W.dpairVars#1}) == 0) ));
