-- Divisors on Rational Normal Scrolls
--

1. Define r.n.scrolls: use det form
2. Some divisors:
   F = fiber
   H = hyperplane section
   X_0 is given by V(x_0) = S(d1,...,dl) \cup X_0
   state that Pic S is generated by H, F.
   K = ...
3. Intersection theory:
   Basic problem: intersect a Cartier divisor 
     by a curve, take its degree.
     Write this as a script too.
   For a scroll surface, get: F^2 = 0, H.F = 1,
   and H^2 = d, where d is the sum of d_i 's.
   Also compute this for a Weil divisor, by
     multiplying up to a Cartier divisor, and
     then dividing.
   Given the canonical module, determine
   that it is aH+bF, find a,b.
4. How to tell what scroll you have?
   Given a fiber.
---------------------------------------------
-- A. The ideal of the rational normal scroll
---------------------------------------------
 Given a sequence of non-negative integers
d_1, d_2, \ldots, d_m, define the rational
normal scroll $S = S(d_1, \ldots, d_m)$
to be the projective variety defined by the
2 x 2 minors of the $2 x (d_1 + \ldots + d_m)$
matrix
$$\pmatrix{...}$$
The scroll has dimension m, and degree d
in the projective space of dimension m+d-1,
and so is a variety of minimal degree.

-- Take S to be the scroll S(2,1,1) \subset {\bf P}^6.

R = Z/32003[a..g] -- The coordinate ring of P6
m = matrix{{a, b, d, f},
           {b, c, e, g}}

I = image minors(2,m)

-- Let's automate this process by creating a function
-- which will yield this matrix.  The input to the
-- function will be a list of integers 'dl', and
-- a ring 'R' which should have enough variables in it.

scrollMatrix = (dl, R) -> (
    n := #dl;
    count := 0;
    matrix {apply(dl, d-> (
	m := matrix table(2, d, 
              (i,j) -> R_(count + i + j));
        count = count + d + 1;
        m))}
    )

R = Z/32003[a..g]
m = scrollMatrix({2,1,1}, R)
I = image minors(2,m)

-----------------------------------------------
-- B. Divisors on the scroll, and their modules
-----------------------------------------------
-- The columns of this matrix define a morphism
-- S ---> P^1, and the fibers are thus defined by
-- the entries of any generalized row of 'm'.

F = image submatrix(m, {0}, {0..m-1})

-- Choose a hyperplane section
H = ideal(a)

-- The Picard group of any scroll S is generated by
-- H and F.

-- Another interesting divisor on S is X0 defined
-- as V(a) = ...
------------------------------
-- C. Sections of line bundles
------------------------------
-- construct the graded module representing the 
-- line bundle O(H-3F).
-- This is done as follows:
-- O(H) is the module S^{1}
-- O(F) is represented by the module Hom(IF,S) (over S)
-- and O(3F) is the tensor product O(F) ** O(F) ** O(F)
-- now O(H-3F) is represented by
-- M = Hom(O(H),O(3F)).  The result has depth 2, since ...
-- and so H^0(O(H-3F)) is generated by the degree zero
-- part of the module M.
--
-- Notice that there is exactly one section.  Let's
-- find its image.
------------------------------------------
-- D. Intersections of divisors and curves
------------------------------------------

intersectDivisor = (D,C) -> (
    -- D is a Cartier divisor, i.e. a module which is
    -- locally free.
    -- C is the ideal of a (possibly singular) curve.
    -- Step 1: find a section of D, or of D+dH, some d.
    -- Step 2: Intersect the curve with this section.
    -- Step 3: The degree of this intersection is
    --   (D + dH).C = s, so D.C = s - d*(deg C)
    -- and return this number!
    )

Divisor + Divisor := (D,E) -> doubleDual(D ** E);
Divisor - Divisor := (D,E) -> Hom(D,E);
- Divisor := (D) -> Hom(D, ring D)

Z Divisor := (n,D) -> ...
Divisor == Divisor := (D,E) -> ...
randomSection(D)
isCartier Divisor := ...
isWeil Divisor := ...
sections(D)
divisor M
