/* $Header: /home/jcb/newmj/RCS/client.h,v 10.0 2000/12/07 21:31:53 jcb Rel $
 * client.h
 * header file for client support routines.
 */
/****************** COPYRIGHT STATEMENT **********************
 * This file is Copyright (c) 2000 by J. C. Bradfield.       *
 * Distribution and use is governed by the LICENCE file that *
 * accompanies this file.                                    *
 * The moral rights of the author are asserted.              *
 *                                                           *
 ***************** DISCLAIMER OF WARRANTY ********************
 * This code is not warranted fit for any purpose. See the   *
 * LICENCE file for further information.                     *
 *                                                           *
 *************************************************************/

#ifndef CLIENT_H_INCLUDED
#define CLIENT_H_INCLUDED 1

#include "game.h"

/* client_init: takes an address, attempts to connect to
   a controller on that address. Internally, allocates game structure etc.
   Returns a pointer to the allocated game structure, or NULL.
*/
Game  *client_init(char *address);

/* client_connect: take an id and a name, and send a connect message.
   Return 1 on success, or 0 on failure. */
int client_connect(Game *g, int id, char *name);

/* client_close: given game, close the connection and deallocate
   the storage. Returns NULL.
*/
Game *client_close(Game *g);

/* client_send_packet sends a packet to the controller */
int client_send_packet(Game *g, PMsgMsg *m);

/* client_find_sets: this takes a player and a discard (or HiddenTile)
   and finds sets that can be declared.
   If a discard is supplied, only sets involving the discard
   are returned.
   It returns a pointer to an array of TileSets, terminated by
   an Empty TileSet; but if no sets are found, NULL is returned.
   The returned array is in static storage, and is valid
   until the next call of this function.
   If the mj flag is 1, then the hand is assumed to be complete,
   and the sets must lead to a complete hand. Otherwise, the highest scoring
   set is returned.
   The return value is a TileSet: empty if no set could be found.
   NOTE: kongs are never returned if either there is no discard (obviously)
   or if the mj flag is true (equally obviously).
   As a convenience, if the final argument is nonnull, then it will be
   updated to point to an array of players, which are the results of
   executing the related sets. These are also in static storage.
   (N.B. For a kong declaration, the associated player is not valid.)
*/
TileSet *client_find_sets(PlayerP p, Tile d, int mj, PlayerP *pcopies);
#endif /* CLIENT_H_INCLUDED */
