.\" $Header: /home/jcb/newmj/RCS/xmj.man,v 10.11 2001/02/11 22:50:14 jcb Exp $
.\" Copyright (c) 2000 J. C. Bradfield
.de TQ
.br
.ns
.TP \\$1
..
.TH XMJ 1 "Mah-Jong" "J.C.Bradfield"
.SH NAME
xmj, mj\-server, mj\-player \- programs for playing Mah\-Jong
.SH SYNOPSIS
.TP
\fBxmj\fP [\fB\-\-id \fIidnumber\fP]
  [\fB\-\-server \fIaddress\fP]
  [\fB\-\-name \fIplayername\fP]
  [\fB\-\-connect\fP]
  [\fB\-\-show\-wall\fP | \fB\-\-no\-show\-wall\fP]
  [\fB\-\-size N\fP]
  [\fB\-\-animate\fP]
  [\fB\-\-tile\-pixmap\-dir \fIdirectory\fP]
  [\fB\-\-dialogs\-popup\fP | \fB\-\-dialogs\-below\fP | \fB\-\-dialogs\-central\fP]
  [\fB\-\-echo\-server\fP]
  [\fB\-\-pass\-stdin\fP]
.TP 
\fBmj\-server\fP [\fB\-\-server \fIaddress\fP]  [\fB\-\-timeout \fIseconds\fP]
  [\fB\-\-pause \fIdeciseconds\fP]
  [\fB\-\-random\-seats\fP]
  [\fB\-\-exit-on-disconnect\fP]
  [\fB\-\-debug\fP]
  [\fB\-\-logfile \fIfile\fP]
  [\fB\-\-no-special-scores\fP]
  [\fB\-\-seed N\fP]
  [\fB\-\-nohist\fP]
.TP 
\fBmj\-player\fP [\fB\-\-id \fIidnumber\fP] [\fB\-\-server \fIaddress\fP]
  [\fIundocumented options\fP]

.SH DESCRIPTION
A set of three programs to play Mah-Jong on Unix systems, against
people or programs, over the Internet.
.TP
.B mj\-server
is the program that handles communications and control of
the game; the rules and scoring are enforced there. Players, human or
computer, connect to a server via the network.
.TP
.B mj\-player
is a computer player. At present, it is fairly simplistic, 
having only offensive tactics with no knowledge of defensive play.
.TP
.B xmj
is the X client for human players.

.SH QUICK START
If you don't want to read this long document: to start a game against
three computer players, start \fBxmj\fR, select "New Game..." from the 
"Connect" menu, and click "Start Game". (Wait about ten seconds for
everything to start up.)

.SH OPTIONS

.SS All Programs
.TP
.BI --server " address"
specifies the network address to listen on (for \fBmj-server\fR) or to
connect to (for \fBmj-player\fR and \fBxmj\fR).
If \fIaddress\fR contains a colon, it specifies an Internet socket, and
should have the form \fIhost:port\fR . If \fIaddress\fR does not contain a colon, it 
is interpreted as a Unix file name and a Unix socket is used.
The default value for \fIaddress\fR is  localhost:5000 .
\fIaddress\fR can also be set in a dialog box in \fBxmj\fR.

.SS xmj and mj-player
.TP
.BI \-\-id " idnumber"
The server assigns a unique integer ID (which is currently just 1 to 4 
in order of connection) to each player. This ID should be quoted when
reconnecting to a game in progress (after, for example, losing a
network connection or accidentally killing \fBxmj\fR). The default ID
is 0, which denotes no pre-assigned ID. 
.TP 
.BI \-\-name " name"
Players can give themselves names which will be used by client
programs. This option specifies the name. For \fBxmj\fR, the default
is the value of the environment variable LOGNAME, or failing that the
username of the logged in user. For \fBmj-player\fR, the default is
\"Robot(\fIPID\fR)\" where \fIPID\fR is the process id.

.SS xmj
.TP
.B \-\-connect
By default, \fBxmj\fR does not automatically connect to a server,
but waits for the user to connect via a menu. If this option is
specified, \fBxmj\fR immediately connects.
.TP
.B \-\-show\-wall
.TQ
.B \-\-no\-show\-wall
Tells \fBxmj\fR (not) to display the wall. By default, the wall is shown
only if running on a big enough screen.
.TP
.BI \-\-size " number"
This option adjusts the size of the main window. It should be thought
of as the length of a tile rack, measured in tiles. The default
is 19, or 18 if on an 800x600 display. The smallest usable value
is 14. This is not yet changeable while the program is running,
but since the programs correctly handle dis\- and re\-connecting in the
middle of a game, this is not a major drawback.
.br
If the \fB\-\-show\-wall\fR option is given, a \fB\-\-size\fR smaller than 19 will
have no effect.
.TP
.B \-\-animate
This option switches on some animation. Not all tile movements
are animated: only those that involve moving tiles to or from
a hand from outside.
.br
I'm not very keen on this; its main purpose is to draw attention
to the tile being discarded or whatever. I welcome comments on
whether it is liked, and whether it should be extended.
.TP
.BI \-\-tile\-pixmap\-dir " directory"
\fBxmj\fR needs pixmaps to display the tiles and the tong box.
This option tells it which directory to find them in.
The default is set at compilation time; the default default
is to use the compiled\-in tiles.
.TP
.B \-\-dialogs\-popup
By default, most of the dialog boxes for player actions are
part of the main window. If this option is used, they will
instead appear as separate transient windows.
.TP
.B \-\-dialogs\-below
By default, dialog boxes appear in the centre of the table.
If this option is given, dialogs (apart from some popups) 
are positioned below the table area. Please let me know
which style you prefer!
.TP
.B \-\-dialogs\-central
The default: dialog boxes appear in the middle of the table.
.TP
.B \-\-echo\-server
If this option is given, \fBxmj\fR will echo to  stdout  all the
protocol messages received from the server.
.TP
.B \-\-pass\-stdin
If this option is given, \fBxmj\fR will send any text given on stdin
to the server.

.SS mj-server
.TP
.BI --timeout " seconds"
When a discard is made, there is a limit on the time players have
to claim it. This option sets the timeout; a value of
zero disables it. The default is 15 seconds.
.TP
.BI --pause " deciseconds"
This will make the server enforce a delay of \fIdeciseconds\fR/10
seconds between each action in the game; the purpose is to slow
programmed players down to human speed (or, in a teaching situation,
to slow the game even more). The current server considers that 50
(i.e. 5 seconds) is the maximum reasonable value for this option.
.br
The option can also be requested by players, via a Player Option
protocol request.
.TP
.B --random\-seats
By default, players are seated in order of connection to the
server. This option seats them randomly. It will become the
default later.
.TP
.B --exit-on-disconnect
If this option is given, the server will quit if any player
disconnects, rather than waiting indefinitely for reconnection.
.TP
.B --debug
This enables various debugging features. In particular, it
enables protocol commands that allow one to change the tiles
in a hand...
.TP
.BI --logfile " file"
The server will write a complete record of the game to \fIfile\fR;
this will be quite large, and is only useful for automatic comparison of
different computer players.
.TP
.B --no-special-scores
This option suppresses the scoring of points and doubles for flowers
and seasons. It is primarily intended for running tests of different
players; for human use, a game option will be provided to eliminate
the specials altogether.
.TP
.B --seed N
This option specifies the seed for the random number functions.
Used for repeatable tests.
.TP
.B --nohist
Another option only used in automatic comparison: this saves some
CPU time by disabling the book-keeping required to allow players
to disconnect and reconnect.

.SS mj-player
has numerous options affecting its strategy, but these are
not yet documented as they are not at all stable.
Just as an example, and a way to get some variation in the play,
.br
mj-player --pungerweight 2.0
.br
will start a player that tries quite hard to avoid chows, and
consequently tends to win less often with higher scores.

.SH USING THE XMJ PROGRAM
The main window contains a menu-bar and a table area; the table is
in a tasteful shade of dark green. The table displays a stylized
version of the game: stylized in that there is no jazzy graphics or
perspective, and the tiles are not intended to be pictures of real
objects, and so on. Otherwise, the layout is as one would expect of a
real game. However, the wall may or may not be displayed, depending on
option settings and screen size. (See above.)

Specifically, the four players are arranged around the four edges of
the table, with "us" at the bottom. For each player, the concealed
tiles are displayed nearest the edge of the table; our own tiles are
visible, the other players' tiles are face-down.
In front of the concealed tiles are (to the player's left) any
declared sets, and (to the player's right) flowers and seasons, and
the tong box if the player is East. The tong box displays the wind of
the round in a white circle. If necessary, the flowers and seasons
will overflow into the concealed row.

The discards are displayed face-up in the middle of the board: they
are laid down in order by each player, in the natural
orientation. TODO: add options to display discards randomly, or
face-down.
If animation (see \fB--animate\fR option) is not being used, then the
most recent discard will be highlighted in red.

In principle, every face-up tile can display its name when the mouse
is moved over it ("tile-tips":-), but this is not yet implemented.

Our tiles are displayed in sorted order, which happens to be
Bamboos (1-9), Characters (1-9), Circles (1-9), Winds (ESWN),
Dragons (RWG), Flowers, Seasons.

Actions are generally carried out by clicking a button in a dialog box 
that appears in the middle of the board. For many actions, a tile must 
be selected. A tile is selected or unselected by single-clicking it;
when selected, it appears as a depressed button.
The program will generally pre-select a sensible tile:
specifically:
.br
during the initial declaration of special tiles, the rightmost
special is selected;
.br
after we draw a tile from the wall, the drawn tile is selected;
.br
when declaring concealed sets after going Mah Jong, the first
undeclared tile is selected.

To describe the possible actions, let us run through the course of a
game.

First select "New Game..." from the "Connect" menu. A panel will
appear. The default options are to play a game against the computer,
so click "Start Game". 
After a few seconds, a game will start. (NOTE: this assumes correct
installation. If this fails, start a server and players manually, and
use the "Connect to server..." menu item.)

The first thing that happens is a dialog box "Ready to start next
hand".  The server will not start playing a hand until all players
have indicated their willingness to continue play.

Next, the tiles are dealt. Then each player in turn is expected to
declare flowers and seasons. When it is our turn, a dialog will appear 
with the following buttons:
.TP
Declare
declare the selected flower or season. (Note: the
program auto-selects the rightmost special tile.)
If no tile is selected, this finishes declarations.
.TP
Kong
If we have a concealed kong, we can declare it now with
this button.
.TP
Finish
Finish declaring specials.
.PP
When all players have finished declaring specials, a dialog box
appears, asking (on East's behalf) permission to continue.

During play, when we draw a tile from the wall, it will be
auto-selected. We may also of course select a different tile.
A dialog will appear giving us the following possibilities:
.TP
Discard
discard the selected tile. This button also serves
to declare a flower or season.
.TP
&Calling
discard the selected tile and declare a calling hand.
This button is only shown when calling is allowed
(by default, only Original Call is allowed).
.TP
Kong
declare a concealed kong of the selected tile
.TP
Add to Pung
add the selected tile to an exposed pung
.TP
Mah Jong!
declare Mah Jong! (no selection needed)
.PP
Hitting Return within the dialog is equivalent to pressing Discard.
TODO: keyboard accelerators for the other actions, working everywhere.

A tile can also be discarded simply by double-clicking it.

When another player discards, a dialog appears to allow us to claim
it. If the dialogs are in the middle of the table, the dialog displays
the tile in a position and orientation to indicate the player who discarded;
if the dialogs are at the bottom, this is not done, to save space.
In any case the dialog displays the name of the tile, and buttons
for the possible claims. (Note: in the default case, it is possibly
confusing that the discarded tile can be seen both on the table and in
the dialog box. Opinions are sought on this point.) 
Note: there appear to be subtle bugs in GTK, which mean that 
sometimes the name of the tile does not appear properly. I have
completely failed to track this down; if it happens, just close
(that's minimize in Windoze-speak) the window and open it again.
There is also a `progress bar' which shows how time is running out.
The buttons use one variant of traditional English terminology, viz:
.TP
No claim
we don't claim this tile. If there is no timeout in
operation, it is necessary to click this to indicate
a "pass", and in any case it is desirable to speed up
play.
.TP
Chow
claim for a sequence.
If our claim is successful and there is more than one
possible sequence to be made, a dialog will appear asking
us to specify which one.
.TP
Pung
claim for a triplet.
.TP
Kong
claim for quadruplet.
.TP
Mah Jong!
claim for Mah Jong.
If the claim succeeds, a dialog box will appear asking
whether we want the tile for "Eyes", "Chow", "Pung", or a
"Special Hand" (such as Thirteen Unique Wonders).
(The term "Eyes" is used instead of "Pair" so that when
keyboard accelerators are implemented, E is different
from P! Is it better to stick to "Pair"?)
.PP
When a player (including us) claims, the word "Chow!" etc. will appear
(in big letters on a yellow background, if things are correctly set
up; please tell me if this doesn't happen) for a couple of seconds
above the player's tiles.

When all players have claimed, or timed out, the successful claim is
implemented; no additional announcement is made of this. (Should it
be?)

If a player adds a tile to an exposed pung, and that tile would give
us Mah Jong, then a dialog box pops up to ask whether we wish to rob the kong.

After somebody goes Mah Jong, we are asked to declare our concealed
sets. A dialog appears with buttons for "Eyes", "Chow", "Pung". To declare a
set, select a tile, which must be the \fBfirst\fR tile in the set for a
chow, and click the appropriate button. (If we are going Mah Jong, the
first undeclared tile is auto-selected.) When finished, click "Done" to
reveal the remaining tiles to the other players. 
If we are the winner, there will be a button for "Special Hand": this is 
used to declare hands of non-standard shape, such as Thirteen Unique
Wonders.

At this point, a new top-level window appears to display the scoring
information. The scoring is done entirely by the server, not by the
players; the server sends a text description of the score calculation, 
and this is displayed for each player in the Scoring window. 
The information in the Scoring window remains there until the next
hand is scored; the window can be brought up at any time via the
"Show" menu.

Finally, the "continue with next hand" dialog appears. The hand just
completed will remain visible on the table until the next hand starts.


An additional top-level window showing the state of the game can be
obtained by selecting "Game info" from the "Show" menu.

There is also a facility for sending text messages to the other
players. Select "Messages" from the "Show" menu, and a window will
appear: in the top is a display of all messages sent, and below
is a single line in which you can enter your message. It will be
send when you hit Return. The message window pops up automatically 
whenever a message is received.

.SS Starting games and re-connecting
The "Connect" menu has the "New Game..." item to start a completely
new game, and the "Connect to server..." item to connect to an
existing game. The dialogs for both these have the following entries:
.TP
Checkboxes for Internet/Unix server
These specify whether the server is listening on an Internet socket
or a Unix socket. If an Internet (TCP) socket, the host name and port
number should be entered in the appropriate boxes; if a Unix socket,
the file name of the socket should be entered.
.TP
"Player ID" and "Name" fields
The "Player ID" should be left at 0, unless reconnecting to an
existing game, in which case it should be the ID assigned by the
server on first connecting to that game. The "Name" field can be
anything. When reconnecting to an existing game, if the ID is given as 
0, the server will try to use the "Name" to identify the player. (This
may not be true in future.)
.PP
The "Connect to server..." dialog then simply has a "Connect" button
to establish the connection. The "New Game..." has the following
fields:
.TP
For each of three further players,
A checkbox to say whether to start a computer player. (Some of) these
should be unchecked if you wish other humans to join the games.
If checked, there is a text entry field in which options can be given
to the players; this should only be used if you understand the options!
.TP
An "allow disconnection" checkbox
If this is checked, the server that is started will continue to run
even if players disconnect. If it is not checked, the server will quit 
if any player disconnects. If you are playing one against the
computer, this should generally be left unchecked, in order to avoid
server processes accidentally being left lying around. If playing
against people, it should be checked, to allow players to go away, or
to guard against network outages.
.TP
A "seat players randomly" checkbox
If this is left unchecked, players will be initially seated as East,
South, West, North in order of connection. (We always connect first.)
If it is checked, the seating will be random.
.TP
A numeric entry field
to specify the time limit for claiming discards.
If set to 0, there will be no time limit.
.TP
A button to start the game
Note that it takes a few seconds to start a game, during which time
the dialog stays up with the button pressed. (TODO: fix this!)

.SH UPDATES
The latest release of the Unix Mah-Jong programs should be available at
.br
\fBhttp://www.stevens-bradfield.com/MahJong/\fR
\fBhttp://www.dcs.ed.ac.uk/home/jcb/MahJong/\fR

.SH RULES

The game currently implemented is a version of the classical Chinese
game. The most convenient and comprehensive set of rules is that
provided by A. D. Millington, "The Complete Book of Mah-Jongg", 
Weidenfield & Nicolson (1993), ISBN 0 297 81340 4.
In the following, M 103 denotes item 103 of the rules laid out in Chapter 3 
of that book. I here describe only the differences from these
rules, some of which differences are consequences of using computers,
and some of which are points where my house rules differ from
Millington's version. In due course, all variations (of Chinese
classical) will be accommodated, if there is sufficient desire.

Classification of tiles (M 1-8): the tiles are a standard Chinese set.
The tiles do not have Arabic numerals, except for the flowers and
seasons, where the identifying Chinese characters are too small to be
legible. ACKNOWLEDGMENT: the tiles (other than flowers and seasons)
are not my work. See the README in the tiles/ directory for credits.

Preliminary (M 9-10): nothing to say.

Duration of the game (M 11-14): standard rules. In particular, the
title of East does not pass after a wash-out.

Selection of seats (M 15): the players are seated in the
order they connect to the server, or randomly, according to the option 
given to the server.

The deal etc. (M 16-27): There is no attempt to simulate the usual
dealing ritual (M 16-20, 23-26); the wall is built randomly by the
server. The dead wall is also maintained by the server.
The dead wall is handled per Millington: namely, it is initially 16
tiles (M 22), and is not extended during play. Replacement tiles for
kongs are drawn from the dead wall, but replacements for bonus
tiles are drawn from the live wall (M 31).
It is intended to provide an option for the other common style of dead 
wall, namely 14 tiles, replenished, with bonus replacements from the
dead wall.

Object of game (M 28-31): all winning hands must comprise four sets
and a pair, with the sole exception of the Thirteen Unique Wonders.
Support for Seven Pairs may be added if there is demand.

Bonus tiles (M 31): M requires that bonus tiles must be declared in
the turn in which they are drawn; otherwise the player may not
exchange or score them (and thus they cannot go out). We do not make
this restriction, as it is (a) pointless (b) unenforceable in real
life. Bonus tiles may be declared at any time after drawing from the
wall. (Obviously, there is no reason not to declare them immediately.)

Commencement of the Game (M 32-33): standard.

Playing procedure (M 34-38): standard.
In particular, the other players have to give permission for
east to start playing (M 34).
The display of discards cannot be controlled by the server; the
current X client displays them in an organized fashion, rather than
the random layout required by M 35.

Chow (M 39-42): standard.

Pung (M 43-45): standard.

Kongs (M 46-52): M distinguishes three types of kong: concealed,
claimed (by Kong), and annexed (formed by adding a discard to an
exposed pung), and allows claimed kongs to be counted as concealed for 
the purposes of doubling combinations. We do not do this, following
the more common convention of treating such a kong as exposed for all
purposes.
Players may declare a concealed kong, or add to a pung,
only when they have just drawn a tile from the wall (live or dead);
not just after a claiming a discard. (A silly restriction in my view,
but one that all rule sets seem to have (M 51).)

Calling and Mah Jong (M 53-54): standard. (I.e. there is no "Calling"
declaration.)

NOTE: M permits players to change their mind about making a claim 
(M 69); we do not, and all claims are irrevocable. Question: should we 
allow revocation?

Original Call (M 55): the Original Call declaration must be made
simultaneously with the first discard, rather than afterwards.
NOTE: the server does *not* check that the declarer does indeed
have a calling hand, as a mistaken original call does not damage the
other players or the progress of the game. The server does, however,
thereafter prevent the declarer from changing their hand; therefore a
mistaken original call will make it impossible to go out. (Note: in M, 
an Original Caller may change their hand, but will thereby lose the
ability to go out (M 55(b)); is this a better way to treat it?)
Note also: as per M, an original call can be made even if another
player has claimed a discard before, unlike the Japanese version.

Robbing a Kong (M 57-60): Robbing a kong is implemented. However, as
with discards, we require that kongs are robbed before anything else
happens, and in particular before the konger draws a replacement tile.
Therefore, after a kong, all other players must either claim Mah Jong
or pass. (The provided programs will pass automatically if robbing is
not possible.) As for discards, there is a time limit.

Precedence of claims for discard (M 61-65):
Many rules allow a discard to be claimed up until the time the next
discard is made. M does this, with elaborate rules for the precise
specification.
For ease of implementation, we do not allow this: instead, all players 
are required to make a claim or pass, and once all players have
claimed, the successful claim is implemented irrevocably.
The server imposes a time limit; players that do not claim within
the limit are deemed to have passed. This defaults to 15 seconds,
but can be changed or disabled by the players (see program documentation).

Irregularities in Play (M 66-81): the server does not permit unlawful
moves, and so no irregularities can arise.

False Declaration of Mah Jong (M 82-83): such declarations are not
permitted by the server.

False Naming of Discards (M 84-88): this also cannot happen.

Incorrect Hands (M 89): cannot happen.

Letting Off a Cannon (M 90-96): as in M. However, if a player makes
a dangerous discard, but has no choice, the server will determine
this; it is not necessary to plead "no choice" explicitly, and neither 
is the player's hand revealed to the other players.

Wash-Out (M 97-99): standard.

Points of Etiquette (M 100-102): not applicable.

Displaying the Hand (M 103-106):
The format of display is a matter for the client program, and cannot
be controlled by the server.
After Mah Jong, the players are responsible for declaring concealed
sets in whatever way they wish. The winner, of course, is required to
declare a complete hand; but the losers may declare as they wish.
Once a set is declared, it cannot be revoked. Note that the losers may 
declare multiple scoring pairs.

Procedure in Settlement (M 107-111):
The settlement is standard: that is, the winner gets the value of
their hand from all players; the losers pay one another the
differences between their scores; except all payments to or from East
are doubled; and if players let off a cannon, they pay everybody's debt.
Unlike normal play (M 110), all hands are scored by the server, rather 
than by the players. Settlement is also computed by the server.

Method of Scoring (M 112-122):
The method is standard (M 112), viz calculate points obtained from
sets and bonuses, and then apply doubles.

The following points are given for tiles:
.TP
Bonus tiles:
4 each (M 114(a))
.TP
Pungs:
2 for exposed minor tiles; 4 for exposed major or concealed minor;
8 for concealed major. (M 114(b))
.TP
Kongs:
8 for exposed minor; 16 for exposed major or concealed minor;
32 for concealed major. (M 114(c))
.TP
Chows:
no score. (M 114(d))
.TP
Pair:
2 for a pair of Dragons, Own Wind, or Prevailing Wind.
A pair that is both Own and Prevailing Wind scores 4. (M 114(e))
Non-winning hands may score more than one pair.
.TP
Basic points:
the winner gets 20 points for going Mah Jong.
(M 115(a) has 10 points. This will become an option.)
.TP
Winning from wall:
if the final tile is drawn from the wall, 2 points
are added (M 115(b)). 
.TP
Filling the only place:
if the final tile is the only denomination
that could have completed the hand, 2 points are added (M 115(c)).
NOTE: As in M, if all four copies of a tile are exposed on the table,
it does not count as available for completing the hand.
.TP
Fishing the eyes:
a player who completes by obtaining a pair gets 2
points if the pair is minor, or 4 if major (M 115(d)).
Note: to obtain these points for a discard, the player must actually
claim the discard for a pair: e.g. if waiting on 5677, and 7 is
discarded, the player must claim for the pair, not the chow.
.PP
The following doubles apply to all hands.
All possible clauses apply unless stated otherwise.
.TP
Having own flower AND own season,
1 double. (M 116(a)). 
.TP
Having all four flowers,
1 double. (M 116(b)).
.TP
Having all four seasons,
1 double. (M 116(b)).

(Note: there will be options to change the flower/season doubles to
less conservative values.)
.TP
Each set of dragons,
1 double. (M 116(d))
.TP
A set of the player's own wind,
1 double. (M 116(e))
.TP
A set of the prevailing wind,
1 double. (M 116(f))
.TP
"Little Three Dragons": two sets and a pair of dragons.
1 double. (M 116(g))
.TP
"Big Three Dragons": three sets of dragons.
2 doubles. (M 116(h))
.TP
"Little Four Winds": three sets and a pair of winds.
1 double. (M 116(i))
.TP
"Big Four Winds": four sets of winds.
2 doubles. (M 116(j))

(Note: the definitions of these last four doubles when applied to
non-winning hands are subject to wide variations. Possibly there
should be options to allow other possibilities.)
.TP
Three concealed pungs:
1 double. (M 116(k))
(Note: M allows a claimed kong to count as concealed for this hand;
see the note above under "Kongs". We do not.)
.PP
The following doubles apply to the winning hand only:
.TP
No score hand: four chows and a non-scoring pair.
1 double. (M 117(a))
(Note: like M, we allow any of the extra points (Fishing the Eyes,
etc) to go with this double. Some rules say that the extra points
invalidate this hand. Possibly there should be an option for this.)
.TP
No chows:
1 double. (M 117(b))
.TP
Concealed hand:
1 double. (M 117(c))
(Note: according to a discussion on rec.games.mahjong, this double is
classically awarded to a hand that is concealed up to the point of Mah 
Jong. One book in my possession (U.S.A., early 1920s) awards it to a
hand that is concealed except for the pair. Perhaps there should be
options.)
.TP
One suit with honours (with at least one set of honours):
1 double. (M 117(d))
.TP
One suit only:
3 doubles. (M 117(e))
.TP
All majors:
1 double. (M 117(f))
.TP
All honours (in an unlimited game):
2 doubles. (M 117(g)) 
(Should this also get the double for all majors? It doesn't now.)
.TP
All terminals (in an unlimited game):
2 doubles. (Not in M)
(Should this also get the double for all majors? It doesn't now.)
.TP
Winning with loose tile:
1 double. (M 117(h))
(Note: in the current setup, replacements for bonus tiles come from
the live wall. Hence this double applies only to winning after Kong.)
.TP
Winning from the bottom of the sea (winning with last tile),
1 double. (M 117(i))
.TP
Catching a fish from the bottom of the sea (winning with last discard),
1 double. (M 117(j))
.TP
Robbing a kong,
1 double. (M 117(k))
.TP
Completing Original Call,
1 double. (M 117(l))
.PP
Limit (M 118-120): the limit is currently 1000. There will be an
option to change this.

The following hands are limit hands:
.TP
Heaven's Blessing: East wins with dealt hand. (M 122(a))
.TP
Earth's Blessing: player wins with East's first discard. (M 122(b))
.TP
Gathering Plum Blossom from the Roof: winning with 5 Circles from the
loose wall. (M 122(c))
.TP
Catching the Moon from the Bottom of the Sea: winning with 1 Circle as 
the last tile. (M 122(d))
(Note: M says that the tile must be drawn. It seems more reasonable
also to allow it to be the last discard, which is what we
do. Objections?)
.TP
Scratching a Carrying Pole: robbing a kong of 2 Bamboos. (M 122(e))
.TP
(Note: these last three limits are rather arbitrary, but of the
arbitrary limits they are apparently the most common. There should be
options to disable them.)
.TP
Kong upon Kong: making a Kong, making another Kong with the loose
tile, and with the second loose tile obtaining Mah Jong. (Also, of
course, with three or four successive kongs.) (M 122(f))
.TP
Four Kongs. (M 122(g))
.TP
Buried Treasure: all concealed and no chows. (M 122(h))
.TP
The Three Great Scholars: three sets of dragons and no chows. (M 122(i))
(Note: in most rules I have seen, there is no restriction to a no chow 
hand. Since in M's rules, three sets and a chow scores at least
(10 (M has 10 for Mah Jong) + 12 (at least 3 pungs))
times 8 (2 for each set of dragons) times 4 (for Big Three Dragons)
= 704, this is significant with the default limit. For us, with 20 for
going out, Big Three Dragons is over the default limit anyway.)
.TP
Four Blessings o'er the Door: four sets of winds and a pair. (M 122(j))
.TP
All Honours. (M 122(k))
.TP
Heads and Tails: all terminals. (M 122(l))
.TP
Imperial Jade: contains only Green Dragon and 2,3,4,6,8 Bamboo. (M 122(m))
(Note: another rather arbitrary hand, but widely adopted.)
.TP
Nine Gates: calling on 1-1-1-2-3-4-5-6-7-8-9-9-9 of one suit. (M 122(n)).
.TP
Wriggling Snake: 1-1-1-2-3-4-5-6-7-8-9-9-9 plus 2, 5 or 8 of 
one suit (M 122(o)).
(Note: another rather arbitrary hand.)
.TP
Concealed Clear Suit: one suit only and all concealed. (M 122(p))
.TP
Thirteen Unique Wonders: one of each major tile, and a match to any of 
them. (M 122(q))
.TP
East's 13th consecutive Mah-Jong. (M 122(r))
.PP

General note: there are many other doubles and limits kicking
around. I welcome opinions on which should be possible options; and
also on which of the above I should eject from the default set.
I dislike Imperial Jade, Wriggling Snake, and the ones depending on a
specific tile (Gathering Plum Blossom, Catching the Moon, Scratching a 
Carrying Pole): which of these are so commonly adopted that they
should be in even a fairly minimalist default set?
