/* $Header: /home/jcb/newmj/RCS/gui-dial.c,v 10.15 2001/02/09 22:37:39 jcb Exp $
 * gui-dial.c
 * dialog box functions.
 */
/****************** COPYRIGHT STATEMENT **********************
 * This file is Copyright (c) 2000 by J. C. Bradfield.       *
 * Distribution and use is governed by the LICENCE file that *
 * accompanies this file.                                    *
 * The moral rights of the author are asserted.              *
 *                                                           *
 ***************** DISCLAIMER OF WARRANTY ********************
 * This code is not warranted fit for any purpose. See the   *
 * LICENCE file for further information.                     *
 *                                                           *
 *************************************************************/

#include "gui.h"

static const char rcs_id[] = "$Header: /home/jcb/newmj/RCS/gui-dial.c,v 10.15 2001/02/09 22:37:39 jcb Exp $";

static void continue_callback(GtkWidget *w, gpointer data);
static void turn_callback(GtkWidget *w, gpointer data);


/* Used sordidly and internally */
static GtkRequisition discard_req = { 0, 0};
/* Why an array? So I can pass pointers around */
DiscardDialog discard_dialog[1];

/* dialog box for specifying chows */
GtkWidget *chowdialog;
/* Stores the three TileSetBoxes */
static TileSetBox chowtsbs[3];
/* and the three buttons */
static GtkWidget *chowbuttons[3];

/* dialog box for declaring specials */
GtkWidget *ds_dialog;

/* dialog box for continuing with next hand */
GtkWidget *continue_dialog;

/* dialog for opening connection */
GtkWidget *open_dialog;
GtkWidget *openmenuentry, *newgamemenuentry, *closemenuentry;

/* dialog box for action when it's our turn.
   Actions: Discard  Kong  Add to Pung  Mah Jong
*/
GtkWidget *turn_dialog;

/* dialog box for closed sets when scoring.
   Actions: Eyes  Chow  Pung  Done
*/
GtkWidget *scoring_dialog;

/* window for game status display */
GtkWidget *status_window;

/* window for "about" information */
GtkWidget *about_window;

/* an array of text widgets for displaying scores etc.
   Element 4 is for settlements.
   The others are for each player: currently, I think
   these should be table relative.
*/
GtkWidget *scoring_notebook;
GtkWidget *textpages[5];
GtkWidget *textlabels[5]; /* labels for the pages */
GtkWidget *textwindow; /* and the window for it */

/* The window for messages, and the display text widget */
GtkWidget *messagewindow, *messagetext;


/* time at which progress bar was started */
static struct timeval pstart;
static int pinterval = 25; /* timeout interval in ms */
static int pbar_timeout_instance = 0; /* track dead timeouts */
static GtkWidget *pbar;

/* timeout handler for the dialog progress bar */
static int pbar_timeout(gpointer instance) {
  int timeleft;
  struct timeval timenow;

  if ( pbar_timeout_instance != (int) instance ) return FALSE; /* dead timeout */
  if ( ! GTK_WIDGET_VISIBLE(discard_dialog->widget) ) return FALSE;
  gettimeofday(&timenow,NULL);
  timeleft = ptimeout-(1000*(timenow.tv_sec-pstart.tv_sec)
	      +(timenow.tv_usec-pstart.tv_usec)/1000);
  if ( timeleft <= 0 ) {
    /* we should not hide the claim dialog: the timeout is really
       controlled by the server, not us */
    return FALSE;
  }
  gtk_progress_bar_update(GTK_PROGRESS_BAR(pbar),1.0-(timeleft+0.0)/(ptimeout+0.0));
  return TRUE;
}

/* popup the discard dialog. Arguments:
   Tile, player whence it came (as an ori),
   mode = 0 (normal), 1 (claiming tile for mah jong), 2 (claiming from kong) */
void discard_dialog_popup(Tile t, int ori, int mode) {
  gint x,y,w,h;
  int i;
  static Tile lastt; static int lastori, lastmode;
  static int positioned = 0;

  /* So that we don't work if it's already popped up: */
  if ( GTK_WIDGET_VISIBLE(discard_dialog->widget)
       && t == lastt && lastori == ori && lastmode == mode ) return;
  lastt = t; lastori = ori; lastmode = mode;

  if ( mode != discard_dialog->mode ) {
    discard_dialog->mode = mode;
    if ( mode == 0 ) {
      gtk_widget_show(discard_dialog->noclaim);
      gtk_widget_hide(discard_dialog->eyes);
      gtk_widget_show(discard_dialog->chow);
      gtk_widget_show(discard_dialog->pung);
      gtk_widget_hide(discard_dialog->special);
      gtk_widget_show(discard_dialog->kong);
      gtk_widget_show(discard_dialog->mahjong);
      gtk_widget_hide(discard_dialog->robkong);
    } else if ( mode == 1 ) {
      gtk_widget_hide(discard_dialog->noclaim);
      gtk_widget_show(discard_dialog->eyes);
      gtk_widget_show(discard_dialog->chow);
      gtk_widget_show(discard_dialog->pung);
      gtk_widget_show(discard_dialog->special);
      gtk_widget_hide(discard_dialog->kong);
      gtk_widget_hide(discard_dialog->mahjong);
      gtk_widget_hide(discard_dialog->robkong);
    } else {
      gtk_widget_show(discard_dialog->noclaim);
      gtk_widget_hide(discard_dialog->eyes);
      gtk_widget_hide(discard_dialog->chow);
      gtk_widget_hide(discard_dialog->pung);
      gtk_widget_hide(discard_dialog->special);
      gtk_widget_hide(discard_dialog->kong);
      gtk_widget_hide(discard_dialog->mahjong);
      gtk_widget_show(discard_dialog->robkong);
    }
  }
  if ( mode == 0 ) gtk_widget_grab_focus(discard_dialog->noclaim);

  /* center the dialog on the main window */
  /* Oh. I'd like to tell the window manager not to shift it
     when it puts the border round it. I wonder how I do that?
  */
  /* Note that the size has been fixed in the init routine.
     The reason we do this statically is so that we can
     force the bloody thing to have the right size: we want to
     hide buttons before showing it, but then it would have a
     different size on being shown.
     Also, we want it to have a fixed size so we can put
     the turn dialog to coincide with this one's bottom left.
  */
  switch ( dialogs_position ) {
  case DialogsCentral:
  case DialogsUnspecified:
    /* dialog is child of discard area */
    w = discard_area_alloc.width;
    h = discard_area_alloc.height;
    x = y = 0;
    gtk_widget_set_uposition(discard_dialog->widget,
			     x + w/2 - discard_req.width/2,
			     y + h/2 - discard_req.height/2);
    break;
  case DialogsPopup:
    /* only do this the first time; we should let the user position them */
    if ( ! positioned++ ) {
      gdk_window_get_size(topwindow->window,&w,&h);
      gdk_window_get_deskrelative_origin(topwindow->window,&x,&y);
      gtk_widget_set_uposition(discard_dialog->widget,
			       x + w/2 - discard_req.width/2,
			       y + h/2 - discard_req.height/2);
    }
    break;
  case DialogsBelow:
    ;
  }

  /* set the appropriate tile */
  for ( i=1 ; i < 4 ; i++ ) {
    if ( i == ori ) {
      button_set_tile(discard_dialog->tiles[i],t,i);
      gtk_widget_show(discard_dialog->tiles[i]);
    } else {
      gtk_widget_hide(discard_dialog->tiles[i]);
    }
  }
  gtk_widget_hide(discard_dialog->tilename);
  gtk_label_set_text(GTK_LABEL(discard_dialog->tilename),
		     (mode==1) ? "Claim discard for:" : 
		     tile_name(the_game->info.tile));
  if ( mode == 0 ) {
    static const gfloat xal[] = { 0.5,1.0,0.5,0.0 }; 
    gtk_misc_set_alignment(GTK_MISC(discard_dialog->tilename),
			  xal[ori],0.5);
  } else {
    gtk_misc_set_alignment(GTK_MISC(discard_dialog->tilename),
			  0.5,0.5);
  }
  gtk_widget_show(discard_dialog->widget);
  gtk_widget_show(discard_dialog->tilename);
  /* and start the progress bar timeout if appropriate */
  if ( the_game->state != MahJonging && ptimeout > 0 ) {
    gtk_widget_show(pbar);
    gettimeofday(&pstart,NULL);
    /* we may as well calculate an appropriate value of pbar_timeout
       each time... we want it to update every half pixel, or 40 times
       a second, whichever is slower */
    if ( pbar->allocation.width > 1 ) {
      /* in case it isn't realized yet */
      pinterval = ptimeout/(2*pbar->allocation.width);
    }
    if ( pinterval < 25 ) pinterval = 25;
    gtk_timeout_add(pinterval,pbar_timeout,(gpointer) ++pbar_timeout_instance);
  } else 
    gtk_widget_hide(pbar);
}

/* initialize it */
/* Structure:
   If the dialog is in the middle:
      lefttile opptile righttile
           tile name
         progress bar
      Pass/Draw Chow Pung Kong MahJong
   otherwise: 
      tilename   progress bar
         buttons
*/
void discard_dialog_init(void) {
  GtkWidget *box, *tilebox, *left, *opp, *right, *lbl,
      *butbox, *but, *pixm;
  DiscardDialog *dd = &discard_dialog[0];

  
  switch ( dialogs_position ) {
  case DialogsCentral:
  case DialogsUnspecified:
    /* event box so there's a window to have background */
    dd->widget = gtk_event_box_new();
    gtk_fixed_put(GTK_FIXED(discard_area),dd->widget,0,0);
    /* it'll be moved later */
    break;
  case DialogsBelow:
    dd->widget = gtk_event_box_new();
    gtk_box_pack_start(GTK_BOX(dialoglowerbox),dd->widget,1,0,0);
    /* show it, so that the top window includes it when first mapped */
    gtk_widget_show(dd->widget);
    break;
  case DialogsPopup:
    dd->widget = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_signal_connect (GTK_OBJECT (dd->widget), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_hide), NULL);
  }

  box = gtk_vbox_new(0,dialog_vert_spacing);
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(dd->widget),box);
  dd->mode = -1; /* so that personality will be set */
  gtk_container_set_border_width(GTK_CONTAINER(box),
				 dialog_border_width);

  tilebox = gtk_hbox_new(0,0);
  if ( dialogs_position != DialogsBelow ) gtk_widget_show(tilebox);
  
  left = gtk_button_new();
  GTK_WIDGET_UNSET_FLAGS(left,GTK_CAN_FOCUS);
  gtk_widget_show(left);
  pixm = gtk_pixmap_new(tilepixmaps[3][HiddenTile],NULL);
  gtk_widget_show(pixm);
  gtk_container_add(GTK_CONTAINER(left),pixm);
  opp = gtk_button_new();
  GTK_WIDGET_UNSET_FLAGS(opp,GTK_CAN_FOCUS);
  gtk_widget_show(opp);
  pixm = gtk_pixmap_new(tilepixmaps[2][HiddenTile],NULL);
  gtk_widget_show(pixm);
  gtk_container_add(GTK_CONTAINER(opp),pixm);
  right = gtk_button_new();
  GTK_WIDGET_UNSET_FLAGS(right,GTK_CAN_FOCUS);
  gtk_widget_show(right);
  pixm = gtk_pixmap_new(tilepixmaps[1][HiddenTile],NULL);
  gtk_widget_show(pixm);
  gtk_container_add(GTK_CONTAINER(right),pixm);
  gtk_box_pack_start(GTK_BOX(tilebox),left,0,0,0);
  gtk_box_pack_start(GTK_BOX(tilebox),opp,1,0,0);
  gtk_box_pack_end(GTK_BOX(tilebox),right,0,0,0);
  dd->tiles[1] = right;
  dd->tiles[2] = opp;
  dd->tiles[3] = left;
  
  lbl = gtk_label_new("name of tile");
  gtk_widget_show(lbl);
  dd->tilename = lbl;

  butbox = gtk_hbox_new(1,dialog_button_spacing); /* homogeneous, spaced */
  gtk_widget_show(butbox);
  
  but = gtk_button_new_with_label("No claim");
  gtk_widget_show(but);
  gtk_box_pack_start(GTK_BOX(butbox),but,1,1,0);
  gtk_signal_connect(GTK_OBJECT(but),"clicked",
		     disc_callback,(gpointer)NoClaim);
  dd->noclaim = but;

  but = gtk_button_new_with_label("Eyes");
  GTK_WIDGET_UNSET_FLAGS(but,GTK_CAN_FOCUS);
  /* not shown in normal state */
  gtk_box_pack_start(GTK_BOX(butbox),but,1,1,0);
  gtk_signal_connect(GTK_OBJECT(but),"clicked"
		     ,disc_callback,(gpointer)PairClaim);
  dd->eyes = but;

  but = gtk_button_new_with_label("Chow");
  GTK_WIDGET_UNSET_FLAGS(but,GTK_CAN_FOCUS);
  gtk_widget_show(but);
  gtk_box_pack_start(GTK_BOX(butbox),but,1,1,0);
  gtk_signal_connect(GTK_OBJECT(but),"clicked"
		     ,disc_callback,(gpointer)ChowClaim);
  dd->chow = but;

  but = gtk_button_new_with_label("Pung");
  GTK_WIDGET_UNSET_FLAGS(but,GTK_CAN_FOCUS);
  gtk_widget_show(but);
  gtk_box_pack_start(GTK_BOX(butbox),but,1,1,0);
  gtk_signal_connect(GTK_OBJECT(but),"clicked",
		     disc_callback,(gpointer)PungClaim);
  dd->pung = but;

  but = gtk_button_new_with_label("Special Hand");
  GTK_WIDGET_UNSET_FLAGS(but,GTK_CAN_FOCUS);
  /* gtk_widget_show(but); */ /* don't show this; uses other space */
  gtk_box_pack_start(GTK_BOX(butbox),but,1,1,0);
  gtk_signal_connect(GTK_OBJECT(but),"clicked",
		     disc_callback,(gpointer)SpecialSetClaim);
  dd->special = but;

  but = gtk_button_new_with_label("Kong");
  GTK_WIDGET_UNSET_FLAGS(but,GTK_CAN_FOCUS);
  gtk_widget_show(but);
  gtk_box_pack_start(GTK_BOX(butbox),but,1,1,0);
  gtk_signal_connect(GTK_OBJECT(but),"clicked",
		     disc_callback,(gpointer)KongClaim);
  dd->kong = but;

  but = gtk_button_new_with_label("Mah Jong");
  GTK_WIDGET_UNSET_FLAGS(but,GTK_CAN_FOCUS);
  gtk_widget_show(but);
  gtk_box_pack_start(GTK_BOX(butbox),but,1,1,0);
  gtk_signal_connect(GTK_OBJECT(but),"clicked",
		     disc_callback,(gpointer)MahJongClaim);
  dd->mahjong = but;

  but = gtk_button_new_with_label("Rob the Kong - Mah Jong!");
  GTK_WIDGET_UNSET_FLAGS(but,GTK_CAN_FOCUS);
  /* gtk_widget_show(but); */ /* don't show this; it uses the space of others */
  gtk_box_pack_start(GTK_BOX(butbox),but,1,1,0);
  gtk_signal_connect(GTK_OBJECT(but),"clicked",
		     disc_callback,(gpointer)MahJongClaim);
  dd->robkong = but;

  pbar = gtk_progress_bar_new();
  gtk_widget_show(pbar);

  /* These are packed in reverse order so they float to the bottom */
  gtk_box_pack_end(GTK_BOX(box),butbox,0,0,0);
  gtk_box_pack_end(GTK_BOX(box),lbl,0,0,0);
  gtk_box_pack_end(GTK_BOX(box),pbar,0,0,0);
  gtk_box_pack_end(GTK_BOX(box),tilebox,0,0,0);
  
  /* OK, now ask its size: store the result, and keep it
     this size for ever more */
  gtk_widget_size_request(dd->widget,&discard_req);
  gtk_widget_set_usize(dd->widget,discard_req.width,discard_req.height);
}

static GtkWidget *turn_dialog_discard_button;
static GtkWidget *turn_dialog_calling_button;

void turn_dialog_popup(void) {
  /* only original call is allowed, so hide the calling
     button after first discard */
  if ( pflag(our_player,NoDiscard) ) 
    gtk_widget_show(turn_dialog_calling_button);
  else 
    gtk_widget_hide(turn_dialog_calling_button);
  dialog_popup(turn_dialog,DPOnDiscardOnce);
  gtk_widget_grab_focus(turn_dialog_discard_button);
}

/* callback when we toggle one of our tiles.
   data is our index number.
   If data also has bit 7 set, force the tile active.
   If called with NULL widget, clear selection 
*/

void conc_callback(GtkWidget *w, gpointer data) {
  int active;
  int i;
  int force=0, index=-1;
  static GtkWidget *selected = NULL; /* for radiogroup functionality */

  active = (w && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)));
  if ( active ) index = ((int)data)& 127;
  force = (w && (((int)data) & 128));


  if ( w && just_doubleclicked == w) force = 1;

  /* make sure all other tiles are unselected, if we're active,
     or if we're called to clear: we don't just rely
     on the selected variable, since under some circumstances we
     can end up with two tiles active, by accident as it were */
  /* FIXME: this relies on induced callbacks being executed synchronously */
  if ( active || w == NULL) {
    for ( i = 0; i<14; i++ ) {
      if ( pdisps[0].conc[i] && pdisps[0].conc[i] != w) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pdisps[0].conc[i]),
				     FALSE);
      }
    }
  }
  selected_button = index;
  selected = NULL;
  if ( active ) selected = w;

  if ( w == NULL ) return;

  if ( force ) {
    /* if it's not active, set it active: we'll then
       be invoked normally, so we just return now. */
    if ( ! active ) {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w),TRUE);
      return;
    }
  }

  /* if we were double clicked, invoke the turn callback directly */
  if ( w && just_doubleclicked == w) {
    just_doubleclicked = 0;
    turn_callback(w,(gpointer)PMsgDiscard);
  }
}

/* This detects doubleclicks on the concealed buttons */
gint doubleclicked(GtkWidget *w, GdkEventButton *eb,gpointer data UNUSED) {
  if ( eb->type != GDK_2BUTTON_PRESS ) return FALSE;
  /* This is disgusting. We set a global doubleclicked flag,
     which is noticed by the toggle callback */
  just_doubleclicked = w;
  return FALSE;
}

/* callback attached to the buttons of the discarding dialog.
   They pass PMsgDiscard, PMsgDeclareClosedKong,
   PMsgAddToPung, or PMsgMahJong.
   Passed PMsgDiscard + 1000000 to declare calling.
   Also invoked by the declaring special callback:
    with DeclareSpecial to declare a special, Kong if appropriate,
    and NoClaim to indicate the end of declaration.
   Also invoked by scoring dialog with appropriate values */

void turn_callback(GtkWidget *w UNUSED, gpointer data) {
  PMsgUnion m;
  Tile selected_tile;

  m.type = (PlayerMsgType)data;

  if ( m.type == PMsgMahJong 
       || m.type == PMsgShowTiles
       || m.type == PMsgFormClosedSpecialSet ) {
    send_packet(&m);
    return;
  }

  if ( the_game->state == DeclaringSpecials
       && m.type == PMsgNoClaim ) {
    m.type = PMsgDeclareSpecial;
    conc_callback(NULL,NULL); /* clear the selection */
  }

  selected_tile = (selected_button < 0) ? HiddenTile : our_player->concealed[selected_button];

  /* in declaring specials, use this to finish */
  if ( selected_tile == HiddenTile ) {
    if ( the_game->state == DeclaringSpecials )
      m.type = PMsgDeclareSpecial;
    else {
      error_dialog_popup("No tile selected!");
      return;
    }
  }
  if ( is_special(selected_tile) )
    m.type = PMsgDeclareSpecial;

  switch ( m.type ) {
  case PMsgDeclareSpecial:
    m.declarespecial.tile = selected_tile;
    break;
  case PMsgDiscard:
    m.discard.tile = selected_tile;
    m.discard.calling = 0;
    break;
  case PMsgDiscard+1000000:
    m.type = PMsgDiscard;
    m.discard.tile = selected_tile;
    m.discard.calling = 1;
    break;
  case PMsgDeclareClosedKong:
    m.declareclosedkong.tile = selected_tile;
    break;
  case PMsgAddToPung:
    m.addtopung.tile = selected_tile;
    break;
  case PMsgFormClosedPair:
    m.formclosedpair.tile = selected_tile;
    break;
  case PMsgFormClosedChow:
    m.formclosedchow.tile = selected_tile;
    break;
  case PMsgFormClosedPung:
    m.formclosedpung.tile = selected_tile;
    break;
  default:
    warn("bad type in turn_callback");
    return;
  }
  send_packet(&m);
}
  
/* callback when one of the discard dialog buttons is clicked */
void disc_callback(GtkWidget *w UNUSED, gpointer data) {
  PMsgUnion m;

  switch ( (gint32) data) {
  case NoClaim:
    m.type = PMsgNoClaim;
    m.noclaim.discard = the_game->info.serial;
    break;
  case ChowClaim:
    m.type = PMsgChow;
    m.chow.discard = the_game->info.serial;
    m.chow.cpos = AnyPos; /* worry about it later */
    break;
  case PairClaim:
    m.type = PMsgPair;
    break;
  case SpecialSetClaim:
    m.type = PMsgSpecialSet;
    break;
  case PungClaim:
    m.type = PMsgPung;
    m.pung.discard = the_game->info.serial;
    break;
  case KongClaim:
    m.type = PMsgKong;
    m.kong.discard = the_game->info.serial;
    break;
  case MahJongClaim:
    m.type = PMsgMahJong;
    m.mahjong.discard = the_game->info.serial;
    break;
  default:
    warn("disc callback called with unexpected data");
    return;
  }

  /* if we're mahjonging, we mustn't send an anypos,
     so just call do_chow immediately */
  if ( the_game->state == MahJonging && m.type == PMsgChow ) {
    do_chow(NULL,(gpointer)AnyPos);
  } else {
    send_packet(&m);
  }
}

  /* Now create the Chow dialog box:
     Structure: three boxes, each containing a tileset showing
     a possible chow. Below that, a label "which chow?".
     Below that, three buttons to select.
  */
void chow_dialog_init(void)  {
  GtkWidget *box,*u,*v; int i;

  switch ( dialogs_position ) {
  case DialogsCentral:
  case DialogsUnspecified:
    chowdialog = gtk_event_box_new();
    gtk_fixed_put(GTK_FIXED(discard_area),chowdialog,0,0);
    break;
  case DialogsPopup:
  case DialogsBelow:
    chowdialog = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_signal_connect (GTK_OBJECT (chowdialog), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_hide), NULL);
    /* This one is allowed to shrink, and should */
    gtk_window_set_policy(GTK_WINDOW(chowdialog),1,1,1);
  }
  box = gtk_vbox_new(0,dialog_vert_spacing);
  gtk_container_set_border_width(GTK_CONTAINER(box),
				 dialog_border_width);
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(chowdialog),box);
  u = gtk_hbox_new(0,dialog_button_spacing);
  gtk_widget_show(u);
  gtk_box_pack_start(GTK_BOX(box),u,0,0,0);
  for (i=0;i<3;i++) {
    v = gtk_hbox_new(0,0);
    gtk_widget_show(v);
    gtk_box_pack_start(GTK_BOX(u),v,0,0,0);
    chowtsbs[i].widget = v;
    tilesetbox_init(&chowtsbs[i],0,do_chow,(gpointer)i);
  }
  u = gtk_label_new("Which chow?");
  gtk_widget_show(u);
  gtk_box_pack_start(GTK_BOX(box),u,0,0,0);
  u = gtk_hbox_new(1,dialog_button_spacing);
  gtk_widget_show(u);
  gtk_box_pack_start(GTK_BOX(box),u,0,0,0);
  for (i=0;i<3;i++) {
    v = gtk_button_new_with_label(player_print_ChowPosition(i));
    GTK_WIDGET_UNSET_FLAGS(v,GTK_CAN_FOCUS);
    gtk_widget_show(v);
    gtk_box_pack_start(GTK_BOX(u),v,1,1,0);
    chowbuttons[i] = v;
    gtk_signal_connect(GTK_OBJECT(v),"clicked",
		       do_chow,(gpointer)i);
  }
}

/* now create the declaring specials dialog.
   Contains a button for declare (special), kong, and done.
*/
static GtkWidget *ds_dialog_declare_button;

void ds_dialog_init(void) {
  GtkWidget *box, *bbox, *w;

  switch ( dialogs_position ) {
  case DialogsCentral:
  case DialogsUnspecified:
    ds_dialog = gtk_event_box_new();
    gtk_fixed_put(GTK_FIXED(discard_area),ds_dialog,0,0);
    break;
  case DialogsBelow:
    ds_dialog = gtk_event_box_new();
    gtk_box_pack_start(GTK_BOX(dialoglowerbox),ds_dialog,1,0,0);
    break;
  case DialogsPopup:
    ds_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_signal_connect (GTK_OBJECT (ds_dialog), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_hide), NULL);
  }
  
  box = gtk_vbox_new(0,dialog_vert_spacing);
  gtk_container_set_border_width(GTK_CONTAINER(box),
				 dialog_border_width);
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(ds_dialog),box);
  
  bbox = gtk_hbox_new(1,dialog_button_spacing);
  gtk_widget_show(bbox);
  gtk_box_pack_end(GTK_BOX(box),bbox,0,0,0);

  w = gtk_label_new("Declare Flowers/Seasons (and kongs)\nSelect tile and:");
  gtk_widget_show(w);
  gtk_box_pack_end(GTK_BOX(box),w,0,0,0);
  
  ds_dialog_declare_button = w = gtk_button_new_with_label("Declare");
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(bbox),w,1,1,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgDeclareSpecial);

  w = gtk_button_new_with_label("Kong");
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(bbox),w,1,1,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgDeclareClosedKong);

  w = gtk_button_new_with_label("Finish");
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(bbox),w,1,1,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgNoClaim);
}

void ds_dialog_popup(void) {
  dialog_popup(ds_dialog,DPCentredOnce);
  gtk_widget_grab_focus(ds_dialog_declare_button);

}
/* dialog to ask to continue with next hand */
static GtkWidget *continue_dialog_continue_button;
static GtkWidget *continue_dialog_label;

void continue_dialog_init(void) {
  GtkWidget *box, *w;

  switch ( dialogs_position ) {
  case DialogsCentral:
  case DialogsUnspecified:
    continue_dialog = gtk_event_box_new();
    gtk_fixed_put(GTK_FIXED(discard_area),continue_dialog,0,0);
    break;
  case DialogsBelow:
    continue_dialog = gtk_event_box_new();
    gtk_box_pack_start(GTK_BOX(dialoglowerbox),continue_dialog,1,0,0);
    break;
  case DialogsPopup:
    continue_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_signal_connect (GTK_OBJECT (continue_dialog), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_hide), NULL);
  }
  
  box = gtk_vbox_new(0,dialog_vert_spacing);
  gtk_container_set_border_width(GTK_CONTAINER(box),
				 dialog_border_width);
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(continue_dialog),box);
  
  continue_dialog_continue_button = w = gtk_button_new_with_label("Ready");
  gtk_widget_show(w);
  gtk_box_pack_end(GTK_BOX(box),w,0,0,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     continue_callback,(gpointer)PMsgDiscard);

  /* created and packed second so things float to bottom */

  continue_dialog_label = w = gtk_label_new("Here is some dummy text to space");
  gtk_widget_show(w);
  gtk_box_pack_end(GTK_BOX(box),w,0,0,0);
  
}

void continue_dialog_popup(void) {
  static char buf[256];
  /* the text of the display depends on whether we've said we're ready */
  if ( ! the_game->active ) {
    strcpy(buf,"Waiting for game to (re)start");
    gtk_label_set_text(GTK_LABEL(continue_dialog_label),buf);
    gtk_widget_hide(continue_dialog_continue_button);
  }
  else if ( the_game->info.ready[our_seat] ) {
    strcpy(buf,"Waiting for others ");
    strcat(buf,the_game->paused);
    gtk_label_set_text(GTK_LABEL(continue_dialog_label),buf);
    gtk_widget_hide(continue_dialog_continue_button);
  } else {
    strcpy(buf,"Ready ");
    strcat(buf,the_game->paused);
    strcat(buf,"?");
    gtk_label_set_text(GTK_LABEL(continue_dialog_label),buf);
    gtk_widget_show(continue_dialog_continue_button);
    gtk_widget_grab_focus(continue_dialog_continue_button);
  }
  dialog_popup(continue_dialog,DPCentredOnce);
}

static void continue_callback(GtkWidget *w UNUSED, gpointer data UNUSED) {
  PMsgReadyMsg rm;
  rm.type = PMsgReady;
  send_packet(&rm);
}

/* how many are up; used for positioning - not multi-thread safe! */
static int num_error_dialogs = 0; 

/* function called to close an error dialog */
static void kill_error(GtkObject *data) {
  gtk_widget_destroy(GTK_WIDGET(data));
  num_error_dialogs--;
}

/* popup an error box (new for each message) */
void error_dialog_popup(char *msg) {
  GtkWidget *box, *hbox, *w, *error_dialog, *error_message;
  
  if ( num_error_dialogs >= 10 ) {
    warn("Too many error dialogs up to print error: %s",msg);
    return;
  }

  error_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_signal_connect_object(GTK_OBJECT (error_dialog), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			    GTK_OBJECT(error_dialog));
  gtk_container_set_border_width(GTK_CONTAINER(error_dialog),
				 dialog_border_width);
  
  box = gtk_vbox_new(0,dialog_vert_spacing);
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(error_dialog),box);
  
  hbox = gtk_hbox_new(0,dialog_button_spacing);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(box),hbox,0,0,0);

  w = gtk_pixmap_new(tilepixmaps[0][ErrorTile],NULL);
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(hbox),w,0,0,0);

  error_message = gtk_label_new(msg);
  gtk_widget_show(error_message);
  gtk_box_pack_start(GTK_BOX(hbox),error_message,0,0,0);

  w = gtk_button_new_with_label("OK");
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(box),w,0,0,0);
  gtk_signal_connect_object(GTK_OBJECT(w),"clicked",
		     kill_error,GTK_OBJECT(error_dialog));
  gtk_window_set_focus(GTK_WINDOW(error_dialog),w);

  dialog_popup(error_dialog,DPErrorPos);
  num_error_dialogs++;
  gdk_window_raise(error_dialog->window);
}

GtkWidget *openfile, *openhost, *openport,
  *openfiletext, *openhosttext, *openporttext, *openidtext, *opennametext;

GtkWidget *openallowdisconnectbutton,*openrandomseatsbutton,
  *openplayercheckboxes[3],*openplayeroptions[3],*opentimeoutspinbutton;;
static GtkWidget *opengamepanel,*openplayeroptionboxes[3],
  *openconnectbutton,*openstartbutton;

/* callback used in next function */
static void openbut_callback(GtkWidget *w, gpointer data) {
  int active = GTK_TOGGLE_BUTTON(w)->active;

  switch ( (int)data ) {
  case 1:
    if ( active ) {
      /* selected network */
      gtk_widget_set_sensitive(openfile,0);
      gtk_widget_set_sensitive(openhost,1);
      gtk_widget_set_sensitive(openport,1);
    }
    break;
  case 2:
    if ( active ) {
      /* selected Unix socket */
      gtk_widget_set_sensitive(openfile,1);
      gtk_widget_set_sensitive(openhost,0);
      gtk_widget_set_sensitive(openport,0);
    }
    break;
  case 10:
  case 11:
  case 12:
    gtk_widget_set_sensitive(openplayeroptionboxes[((int)data)-10],active);
    break;
  }
}

/* the dialog for opening a connection.
   Arguments are initial values for host, port, file, id, name 
   text entry fields, true if use host or false for socket */
void open_dialog_init(char *ht, char *pt, char *ft, char *idt, char *nt, int usehost) {
  /* Layout of the box:
     x  Connect to host
     x  Use Unix socket
     Hostname
     ........
     Port 
     ....
     Filename
     ....
     Player ID
     ....
     Name
     ....
     OPEN CANCEL
  */
  int i;
  GtkWidget *box, *bbox, *but1, *but2, *w1, *w2;
  open_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
  /* This one is allowed to shrink, and should */
  gtk_window_set_policy(GTK_WINDOW(open_dialog),1,1,1);
  gtk_signal_connect (GTK_OBJECT (open_dialog), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_hide), NULL);
  gtk_container_set_border_width(GTK_CONTAINER(open_dialog),
				 dialog_border_width);
  
  box = gtk_vbox_new(0,dialog_vert_spacing);
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(open_dialog),box);
  
  w1 = gtk_hbox_new(0,dialog_button_spacing);
  gtk_widget_show(w1);
  gtk_box_pack_start(GTK_BOX(box),w1,0,0,0);
  but1 = gtk_radio_button_new_with_label(NULL,"Internet server");
  GTK_WIDGET_UNSET_FLAGS(but1,GTK_CAN_FOCUS);
#ifndef WIN32
  gtk_widget_show(but1);
#endif
  gtk_box_pack_start(GTK_BOX(w1),but1,0,0,0);
  but2 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(but1)),"Unix socket server");
  GTK_WIDGET_UNSET_FLAGS(but2,GTK_CAN_FOCUS);
#ifndef WIN32
  gtk_widget_show(but2);
#endif
  gtk_box_pack_end(GTK_BOX(w1),but2,0,0,0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(usehost? but1 : but2),1);

  gtk_signal_connect(GTK_OBJECT(but1),"toggled",openbut_callback,(gpointer)1);
  gtk_signal_connect(GTK_OBJECT(but2),"toggled",openbut_callback,(gpointer)2);

  w2 = gtk_hbox_new(0,dialog_button_spacing);
  gtk_widget_show(w2);
  gtk_box_pack_start(GTK_BOX(box),w2,0,0,0);
  openhost = gtk_hbox_new(0,0);
  gtk_widget_show(openhost);
  gtk_widget_set_sensitive(openhost,usehost);
  gtk_box_pack_start(GTK_BOX(w2),openhost,0,0,0);
  w1 = gtk_label_new("Host: ");
  gtk_widget_show(w1);
  gtk_box_pack_start(GTK_BOX(openhost),w1,0,0,0);
  openhosttext = gtk_entry_new();
  gtk_widget_show(openhosttext);
  gtk_entry_set_text(GTK_ENTRY(openhosttext),ht);
  gtk_box_pack_start(GTK_BOX(openhost),openhosttext,0,0,0);

  openport = gtk_hbox_new(0,0);
  gtk_widget_show(openport);
  gtk_widget_set_sensitive(openport,usehost);
  gtk_box_pack_end(GTK_BOX(w2),openport,0,0,0);
  w1 = gtk_label_new("Port: ");
  gtk_widget_show(w1);
  gtk_box_pack_start(GTK_BOX(openport),w1,0,0,0);
  openporttext = gtk_entry_new_with_max_length(5);
  gtk_widget_set_usize(openporttext,75,0);
  gtk_widget_show(openporttext);
  gtk_entry_set_text(GTK_ENTRY(openporttext),pt);
  gtk_box_pack_start(GTK_BOX(openport),openporttext,0,0,0);

  openfile = gtk_hbox_new(0,0);
#ifndef WIN32
  gtk_widget_show(openfile);
#endif
  gtk_widget_set_sensitive(openfile,!usehost);
  gtk_box_pack_start(GTK_BOX(box),openfile,0,0,0);
  w1 = gtk_label_new("File: ");
  gtk_widget_show(w1);
  gtk_box_pack_start(GTK_BOX(openfile),w1,0,0,0);
  openfiletext = gtk_entry_new();
  gtk_widget_show(openfiletext);
  gtk_entry_set_text(GTK_ENTRY(openfiletext),ft);
  gtk_box_pack_start(GTK_BOX(openfile),openfiletext,0,0,0);

  w2 = gtk_hbox_new(0,0);
  gtk_widget_show(w2);
  gtk_box_pack_start(GTK_BOX(box),w2,0,0,0);
  w1 = gtk_label_new("Player ID: ");
  gtk_widget_show(w1);
  gtk_box_pack_start(GTK_BOX(w2),w1,0,0,0);
  openidtext = gtk_entry_new();
  gtk_widget_show(openidtext);
  gtk_entry_set_text(GTK_ENTRY(openidtext),idt);
  gtk_box_pack_start(GTK_BOX(w2),openidtext,0,0,0);

  w2 = gtk_hbox_new(0,0);
  gtk_widget_show(w2);
  gtk_box_pack_start(GTK_BOX(box),w2,0,0,0);
  w1 = gtk_label_new("Name: ");
  gtk_widget_show(w1);
  gtk_box_pack_start(GTK_BOX(w2),w1,0,0,0);
  opennametext = gtk_entry_new();
  gtk_widget_show(opennametext);
  if ( ! nt ) nt = getenv("LOGNAME");
  if ( ! nt ) nt = getlogin(); /* may need to be in sysdep.c */
  gtk_entry_set_text(GTK_ENTRY(opennametext),nt);
  gtk_box_pack_start(GTK_BOX(w2),opennametext,0,0,0);

  /* Now some stuff for when this panel is in its personality as
     a start game panel */
  opengamepanel = bbox = gtk_vbox_new(0,dialog_vert_spacing);
  /* gtk_widget_show(bbox); */
  gtk_box_pack_start(GTK_BOX(box),bbox,0,0,0);

  for ( i = 0 ; i < 3 ; i++ ) {
    static const char *playerlabs[] = { "Second player:" , "Third player:",
					"Fourth player:" };

    w2 = gtk_hbox_new(0,dialog_button_spacing);
    gtk_widget_show(w2);
    gtk_box_pack_start(GTK_BOX(bbox),w2,0,0,0);
    w1 = gtk_label_new(playerlabs[i]);
    gtk_widget_show(w1);
    gtk_box_pack_start(GTK_BOX(w2),w1,0,0,0);
    openplayercheckboxes[i] = w1 = 
      gtk_check_button_new_with_label("Start computer player   ");
    gtk_widget_show(w1);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w1),1);
    gtk_box_pack_end(GTK_BOX(w2),w1,0,0,0);
    gtk_signal_connect(GTK_OBJECT(w1),"toggled",openbut_callback,(gpointer)(10+i));
    openplayeroptionboxes[i] = w2 = gtk_hbox_new(0,dialog_button_spacing);
    gtk_widget_show(w2);
    gtk_box_pack_start(GTK_BOX(bbox),w2,0,0,0);
    w1 = gtk_label_new("  Options:");
    gtk_widget_show(w1);
    gtk_box_pack_start(GTK_BOX(w2),w1,0,0,0);
    openplayeroptions[i] = w1 = gtk_entry_new();
    gtk_widget_show(w1);
    gtk_box_pack_start(GTK_BOX(w2),w1,0,0,0);
  }

  openallowdisconnectbutton = w1 =
    gtk_check_button_new_with_label("Allow disconnection from game");
  gtk_widget_show(w1);
  gtk_box_pack_start(GTK_BOX(bbox),w1,0,0,0);

  openrandomseatsbutton = w1 =
    gtk_check_button_new_with_label("Seat players randomly");
  gtk_widget_show(w1);
  gtk_box_pack_start(GTK_BOX(bbox),w1,0,0,0);

  opentimeoutspinbutton = w1 = 
    gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(15.0,0.0,300.0,1.0,10.0,0.0)),
			0.0,0);
  gtk_widget_show(w1);
  w2 = gtk_hbox_new(0,dialog_button_spacing);
  gtk_widget_show(w2);
  gtk_box_pack_start(GTK_BOX(w2),w1,0,0,0);
  w1 = gtk_label_new("seconds allowed for claims");
  gtk_widget_show(w1);
  gtk_box_pack_start(GTK_BOX(w2),w1,0,0,0);
  gtk_box_pack_start(GTK_BOX(bbox),w2,0,0,0);

  w1 = gtk_hbox_new(0,dialog_button_spacing);
  gtk_widget_show(w1);
  gtk_box_pack_start(GTK_BOX(box),w1,0,0,0);
  openconnectbutton = w2 = gtk_button_new_with_label("Connect");
  gtk_widget_show(w2);
  gtk_box_pack_start(GTK_BOX(w1),w2,0,0,0);
  gtk_signal_connect(GTK_OBJECT(w2),"clicked",open_connection,0);
  openstartbutton = w2 = gtk_button_new_with_label("Start Game");
  /* gtk_widget_show(w2); */
  gtk_box_pack_start(GTK_BOX(w1),w2,0,0,0);
  gtk_signal_connect(GTK_OBJECT(w2),"clicked",open_connection,(gpointer)1);
  w2 = gtk_button_new_with_label("Cancel");
  gtk_widget_show(w2);
  gtk_box_pack_end(GTK_BOX(w1),w2,0,0,0);
  gtk_signal_connect_object(GTK_OBJECT(w2),"clicked",
			    gtk_widget_hide,GTK_OBJECT(open_dialog));


}

void open_dialog_popup(GtkWidget *w UNUSED, gpointer data) {
  /* set the default id to be our current id */
  char buf[256];
  sprintf(buf,"%d",our_id);
  gtk_entry_set_text(GTK_ENTRY(openidtext),buf);
  if ( data ) { 
    gtk_widget_show(opengamepanel);
    gtk_widget_show(openstartbutton);
    gtk_widget_hide(openconnectbutton);
  } else {
    gtk_widget_hide(opengamepanel);
    gtk_widget_hide(openstartbutton);
    gtk_widget_show(openconnectbutton);
  }
  dialog_popup(open_dialog,DPCentredOnce);
}
   

/* the turn dialog: buttons for Discard (also declares specs),
   Kong (concealed, of course), Add to Pung, Mah Jong */
void turn_dialog_init(void) {
  GtkWidget *box, *butbox, *w;

  switch ( dialogs_position ) {
  case DialogsCentral:
  case DialogsUnspecified:
    turn_dialog = gtk_event_box_new();
    gtk_fixed_put(GTK_FIXED(discard_area),turn_dialog,0,0);
    break;
  case DialogsBelow:
    turn_dialog = gtk_event_box_new();
    gtk_box_pack_start(GTK_BOX(dialoglowerbox),turn_dialog,1,0,0);
    break;
  case DialogsPopup:
    turn_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_signal_connect (GTK_OBJECT (turn_dialog), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_hide), NULL);
  }

  box = gtk_vbox_new(0,dialog_vert_spacing);
  gtk_container_set_border_width(GTK_CONTAINER(box),
				 dialog_border_width);
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(turn_dialog),box);

  butbox = gtk_hbox_new(1,dialog_button_spacing);
  gtk_widget_show(butbox);
  gtk_box_pack_end(GTK_BOX(box),butbox,0,0,0);
    
  w = gtk_label_new("Select tile and:");
  gtk_widget_show(w);
  gtk_box_pack_end(GTK_BOX(box),w,0,0,0);

  w = gtk_button_new_with_label("Discard");
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(butbox),w,1,1,0);
  /* so other function can set it */
  turn_dialog_discard_button = w;
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgDiscard);
    
  w = gtk_button_new_with_label("& Calling");
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(butbox),w,1,1,0);
  /* so other function can set it */
  turn_dialog_calling_button = w;
  /* this assumes knowledge that protocol enums don't go above
     1000000 */
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)(PMsgDiscard+1000000));
    
  w = gtk_button_new_with_label("Kong");
  GTK_WIDGET_UNSET_FLAGS(w,GTK_CAN_FOCUS);
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(butbox),w,1,1,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgDeclareClosedKong);
    
  w = gtk_button_new_with_label("Add to Pung");
  GTK_WIDGET_UNSET_FLAGS(w,GTK_CAN_FOCUS);
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(butbox),w,1,1,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgAddToPung);
    
  w = gtk_button_new_with_label("Mah Jong!");
  GTK_WIDGET_UNSET_FLAGS(w,GTK_CAN_FOCUS);
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(butbox),w,1,1,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgMahJong);
}
      
/* dialog for scoring phase: forming closed sets */
static GtkWidget *scoring_done, *scoring_special;

void scoring_dialog_init(void) {
  GtkWidget *box, *butbox, *w;
  
  switch ( dialogs_position ) {
  case DialogsCentral:
  case DialogsUnspecified:
    scoring_dialog = gtk_event_box_new();
    gtk_fixed_put(GTK_FIXED(discard_area),scoring_dialog,0,0);
    break;
  case DialogsBelow:
    scoring_dialog = gtk_event_box_new();
    gtk_box_pack_start(GTK_BOX(dialoglowerbox),scoring_dialog,1,0,0);
    break;
  case DialogsPopup:
    scoring_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_signal_connect (GTK_OBJECT (scoring_dialog), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_hide), NULL);
  }
  
  box = gtk_vbox_new(0,dialog_vert_spacing);
  gtk_container_set_border_width(GTK_CONTAINER(box),
				 dialog_border_width);
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(scoring_dialog),box);

  butbox = gtk_hbox_new(1,dialog_button_spacing);
  gtk_widget_show(butbox);
  gtk_box_pack_end(GTK_BOX(box),butbox,0,0,0);
  
  w = gtk_label_new("Declare concealed sets\nSelect 1st tile and:");
  gtk_widget_show(w);
  gtk_box_pack_end(GTK_BOX(box),w,0,0,0);

  w = gtk_button_new_with_label("Eyes");
  GTK_WIDGET_UNSET_FLAGS(w,GTK_CAN_FOCUS);
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(butbox),w,1,1,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgFormClosedPair);
  
  w = gtk_button_new_with_label("Chow");
  GTK_WIDGET_UNSET_FLAGS(w,GTK_CAN_FOCUS);
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(butbox),w,1,1,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgFormClosedChow);
  
  w = gtk_button_new_with_label("Pung");
  GTK_WIDGET_UNSET_FLAGS(w,GTK_CAN_FOCUS);
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(butbox),w,1,1,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgFormClosedPung);
  
  scoring_special = w = gtk_button_new_with_label("Special Hand");
  GTK_WIDGET_UNSET_FLAGS(w,GTK_CAN_FOCUS);
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(butbox),w,1,1,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgFormClosedSpecialSet);
  
  scoring_done = w = gtk_button_new_with_label("Done");
  GTK_WIDGET_UNSET_FLAGS(w,GTK_CAN_FOCUS);
  /* gtk_widget_show(w); */ /* uses same space as special hand */
  gtk_box_pack_start(GTK_BOX(butbox),w,1,1,0);
  gtk_signal_connect(GTK_OBJECT(w),"clicked",
		     turn_callback,(gpointer)PMsgShowTiles);
}

void scoring_dialog_popup(void) {
  if ( the_game->info.player == our_seat ) {
    gtk_widget_show(scoring_special);
    gtk_widget_hide(scoring_done);
  } else {
    gtk_widget_hide(scoring_special);
    gtk_widget_show(scoring_done);
  }
  dialog_popup(scoring_dialog,DPCentredOnce);
}



/* close a widget, saving its position for next open */
static void close_saving_posn(GtkWidget *w) {
  gint x,y;
  gdk_window_get_deskrelative_origin(w->window,&x,&y);
  gtk_widget_set_uposition(w,x,y);
  gtk_widget_hide(w);
}

/* the textwindow for scoring information etc */
void textwindow_init(void) {
  int i;
  GtkWidget *sbar, *obox, *box, *tmp, *lbl,*textw;

  textwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT (textwindow), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_hide), NULL);
  /* must allow shrinking */
  gtk_window_set_policy(GTK_WINDOW(textwindow),TRUE,TRUE,FALSE);
  gtk_window_set_title(GTK_WINDOW(textwindow),"Scoring calculations");
  /* reasonable size is depends on what fonts come up by... this seems to work */
#ifdef WIN32
  gtk_window_set_default_size(GTK_WINDOW(textwindow),500,400);
#else
  gtk_window_set_default_size(GTK_WINDOW(textwindow),400,300);
#endif
  obox = gtk_vbox_new(0,dialog_vert_spacing);
  gtk_container_set_border_width(GTK_CONTAINER(obox),dialog_border_width);
  gtk_widget_show(obox);
  gtk_container_add(GTK_CONTAINER(textwindow),obox);

  scoring_notebook = gtk_notebook_new();
  GTK_WIDGET_UNSET_FLAGS(scoring_notebook,GTK_CAN_FOCUS);
  gtk_widget_show(scoring_notebook);
  gtk_box_pack_start(GTK_BOX(obox),scoring_notebook,1,1,0);
  
  for (i=0;i<5;i++) {
    GtkStyle *s;
    textw = gtk_text_new(NULL,NULL);
    gtk_widget_show(textw);
    textpages[i] = textw;
    sbar = gtk_vscrollbar_new(GTK_TEXT (textw)->vadj);
    gtk_widget_show(sbar);
    box = gtk_hbox_new(0,0);
    gtk_widget_show(box);
    gtk_box_pack_start(GTK_BOX(box),sbar,0,0,0);
    gtk_box_pack_start(GTK_BOX(box),textw,1,1,0);
    lbl = gtk_label_new((i==4) ? "Settlement" : "");
    gtk_widget_show(lbl);
    textlabels[i] = lbl;
    gtk_notebook_append_page(GTK_NOTEBOOK(scoring_notebook),box,lbl);
    gtk_widget_realize(textw);
    if ( fixed_font ) {
      s = gtk_style_copy(gtk_widget_get_style(textw));
      s->font = fixed_font;
      gtk_widget_set_style(textw,s);
    }
  }

  tmp = gtk_button_new_with_label("Close");
  gtk_signal_connect_object(GTK_OBJECT(tmp),"clicked",
		     close_saving_posn,GTK_OBJECT(textwindow));
  gtk_widget_show(tmp);
  gtk_box_pack_end(GTK_BOX(obox),tmp,0,0,0);
}

/* the callback when user hits return in the message composition window */
static void mentry_callback(GtkWidget *widget UNUSED,GtkWidget *mentry) {
  gchar *mentry_text;
  PMsgSendMessageMsg smm;
  mentry_text = gtk_entry_get_text(GTK_ENTRY(mentry));
  smm.type = PMsgSendMessage;
  smm.addressee = 0; /* broadcast only at present ... */
  smm.text = mentry_text;
  send_packet(&smm);
  gtk_entry_set_text(GTK_ENTRY(mentry),"");
}

/* the window for messages */
void messagewindow_init(void) {
  GtkWidget *sbar, *obox, *box, *tmp, *mentry, *label;
  GtkStyle *s;

  messagewindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT (messagewindow), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_hide), NULL);
  /* must allow shrinking */
  gtk_window_set_policy(GTK_WINDOW(messagewindow),TRUE,TRUE,FALSE);
  gtk_window_set_title(GTK_WINDOW(messagewindow),"Messages");
  /* reasonable size is ... */
  gtk_window_set_default_size(GTK_WINDOW(messagewindow),400,300);

  obox = gtk_vbox_new(0,dialog_vert_spacing);
  gtk_container_set_border_width(GTK_CONTAINER(obox),dialog_border_width);
  gtk_widget_show(obox);
  gtk_container_add(GTK_CONTAINER(messagewindow),obox);

  messagetext = gtk_text_new(NULL,NULL);
  gtk_widget_show(messagetext);
  sbar = gtk_vscrollbar_new(GTK_TEXT (messagetext)->vadj);
  gtk_widget_show(sbar);
  box = gtk_hbox_new(0,0);
  gtk_widget_show(box);
  gtk_box_pack_start(GTK_BOX(box),sbar,0,0,0);
  gtk_box_pack_start(GTK_BOX(box),messagetext,1,1,0);
  gtk_box_pack_start(GTK_BOX(obox),box,1,1,0);
  gtk_widget_realize(messagetext);
  if ( fixed_font ) {
    s = gtk_style_copy(gtk_widget_get_style(messagetext));
    s->font = fixed_font;
    gtk_widget_set_style(messagetext,s);
  }

  GTK_WIDGET_UNSET_FLAGS(messagetext,GTK_CAN_FOCUS); /* entry widget shd focus */

  label = gtk_label_new("Send message:");
  gtk_misc_set_alignment(GTK_MISC(label),0.0,0.5);
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX(obox),label,0,0,0);
  GTK_WIDGET_UNSET_FLAGS(label,GTK_CAN_FOCUS);

  /* the thing for sending messages */
  mentry = gtk_entry_new();
  gtk_signal_connect(GTK_OBJECT(mentry),"activate",
		     GTK_SIGNAL_FUNC(mentry_callback),mentry);
  gtk_box_pack_start(GTK_BOX(obox),mentry,0,0,0);
  gtk_widget_show(mentry);

  tmp = gtk_button_new_with_label("Close");
  GTK_WIDGET_UNSET_FLAGS(tmp,GTK_CAN_FOCUS); /* entry widget shd focus */
  gtk_signal_connect_object(GTK_OBJECT(tmp),"clicked",
			    close_saving_posn,GTK_OBJECT(messagewindow));
  gtk_widget_show(tmp);
  gtk_box_pack_end(GTK_BOX(obox),tmp,0,0,0);
  gtk_widget_grab_focus(mentry);
}


/* do_chow: if there's only one possible chow, do it, otherwise
   put up a dialog box to choose. Sneakily, this is defined as
   a callback, so that the choosing buttons can call this specifying
   the chow pos, and the main program can call it with AnyPos.
*/

void do_chow(GtkWidget *widg UNUSED, gpointer data) {
  ChowPosition cpos = (ChowPosition)data;
  PMsgChowMsg cm;
  int i,n,j;
  static int lastdiscard;
  TileSet ts;

  cm.type = PMsgChow;
  cm.discard = the_game->info.serial;

  if ( cpos == AnyPos ) {
    /* we want to avoid working and popping up again if
       for some reason we're already popped up. (So that
       this procedure is idempotent.) */
    if ( GTK_WIDGET_VISIBLE(chowdialog) && cm.discard == lastdiscard )
      return;
    lastdiscard = cm.discard;
    ts.type = Chow;
    /* set up the boxes */
    for (n=0,i=0,j=0;i<3;i++) {
      if ( player_can_chow(our_player,the_game->info.tile,i) ) {
	ts.tile = the_game->info.tile - i;
	tilesetbox_set(&chowtsbs[i],&ts,0);
	tilesetbox_highlight_nth(&chowtsbs[i],i);
	gtk_widget_show(chowbuttons[i]);
	n++; j = i;
      } else {
	gtk_widget_hide(chowtsbs[i].widget);
	gtk_widget_hide(chowbuttons[i]);
      }
    }
    /* if there is only one possibility, don't bother to ask.
       Also if there is no possibility: we'll then get an error
       from the server, which saves us having to worry about it */
    if ( n <= 1 ) {
      cpos = j;
    } else {
      /* pop down the discard dialog */
      gtk_widget_hide(discard_dialog->widget);
      dialog_popup(chowdialog,DPCentred);
    }
  }

  /* Now we might have found the position */
  if ( cpos != AnyPos ) {
    cm.cpos = cpos;
    send_packet(&cm);
  }
}

/* Generic popup centered over main window.
   Positioning is given by
   DPCentred - centered over main window 
   DPOnDiscard - bottom left corner in same place as discard dialog
   DPErrorPos - for error dialogs: centred over top of main window,
    and offset by a multiple of num_error_dialogs
   DPNone - don't touch the positioning at all '
   DPCentredOnce - centre it on first popup, then don't fiddle '
   DPOnDiscardOnce - on discard dialog first time, then don't fiddle '
   If the widget is not a window, then DPCentredOnce and DPNone
   are equivalent to DPCentred, and DPOnDiscardOnce is equivalent to
   DPOnDiscard.
*/
void dialog_popup(GtkWidget *dialog,DPPosn posn) {
  gint x,y,w,h;
  GtkRequisition r = { 0, 0};

  /* So that we don't work if it's already popped up: */
  if ( GTK_WIDGET_VISIBLE(dialog) ) return;

  if ( ! GTK_IS_WINDOW(dialog) ) {
    if ( posn == DPCentredOnce ) posn = DPCentred;
    if ( posn == DPOnDiscardOnce ) posn = DPOnDiscard;
    if ( posn == DPNone ) posn = DPCentred;
  }

  /* get size of discard widget if necessary */
  if ( (posn == DPOnDiscard || posn == DPOnDiscardOnce) 
       && discard_req.width == 0 ) {
    gtk_widget_size_request(discard_dialog->widget,&discard_req);
    gtk_widget_set_usize(discard_dialog->widget,
			 discard_req.width,
			 discard_req.height);
  }

  gtk_widget_size_request(dialog,&r);

  if ( GTK_IS_WINDOW(dialog) ) {
    gdk_window_get_size(topwindow->window,&w,&h);
    gdk_window_get_deskrelative_origin(topwindow->window,&x,&y);
  } else {
    w = discard_area_alloc.width;
    h = discard_area_alloc.height;
    x = y = 0;
  }

  if ( posn == DPOnDiscard ) {
    gtk_widget_set_uposition(dialog,
			     x + w/2 - r.width/2
			     - (discard_req.width - r.width)/2,
			     y + h/2 - r.height/2
			     + (discard_req.height - r.height)/2);
  } else if ( posn == DPOnDiscardOnce ) {
    if ( gtk_object_get_data(GTK_OBJECT(dialog),"position-set") ) {
      gtk_widget_set_uposition(dialog,-1,-1);
    } else {
      gtk_widget_set_uposition(dialog,
			     x + w/2 - r.width/2
			     - (discard_req.width - r.width)/2,
			     y + h/2 - r.height/2
			     + (discard_req.height - r.height)/2);
      gtk_object_set_data(GTK_OBJECT(dialog),"position-set",(gpointer)1);
    }
  } else if ( posn == DPCentred ) {
    gtk_widget_set_uposition(dialog,
			     x + w/2 - r.width/2,
			     y + h/2 - r.height/2);
  } else if ( posn == DPCentredOnce ) {
    if ( gtk_object_get_data(GTK_OBJECT(dialog),"position-set") ) {
      gtk_widget_set_uposition(dialog,-1,-1);
    } else {
      gtk_widget_set_uposition(dialog,
			       x + w/2 - r.width/2,
			       y + h/2 - r.height/2);
      gtk_object_set_data(GTK_OBJECT(dialog),"position-set",(gpointer)1);
    }
  } else if ( posn == DPErrorPos ) {
    gtk_widget_set_uposition(dialog,
			     x + w/2 - r.width/2,
			     y + h/4 - r.height/2 + 10*num_error_dialogs);
  }
  gtk_widget_show(dialog);
}

/* window to display game status. 
     0      1    2...  3....    
   We are WIND; id: n  Name: name
     total score: nnn
   and for right, opposite, left
*/
static char *status_poses[] = { "We are ", "Right is ", "Opp. is ", "Left is " };
static GtkWidget *status_poslabels[4];
static GtkWidget *status_windlabels[4];
static GtkWidget *status_idlabels[4];
static GtkWidget *status_namelabels[4];
static GtkWidget *status_scorelabels[4];
static GtkWidget *status_pwind;
static GtkWidget *status_status;
static GtkWidget *status_tilesleft;

void status_init(void) {
  int i;
  GtkWidget *table, *w;

  status_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT (status_window), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_hide), NULL);
  gtk_window_set_title(GTK_WINDOW(status_window),"Game information");
  gtk_container_set_border_width(GTK_CONTAINER(status_window),
				 dialog_border_width);

  table = gtk_table_new(12,4,0);
  gtk_widget_show(table);
  gtk_container_add(GTK_CONTAINER(status_window),table);
  for ( i = 0 ; i < 4 ; i++ ) {
    status_poslabels[i] = w = gtk_label_new(status_poses[i]);
    gtk_widget_show(w);
    gtk_label_set_justify(GTK_LABEL(w),GTK_JUSTIFY_LEFT);
    gtk_table_attach_defaults(GTK_TABLE(table),w,
		     0,1,2*i,2*i+1);
    status_windlabels[i] = w = gtk_label_new("none");
    gtk_widget_show(w);
    gtk_label_set_justify(GTK_LABEL(w),GTK_JUSTIFY_LEFT);
    gtk_table_attach_defaults(GTK_TABLE(table),w,
		     1,2,2*i,2*i+1);
    status_idlabels[i] = w = gtk_label_new("  ID: 0");
    gtk_widget_show(w);
    gtk_label_set_justify(GTK_LABEL(w),GTK_JUSTIFY_LEFT);
    gtk_table_attach_defaults(GTK_TABLE(table),w,
		     2,3,2*i,2*i+1);
    status_namelabels[i] = w = gtk_label_new("  Name: unknown");
    gtk_widget_show(w);
    gtk_label_set_justify(GTK_LABEL(w),GTK_JUSTIFY_LEFT);
    gtk_table_attach_defaults(GTK_TABLE(table),w,
		     3,4,2*i,2*i+1);
    status_scorelabels[i] = w = gtk_label_new("total score:     0");
    gtk_widget_show(w);
    gtk_label_set_justify(GTK_LABEL(w),GTK_JUSTIFY_LEFT);
    gtk_table_attach_defaults(GTK_TABLE(table),w,
		     1,4,2*i+1,2*i+2);

  }
  status_pwind = w = gtk_label_new("Prevailing wind: none");
  gtk_widget_show(w);
  gtk_table_attach_defaults(GTK_TABLE(table),w,
			    0,4,8,9);

  status_status = w = gtk_label_new("no game");
  gtk_widget_show(w);
  gtk_table_attach_defaults(GTK_TABLE(table),w,
			    0,4,9,10);

  status_tilesleft = w = gtk_label_new("");
  gtk_widget_show(w);
  gtk_table_attach_defaults(GTK_TABLE(table),w,
			    0,4,10,11);

  w = gtk_button_new_with_label("Close");
  gtk_widget_show(w);
  gtk_table_attach_defaults(GTK_TABLE(table),w,
			    0,4,11,12);
  gtk_signal_connect_object(GTK_OBJECT(w),"clicked",
			    close_saving_posn,GTK_OBJECT(status_window));
}

void status_update(int game_over) {
  int i,s;
  char *pn;
  PlayerP p;
  static char buf[256];
  static char *windnames[] = { "none", "East", "South", "West", "North" };

  if ( ! the_game ) return;
  if ( (!game_over) && ! GTK_WIDGET_VISIBLE(status_window) ) return;

  for ( i=0 ; i < 4 ; i++ ) {
    s = (our_seat+i)%NUM_SEATS;
    p = the_game->players[s];
    gtk_label_set_text(GTK_LABEL(status_windlabels[i]),
		       windnames[p->wind]);
    sprintf(buf,"  ID: %d",p->id);
    gtk_label_set_text(GTK_LABEL(status_idlabels[i]),buf);
    sprintf(buf,"  Name: %s",p->name);
    gtk_label_set_text(GTK_LABEL(status_namelabels[i]),buf);
    sprintf(buf,"total score: %5d",p->cumulative_score);
    gtk_label_set_text(GTK_LABEL(status_scorelabels[i]),buf);
  }
  sprintf(buf,"Prevailing wind: %s",windnames[the_game->round]);
  gtk_label_set_text(GTK_LABEL(status_pwind),buf);
  pn = windnames[the_game->info.player+1]; /* +1 for seat to wind */
  switch (the_game->state) {
  case Dealing:
    sprintf(buf,"Dealing");
    break;
  case DeclaringSpecials:
    sprintf(buf,"%s declaring specials",pn);
    break;
  case Discarding:
    sprintf(buf,"%s to discard",pn);
    break;
  case Discarded:
    sprintf(buf,"%s has discarded",pn);
    break;
  case MahJonging:
    sprintf(buf,"%s has Mah Jong",pn);
    break;
  case HandComplete:
    sprintf(buf,"Hand finished");
    break;
  }
  if ( !the_game->active ) strcat(buf," (Play suspended)");
  if ( game_over ) strcpy(buf,"GAME OVER");
  gtk_label_set_text(GTK_LABEL(status_status),buf);
  sprintf(buf,"%3d tiles left + %2d dead tiles",
	  the_game->wall.live_end-the_game->wall.live_used,
	  the_game->wall.dead_end-the_game->wall.live_end);
  gtk_label_set_text(GTK_LABEL(status_tilesleft),buf);
}

void showraise(GtkWidget *w) {
  gtk_widget_show(w);
  gdk_window_raise(w->window);
  gdk_window_show(w->window);
}

static void about_init(void) {
  GtkWidget *closebutton, *textw, *vbox;
  static char *abouttxt = "\
This is  xmj , part of the Mah-Jong for Unix (etc)\n\
set of programs.\n\
Copyright (c) J. C. Bradfield 2000-2001.\n\
Distributed under the Gnu General Public License.\n
This is version " VERSION " (protocol version " STRINGIFY(PROTOCOL_VERSION) ").\n\
User documentation is in the  xmj  manual page.\n\
Latest versions, information etc. may be found at\n\
 http://www.stevens-bradfield.com/MahJong/   and\n\
 http://www.dcs.ed.ac.uk/home/jcb/MahJong/   .\n\
Comments and suggestions should be mailed to\n\
 mahjong@stevens-bradfield.com" ;
  
  about_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT (about_window), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_hide), NULL);
  gtk_window_set_title(GTK_WINDOW(about_window),"About xmj");
  gtk_container_set_border_width(GTK_CONTAINER(about_window),
				 dialog_border_width);

  vbox = gtk_vbox_new(0,dialog_vert_spacing);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(about_window),vbox);

  textw = gtk_text_new(NULL,NULL);
  gtk_widget_set_usize(textw,300,200);
  gtk_text_insert(GTK_TEXT(textw),NULL,NULL,NULL,abouttxt,-1);
  gtk_widget_show(textw);
  GTK_WIDGET_UNSET_FLAGS(textw,GTK_CAN_FOCUS);
  gtk_box_pack_start(GTK_BOX(vbox),textw,0,0,0);
  
  closebutton = gtk_button_new_with_label("Close");
  gtk_widget_show(closebutton);
  gtk_signal_connect_object(GTK_OBJECT(closebutton),"clicked",
			    close_saving_posn,GTK_OBJECT(about_window));
  gtk_box_pack_start(GTK_BOX(vbox),closebutton,0,0,0);

}

static void scoring_showraise(void) { showraise(textwindow); }
static void message_showraise(void) { showraise(messagewindow); }
static void about_showraise(void) { 
  if ( ! about_window ) about_init();
  showraise(about_window); 
}
void status_showraise(void) { showraise(status_window); status_update(0) ; }

/* the menu items */
static GtkItemFactoryEntry menu_items[] = {
  { "/Connect", NULL, NULL, 0, "<Branch>" },
  { "/Connect/New game...", NULL, open_dialog_popup, 1, NULL },
  { "/Connect/Connect to server...", NULL, open_dialog_popup, 0, NULL },
  { "/Connect/Close", NULL, close_connection, 0, NULL },
  { "/Connect/Quit", NULL, exit, 0, NULL },
  { "/Show", NULL, NULL, 0, "<Branch>" },
  { "/Show/Scoring info", NULL, scoring_showraise, 0, NULL },
  { "/Show/Game info", NULL, status_showraise, 0, NULL },
  { "/Show/Messages", NULL, message_showraise, 0, NULL },
  { "/About", NULL, NULL, 0, "<LastBranch>" },
  { "/About/About xmj", NULL, about_showraise, 0, NULL },
};
static int nmenu_items = 11;

/* create the menubar, and return it */
GtkWidget *menubar_create(void) {
  GtkItemFactory *item_factory;
  GtkWidget *m;
  item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR,
				      "<main>",NULL);
  gtk_item_factory_create_items(item_factory,nmenu_items,
				menu_items,NULL);
  m = gtk_item_factory_get_widget(item_factory,"<main>");
  gtk_widget_show(m);
  openmenuentry = gtk_item_factory_get_widget(item_factory,
					      "/Connect/Connect to server...");
  assert(openmenuentry);
  newgamemenuentry = gtk_item_factory_get_widget(item_factory,
					      "/Connect/New game...");
  assert(newgamemenuentry);
  closemenuentry = gtk_item_factory_get_widget(item_factory,"/Connect/Close");
  assert(closemenuentry);
  gtk_widget_set_sensitive(closemenuentry,0);
  return m;
}
