/* $Header: /home/jcb/newmj/RCS/gui.h,v 10.7 2001/01/22 20:45:45 jcb Rel $
 * gui.h
 * type defns and forward declarations for the gui module.
 */
/****************** COPYRIGHT STATEMENT **********************
 * This file is Copyright (c) 2000 by J. C. Bradfield.       *
 * Distribution and use is governed by the LICENCE file that *
 * accompanies this file.                                    *
 * The moral rights of the author are asserted.              *
 *                                                           *
 ***************** DISCLAIMER OF WARRANTY ********************
 * This code is not warranted fit for any purpose. See the   *
 * LICENCE file for further information.                     *
 *                                                           *
 *************************************************************/

#include <gtk/gtk.h>
#include "sysdep.h"
#include <errno.h>
#include "client.h"
#include <math.h>

/*********************
  TYPE DEFINITIONS
*********************/

/* a tilesetbox is a TileSet and a widget that boxes it.
   The TileSet is stored to avoid unnecessary updating of the box
*/
typedef struct _TileSetBox {
  TileSet set;
  GtkWidget *widget; /* the widget itself */
  GtkWidget *tiles[4]; /* the children buttons */
} TileSetBox;

/* This struct represents the display of a player. It gives
   access to relevant widgets without requiring excessive casting
   and pointer chasing.
*/
typedef struct _PlayerDisp {
  PlayerP player; /* pointer to the game player structure */
  /* this is the whole box representing the player */
  GtkWidget *widget;
  /* the orientation says which way round tiles go
     (equivalently, which player we are in the table).
     The tilepixmaps are those appropriate assuming that players
     look at their own tiles. If the players politely display
     their sets to be readable by the others, then the orientation
     of exposed tiles is flipped from these.
     that the orientations are:
     0:  upright (for our own tiles)
     1:  top to left: player to the right (south, when we're east)
     2:  upside down (player opposite)
     3:  top to right (north).
  */
  int orientation;
  /* and accordingly the following macro can be used if concealed
     and exposed tiles are oriented differently */
  /* # define flipori(ori) ((ori+2)%4) */
#define flipori(ori) ori
  /* this is an array of buttons representing the concealed tiles.
     For initial size calculation, it should be filled with blanks.
     (Ideally, unmapped, but I can't see how to do that.)
     They appear from the left in the "concealed" row.
  */
  GtkWidget *conc[MAX_CONCEALED];
  /* This is an array representing the declared specials
     that have overflowed into the concealed row.
     Initially, exactly five of these should be shown: that makes
     the whole "concealed" row 19 tiles wide, which gives enough
     room for reasonable collections of specials, and makes the "exposed"
     row big enough for four kongs and a pair.
     They appear to the right of the concealed row.
  */
  GtkWidget *extras[8];
  /* These are the specials that have found room where we want
     them, at the end of the exposed row */
  GtkWidget *spec[8];
  /* each of these is a box representing a declared set.
     Each set is packed into the exposed row, from the left,
     with a 1/4 tile spacing between them (thus fitting
     4 kongs and a pair in exactly).
     Size is determined by the concealed row, so there is
     no need to show these initially.
  */
  /* This is the tong box. It appears to the right of the exposed row specials*/
  GtkWidget *tongbox;
  TileSetBox esets[MAX_TILESETS];
  /* each of these is a box representing a concealed set.
     They appear to the left of the concealed tile set, with
     the 1/4 tile spacing. They are initially hidden, and
     appear only in scoring.
  */
  TileSetBox csets[MAX_TILESETS];
  
  /* these is not actually in the player area, but to do with 
     discards */
  GtkWidget *discards[32]; /* buttons for this player's discards */
  int dx[32], dy[32]; /* save calculated posns of discard tiles */
  int num_discards;
  gint16 x,y; /* x and y for next discard */
  int row; /* which row is next discard in */
  gint16 xmin[5],xmax[5]; /* in each row, first point used, leftmost point free*/
  int plane; /* if desperate, we start stacking tiles */

  /* This is the window for pung! claims etc. */
  GtkWidget *claimw;
  GtkWidget *claimlab; /* and the label inside it */
  int claim_serial; /* the discard for which this window was popped up */
  int claim_time; /* time popped up (in millisecs since start of program) */
} PlayerDisp;

/* This is a one use structure representing the dialog box
   used for claiming discards. It has two personalities:
   normally it shows buttons
   Noclaim  Chow  Pung  Kong  MahJong
   but after a mahjong claim it shows
   Eyes  Chow  Pung  Special Hand
*/
typedef struct {
  GtkWidget *widget; /* the box itself */
  GtkWidget *tilename; /* the label for the tile name */
  GtkWidget *tiles[4]; /* the buttons for the tiles as discarded
			  by each player. Element 0 is unused. */
  /* the various buttons */
  GtkWidget *noclaim;
  GtkWidget *eyes;
  GtkWidget *chow;
  GtkWidget *pung;
  GtkWidget *special;
  GtkWidget *kong;
  GtkWidget *mahjong;
  GtkWidget *robkong;
  int mode; /* 0 normally, 1 in mahjong mode, 2 for robbing kongs */
} DiscardDialog;

/* this is used by functions that display or remove tiles to pass
   back information to the animation routines. The structure contains
   information about the tiles.
*/
typedef struct {
  GtkWidget *target;  /* the widget to which this information refers,
		    if it is being newly displayed. In this case,
		    the widget is not shown, and it is the animator's
		    job to show it at the end of animation.
		    If target is null, then the widget is being 
		    undisplayed. */
  Tile t;        /* the tile displayed by the widget */
  int ori;       /* and its orientation */
  int x, y;      /* x and y coordinates relative to the boardframe */
} AnimInfo;

/* enums used in the dialog popup function to specify position */
typedef enum {
  DPCentred, /* centered over main window */
  DPOnDiscard, /* bottom left corner in same place as discard dialog */
  DPErrorPos, /* for error dialogs: centred over top of main window */
  DPNone, /* don't touch the positioning at all */
  DPCentredOnce, /* centre it on first popup, then don't fiddle */
  DPOnDiscardOnce, /* on discard dialog first time, then don't fiddle */
} DPPosn;

/* Where to put the dialog boxes */
typedef enum {
 DialogsUnspecified = 0,
 DialogsCentral = 1,
 DialogsBelow = 2,
 DialogsPopup = 3 } DialogPosition;

/*****************
   FORWARD DECLARATIONS
*****************/

/* FUNCTIONS */

gint doubleclicked(GtkWidget *w, GdkEventButton *eb,gpointer data);
void button_set_tile(GtkWidget *b, Tile t, int ori);
void chow_dialog_init(void);
void close_connection(void);
void conc_callback(GtkWidget *w, gpointer data);
void continue_dialog_init(void);
void continue_dialog_popup(void);
void dialog_popup(GtkWidget *dialog, DPPosn posn);
void disc_callback(GtkWidget *w, gpointer data);
void discard_dialog_init(void);
void discard_dialog_popup(Tile t, int ori, int mode);
void do_chow(GtkWidget *w, gpointer data);
void ds_dialog_init(void);
void ds_dialog_popup(void);
void error_dialog_init(void);
void error_dialog_popup(char *msg);
GtkWidget *menubar_create(void);
void messagewindow_init(void);
void open_connection(GtkWidget *w UNUSED, gpointer data);
void open_dialog_init(char *ht, char *pt, char *ft, char *idt, char *nt, int usehost);
void open_dialog_popup(GtkWidget *w UNUSED, gpointer data);
void scoring_dialog_init(void);
void scoring_dialog_popup(void);
void showraise(GtkWidget *w);
void status_init(void);
void status_showraise(void);
void status_update(int game_over);
void textwindow_init(void);
void tilesetbox_highlight_nth(TileSetBox *tb,int n);
void tilesetbox_init(TileSetBox *tb, int ori,GtkSignalFunc func,gpointer func_data);
void tilesetbox_set(TileSetBox *tb, const TileSet *ts, int ori);
void turn_dialog_init(void);
void turn_dialog_popup(void);
void usage(char *pname,char *msg);
/* Convenience function */
#define send_packet(m) client_send_packet(the_game,(PMsgMsg *)m)

/* VARIABLES */

/* in gui.c */
extern int debug;
extern PlayerP our_player;
extern int our_id;
extern seats our_seat; /* our seat in the game */
extern Game *the_game;
extern int selected_button; /* the index of the user's selected
			     tile, or -1 if none */

extern int ptimeout; /* claim timeout time in milliseconds */

extern GdkPixmap **tilepixmaps[]; /* pixmaps for the tiles */

extern GtkWidget *topwindow; /* main window */
extern GtkWidget *menubar; /* menubar */
extern GtkWidget *board; /* the table area itself */
extern GtkWidget *boardframe; /* fixed widget wrapping the board */
extern GtkStyle *tablestyle; /* for the dark green stuff */
extern GtkStyle *highlightstyle; /* to highlight tiles */
extern GtkWidget *highlittile; /* the unique highlighted tile */
extern GdkFont *fixed_font; /* a fixed width font */
extern GdkFont *big_font; /* big font for claim windows */

extern GtkWidget *dialoglowerbox; /* encloses dialogs when dialogs are below */

/* Why an array? So I can pass pointers around */
extern DiscardDialog discard_dialog[1];

/* dialog box for specifying chows */
extern GtkWidget *chowdialog;

/* dialog box for declaring specials */
extern GtkWidget *ds_dialog;

/* dialog box for continuing with next hand */
extern GtkWidget *continue_dialog;

/* dialog box for error messages */
extern GtkWidget *error_dialog;

/* dialog for opening connection */
extern GtkWidget *open_dialog;
extern GtkWidget *openmenuentry, *newgamemenuentry, *closemenuentry;
extern GtkWidget *openallowdisconnectbutton,*openrandomseatsbutton,
  *openplayercheckboxes[3],*openplayeroptions[3],*opentimeoutspinbutton;

/* dialog box for action when it's our turn.
   Actions: Discard  Kong  Add to Pung  Mah Jong
*/
extern GtkWidget *turn_dialog;

/* dialog box for closed sets when scoring.
   Actions: Eyes  Chow  Pung  Done
*/
extern GtkWidget *scoring_dialog;

/* window for game status display */
extern GtkWidget *status_window;

/* an array of text widgets for displaying scores etc.
   Element 4 is for settlements.
   The others are for each player: currently, I think
   these should be table relative.
*/
extern GtkWidget *scoring_notebook;
extern GtkWidget *textpages[5];
extern GtkWidget *textlabels[5]; /* labels for the pages */
extern GtkWidget *textwindow; /* and the window for it */

/* The window for messages, and the display text widget */
extern GtkWidget *messagewindow, *messagetext;

/* This gives the width of a player display in units
   of tiles */

extern int pdispwidth;
extern int square_aspect; /* force a square table */
extern int animate; /* do fancy animation */
/* the player display areas */
extern PlayerDisp pdisps[NUM_SEATS];

extern int calling; /* disgusting global flag */

/* the widget in which we put discards */
extern GtkWidget *discard_area;
/* This is an allocation structure in which we
   note its allocated size, at some point when we
   know the allocation is valid.
*/
extern GtkAllocation discard_area_alloc;

extern GtkWidget *just_doubleclicked; /* yech yech yech. See doubleclicked */

/* space round edge of dialog boxes */
extern const gint dialog_border_width;
/* horiz space between buttons */
extern const gint dialog_button_spacing;
/* vert space between text and buttons etc */
extern const gint dialog_vert_spacing;

/* space around player boxes. N.B. this should only
   apply to the outermost boxes */
extern const int player_border_width;

extern DialogPosition dialogs_position;

/* in gui-dial.c */
extern GtkWidget *openfile, *openhost, *openport,
  *openfiletext, *openhosttext, *openporttext, *openidtext, *opennametext;

/* static for each module */
#include "version.h"

