/*

Name:
TCLUI.C

Description:
Drop-in UI replacement for TCL/TK interface.

Peter Amstutz <amstpi@freenet.tlh.fl.us>

HISTORY
=======

v1.00 (19/01/97) - tcl version!
v1.01 (27/03/97) - commands now all start with '='

*/
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>

#include "mikmod.h"
#include "ui.h"

int current_pattern;
int count_pattern, count_song;
extern int readme,writeme;

void GetLine(char *);

int get_ui()
{
	char string[80];
	GetLine(string);

		if(!strcmp(string,"=PLAY\n")) return UI_PLAY;
		if(!strcmp(string,"=STOP\n")) return UI_STOP;
		if(!strcmp(string,"=PAUSE\n")) return UI_PAUSE;
		if(!strcmp(string,"=QUIT\n")) return UI_QUIT;
		if(!strcmp(string,"=PREVMOD\n")) return UI_PREVIOUS_SONG;
		if(!strcmp(string,"=PREVPAT\n")) return UI_JUMP_TO_PREV_PATTERN;
		if(!strcmp(string,"=NEXTPAT\n")) return UI_JUMP_TO_NEXT_PATTERN;
		if(!strcmp(string,"=NEXTMOD\n")) return UI_NEXT_SONG;
		if(!strcmp(string,"=RESTART\n")) return UI_RESTART;
		if(!strcmp(string,"=8BIT\n")) return UI_SELECT_8BIT;
		if(!strcmp(string,"=16BIT\n")) return UI_SELECT_16BIT;
		if(!strcmp(string,"=MONO\n")) return UI_SELECT_MONO;
		if(!strcmp(string,"=STEREO\n")) return UI_SELECT_STEREO;
		if(!strcmp(string,"=INTERP\n")) return UI_SELECT_INTERP;
		if(!strcmp(string,"=NOINTERP\n")) return UI_SELECT_NONINTERP;
		if(!strcmp(string,"=RANDOM\n")) return UI_RANDOM;
		if(!strcmp(string,"=ORDERLY\n")) return UI_ORDERLY;
		if(!strcmp(string,"=DEL_AFTER_PLAY\n")) return UI_DEL_AFTER_PLAY;
		if(!strcmp(string,"=NO_DEL_AFTER_PLAY\n")) return UI_NO_DEL_AFTER_PLAY;

/*	} */

	return 2;
}

