#include "ConfigParser.h"

/*
 * ConfigParser()
 *
 * Initialize the port variables. These are checked in MediaStreamer to determine if
 * a audio/video group/port was specified.
 */

ConfigParser::ConfigParser() {

	audioGroup = (char *)malloc(sizeof(char)*16);
	videoGroup = (char *)malloc(sizeof(char)*16);
	loop = (char *)malloc(sizeof(char)*3);

	audioPort = 0;
	videoPort = 0;
	ttl = 127;

}

/*
 * parse()
 *
 * Parse a playlist file, extracting the configuration directives and returning a
 * list of media files to play.
 */

PlayList ConfigParser::parse(char *configfile) {

	FILE *fp;
	const int buffersize = 1024;
	char line[buffersize];
	char *key, *value;
	PlayList plist;
	Media *media;

	if ((fp = fopen(configfile, "r")) == NULL) {
		perror("fopen");
		exit(1);
	}

	while(fgets(line, buffersize, fp)) {

		line[strlen(line)-1] = '\0';

		if (line[0] == '#' || line[0] == ' ' || line[0] == '\n')
			continue;

		key = strtok(line, "=");
		value = strtok(NULL, "=");

		if (!strcmp(key, "vg")) {
			strcpy(videoGroup, value);
		} else if (!strcmp(key, "vp")) {
			videoPort = atoi(value);
		} else if (!strcmp(key, "ag")) {
			strcpy(audioGroup, value);
		} else if (!strcmp(key, "ap")) {
			audioPort = atoi(value);
		} else if (!strcmp(key, "ttl")) {
			ttl = atoi(value);
		} else if (!strcmp(key, "loop")) {
			strcpy(loop, value);
		} else if (!strcmp(key, "file")) {
			media = (Media *)malloc(sizeof(Media));
			media->filename = (char *)malloc(sizeof(char)*100);
			media->input = I_FILE;
			strcpy(media->filename, value);
			plist.push_back(media);
		} else if (!strcmp(key, "pipe")) {
			media = (Media *)malloc(sizeof(Media));
			media->filename = (char *)malloc(sizeof(char)*100);
			media->input = I_PIPE;
			strcpy(media->filename, value);
			plist.push_back(media);
		} else {
			printf("%s: Invalid key\n", key);
		}

	}

	fclose(fp);

	return plist;

}
