#include "MediaInfo.h"

/*
 * getType()
 *
 * Determine the type of media to play.
 */

int MediaInfo::getType(Media *media) {

	unsigned int code = 0;
	unsigned char byte = 0;
	int mediatype = M_UNKNOWN;
	int count = 0;
	FILE *fp = getStreamPointer(media);

	hasAudio = 0;
	hasVideo = 0;

	while(fread(&byte, sizeof(char), 1, fp)) {

		code <<= 8;
		code |= byte;

		if (code == PACK_START_CODE) {
			hasAudio = 1;
			hasVideo = 1;
			mediatype = M_MPEG1SS;
			break;
		} else if (code == SYS_START_CODE) {
			hasAudio = 0;
			hasVideo = 1;
			return M_MPEG1ES;
			break;
		} else if ((code&0xffff0000) == MP3_START_CODE) {
			hasAudio = 1;
			hasVideo = 0;
			return M_MP3;
			break;
		}

		if (count > 3) break;
		count++;

	}

	fclose(fp);

	return mediatype;	

}

/*
 * getStreamPointer()
 *
 * Open a stream pointer to a file or pipe.
 */

FILE *MediaInfo::getStreamPointer(Media *media) {

	FILE *fd = NULL;

	switch(media->input) {
		case I_FILE:
			fd = fopen(media->filename, "r");
			break;
		case I_PIPE:
			fd = popen(media->filename, "r");
			break;
	}

	return fd;

}
