#ifndef MEDIAINFO_H
#define MEDIAINFO_H

#include <stdio.h>
#include <netinet/in.h>
#include <vector.h>

#define PACK_START_CODE 0x000001ba
#define SYS_START_CODE 0x000001b3
#define MP3_START_CODE 0xfffb0000

enum {
	M_MP3,
	M_MPEG1ES,
	M_MPEG1SS,
	M_MPEG2TS,
	M_UNKNOWN,
	I_FILE,
	I_PIPE
};

typedef struct {
	int input;
	char *filename;
} Media;

typedef vector<Media *> PlayList;

class MediaInfo {

	public:
		MediaInfo() {}
		int getType(Media *media);
		static FILE *getStreamPointer(Media *media);
		int hasAudio;
		int hasVideo;
	
};

#endif
