#ifndef MEDIASTREAMER_H
#define MEDIASTREAMER_H

#include "liveMedia.hh"
#include "BasicUsageEnvironment.hh"
#include "GroupsockHelper.hh"
#include "MyByteStreamFileSource.h"
#include "MyMP3FileSource.h"
#include "MediaInfo.h"
#include "ConfigParser.h"

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <vector.h>

#define PACK_START_CODE 0x000001ba
#define SYS_START_CODE 0x000001b3

class MediaStreamer {

	public:
		MediaStreamer();
		void parseConfigFile(char *filename);
		void start(char *config);
		void play(Media *media);
		void afterPlay();
		Media *next();

	private:
		int filetype(char *filename);
		void playMP3(Media *media);
		void playMPEG(Media *media);

		UsageEnvironment *env;
		MPEGDemux *mpegDemux;
		MediaSource *audioSource;
		MediaSource *videoSource;
		RTPSink *audioSink;
		RTPSink *videoSink;
		PlayList playlist;
		PlayList::iterator piter;
		MediaInfo mediaInfo;
		ConfigParser parser;

};

#endif
