#include "MyByteStreamFileSource.h"

MyByteStreamFileSource::MyByteStreamFileSource(UsageEnvironment& env,
	FILE *fid, 
	unsigned pfs,
	float ptpf) : ByteStreamFileSource(env, fid, pfs, ptpf) {

}

ByteStreamFileSource* MyByteStreamFileSource::createNew(UsageEnvironment& env,
		Media *media,
		unsigned pfs,
		float ptpf) {

	ByteStreamFileSource *newSource = NULL;
	FILE *fid = NULL;

	do {

		fid = MediaInfo::getStreamPointer(media);
		if (fid == NULL)
			break;

		newSource = new MyByteStreamFileSource(env, fid, pfs, ptpf);

		if (newSource == NULL) {
			fclose(fid);
			break;
		}

		Medium::addNew(env, newSource);

		return newSource;

	} while(0);

	return NULL;

}
