#include "MyMP3FileSource.h"

MyMP3FileSource::MyMP3FileSource(UsageEnvironment& env, FILE *fid)
	: MP3FileSource(env, fid) {

}

MP3FileSource *MyMP3FileSource::createNew(UsageEnvironment& env, Media *media) {

	MyMP3FileSource *newSource = NULL;
	FILE *fid = NULL;
	int filesize = 0;

	do {

		fid = MediaInfo::getStreamPointer(media);
		if (fid == NULL)
			break;
		if (media->input == I_FILE) {
			struct stat sb;
			if (stat(media->filename, &sb) == 0)
				filesize = sb.st_size;
		}

		newSource = new MyMP3FileSource(env, fid);

		if (newSource == NULL) {
			fclose(fid);
			break;
		}

		newSource->assignStream(fid, filesize);
		if (!newSource->initializeStream()) {
		 	fclose(fid);	
			break;
		}

		Medium::addNew(env, newSource);

		return newSource;

	} while(0);

	return NULL;

}
