#include "SDPFile.h"

/*
 * createKey()
 *
 * Add a new line to the buffer
 */

void SDPFile::createKey(char *key, char *value) {

	char line[1024];
	sprintf(line, "%s=%s\n", key, value);
	strcat(buffer, line);

}

/*
 * generate()
 *
 * Build the SDP file buffer with information from a playlist file.
 */

void SDPFile::generate(char *configfile) {

	char value[1024];
	char hostname[50];
	buffer = (char *)malloc(sizeof(char *)*4000);

	ConfigParser parser;
	parser.parse(configfile);

	createKey("v", "0");
	gethostname(hostname, 50);
	sprintf(value, "%s %d %d IN IP4 %s", getlogin(), timestamp(), timestamp(), hostname);
	createKey("o", value);
	createKey("s", "mimd session");
	createKey("i", "mimd session description");
	createKey("t", "0 0");
	createKey("a", "tool:mimd 0.2");
	createKey("a", "recvonly");
	createKey("a", "type:broadcast");
	if (parser.getAudioPort()) {
		sprintf(value, "audio %d RTP/AVP 14", parser.getAudioPort());
		createKey("m", value);
		sprintf(value, "IN IP4 %s/%d", parser.getAudioGroup(), parser.getTTL());
		createKey("c", value);
	}
	if (parser.getVideoPort()) {
		sprintf(value, "video %d RTP/AVP 32", parser.getVideoPort());
		createKey("m", value);
		sprintf(value, "IN IP4 %s/%d", parser.getVideoGroup(), parser.getTTL());
		createKey("c", value);
	}

}

/*
 * output()
 *
 * Create an SDP file with the contents from buffer.
 */

void SDPFile::output(char *outputfile) {

	FILE *fp;

	if ((fp = fopen(outputfile, "w")) == NULL) {
		perror("fopen");
		return;
	}

	fputs(buffer, fp);

	fclose(fp);

}

/*
 * timestamp()
 *
 * Generate a timestamp.
 */

unsigned int SDPFile::timestamp() {

	struct timeval tv;
	unsigned int stamp;
	
	gettimeofday(&tv, 0);

	stamp = (tv.tv_sec << 16) | (tv.tv_usec & 0x0000ffff);

	return stamp;
}
