/*
 * mimd 0.2 Abiel Reinhart abielr@myrealbox.com
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <pthread.h>
#include "MediaStreamer.h"
#include "SDPFile.h"

/*
 * playList()
 * called with a playlist filename as an argument.
 */

void *playList(void *list) {

	MediaStreamer ms;

	// Begin playing
	ms.start((char *)list);

	return 0;

}

int main(int argc, char *argv[]) {

	pthread_t threadid[argc];
	char sdpname[50];
	int i, makesdp = 0;
	SDPFile sdpfile;

	if (argc < 2) {
		printf("Usage: mimd options playlist1 [playlist2 playlist3 ...]\n");
		printf("Options:\n");
		printf("	-s: generate sdp file for each playlist\n");
		return 0;
	}

	// Loop through the playlists and put each one into its own thread.
	for(i = 1; i < argc; i++) {
		if (!strcmp(argv[i], "-s")) {
			makesdp = 1;
			continue;
		}
		if (makesdp) {
			sprintf(sdpname, "%s.sdp", argv[i]);
			sdpfile.generate(argv[i]);
			sdpfile.output(sdpname);
			printf("Wrote %s from %s\n", sdpname, argv[i]);
		}
		pthread_create(&threadid[i-1], NULL, playList, (void *)argv[i]);
	}

	for(i = 1; i < argc; i++) {
		if (argv[i][0] == '-')
			continue;
		pthread_join(threadid[i-1], NULL);
	}	

	return 0;

}
