/***********************************************************************
*
* mimedefang.h
*
* External declarations and defines.
*
* Copyright (C) 2002-2003 by Roaring Penguin Software Inc.
*
***********************************************************************/

/* $Id: mimedefang.h,v 1.9 2003/02/14 18:28:29 dfs Exp $ */

#ifndef MIMEDEFANG_H
#define MIMEDEFANG_H 1

#include <stdio.h>

#define SMALLBUF 4096

extern void chomp(char *str);
extern void write_percent_encoded(unsigned char const *str, FILE *fp);
extern int percent_encode(unsigned char *in, unsigned char *out, int outlen);
extern int percent_encode_command(char *out, int outlen, ...);
extern void percent_decode(unsigned char *buf);

extern int MXCheckFreeSlaves(char const *sockname);
extern int MXScanDir(char const *sockname, char const *dir);
extern int MXCommand(char const *sockname, char const *cmd, char *buf, int len);
extern int MXRelayOK(char const *sockname, char *msg,
		     char const *ip, char const *name,
		     char const *helo, char const *dir);
extern int MXSenderOK(char const *sockname, char *msg,
		      char const *sender, char const *ip, char const *name,
		      char const *helo, char const *dir);
extern int MXRecipientOK(char const *sockname, char *msg, char const *recip,
			 char const *sender, char const *ip, char const *name,
			 char const *firstRecip, char const *helo,
			 char const *dir);

extern int safeWriteHeader(FILE *fp, unsigned char const *str);
extern void split_on_space(char *buf, char **first, char **rest);
extern void split_on_space3(char *buf, char **first, char **second, char **rest);
extern void *malloc_with_log(size_t s);
extern char *strdup_with_log(char const *s);
extern void write_mx_command(FILE *fp, char cmd, unsigned char const *buf);
extern int rm_r(char const *dir);

#endif

