#include <sys/types.h>
#include "guts.h"
#include <X11/cursorfont.h>
#include "bitmaps/fire1"
#include "bitmaps/fire2"
#include "bitmaps/fire3"
#include "bitmaps/plane"
#include "bitmaps/noplane"
#include "bitmaps/city"
#include "bitmaps/shot"
#include "bitmaps/smallshot"
#include "bitmaps/base"
#include "bitmaps/cross"
#include "bitmaps/cloud0"
#include "bitmaps/cloud1"
#include "bitmaps/cloud2"
#include "bitmaps/cloud3"
#include "bitmaps/cloud4"
#include "bitmaps/cloud5"
#include "bitmaps/smart1"
#include "bitmaps/smart2"

#if 0
#define USE_CIRCLE 
#endif

#define HIT_MISSILE_SC	1
#define SAVE_MISSILE_SC 3
#define CITY_SC			5
#define PLANE_SC		7
#define SMART_SC		10

#define SAMPLE_LINE	350
#define TEXT_LINE	400
#define TITLE_LINE	50
#define BRAG_LINE	150
#define NUM_SAMPLES 5

#define LEFT	0x1
#define RIGHT	0x2
#define TOP		0x4
#define BOTTOM	0x8

#define SMARTWAIT 0
#define PLANELEVEL 5

#define PAUSEINC 1
int PAUSE = 0;

#define SHOTS_PER_BASE 10

#define MISSLEDELAY 50
#define BOMBDELAY  	50
#define STADELAY    50

int usleep(unsigned long usec);
void DropBomb(int x, int y, int chk);
SMART *KillSmart(SMART *curr, int detonated);

GC circ_gc, sta_gc, erase_gc, fall_gc;
XFontStruct *the_font;
int xserver_fd;
fd_set check_mask;
Window grab_win;
Cursor cursor;

MISSLE Miss[50];
BOMB *first_bomb, *last_bomb;
STA *first_sta, *last_sta;
SMART *first_smart, *last_smart;

XPoint missileStorage[] = {
	{7, 5}, {1, 5}, {-5, 5}, {-11, 5},
	{4, 9}, {-2, 9}, {-8, 9},
	{1, 13}, {-5, 13},
	{-2, 17}
};

int intact[9];
int shots[9];
int level, score;
PLANE ship;
int TotalSmart, MaxSmartPerLevel, MaxSmart, numsmart;

char *fontname = "-*-helvetica-bold-r-*-140-*";

int NumAlive, NumDead;
unsigned long basedelay, stadelay, bombdelay, missledelay;

int nMiss, MaxMiss;

Pixmap base, city, cloud0, cloud1, cloud2, cloud3, cloud4, cloud5, cross;
Pixmap fire1, fire2, fire3, shot, smallshot, plane, noplane, smart1, smart2;

#ifndef USE_CIRCLE
int stagesize[] = {5, 10, 15, 20, 25, 20, 15, 10, 5, 25};
#else
int stagesize[] = {2, 8, 10, 12, 14, 16, 18, 20, 22, 25};
#endif

int locX[]={50, 125, 225, 325, 400, 475, 575, 675, 750};

#define MAXFIRE 3
int firestage[10];

int SizeX(char *s) {

	return(strlen(s)*XTextWidth(the_font, "0", 1));
}

void TitlePage(void) {
char *s1="**   MISSILE X   **";
char *s2="Written By:";
char *s3="Sandy Walsh and John Rochester";
char *s4="(Click to Start)";
char *s5="Memorial University of Newfoundland, Canada";

char s[40];
long event = KeyPressMask | ButtonPressMask;
XEvent report;
int space = MAXX/(NUM_SAMPLES+1);
int cs;

	cs=space;

	XDrawString(display, win, sta_gc, MAXX/2-SizeX(s1)/2, TITLE_LINE, s1, strlen(s1));
	XDrawString(display, win, sta_gc, MAXX/2-SizeX(s2)/2, BRAG_LINE, s2, strlen(s2));
	XDrawString(display, win, sta_gc, MAXX/2-SizeX(s3)/2, BRAG_LINE+25, s3, strlen(s3));
	XDrawString(display, win, sta_gc, MAXX/2-SizeX(s5)/2, BRAG_LINE+50, s5, strlen(s5));
	XDrawString(display, win, sta_gc, MAXX/2-SizeX(s4)/2, MAXY-50, s4, strlen(s4));

	XDrawLine(display, win, fall_gc, cs-25, SAMPLE_LINE, cs+25, SAMPLE_LINE+25);
	sprintf(s, "%d", HIT_MISSILE_SC*100);
	XDrawString(display, win, sta_gc, cs-SizeX(s)/2, TEXT_LINE, s, strlen(s));

	cs+=space;
	XCopyArea(display, shot, win, sta_gc,
		0, 0, shot_width, shot_height, cs-shot_width/2 , SAMPLE_LINE);
	sprintf(s, "%d", SAVE_MISSILE_SC*100);
	XDrawString(display, win, sta_gc, cs-SizeX(s)/2, TEXT_LINE, s, strlen(s));

	cs+=space;
	XCopyArea(display, city, win, sta_gc,
		0, 0, city_width, city_height, cs-city_width/2 , SAMPLE_LINE);
	sprintf(s, "%d", CITY_SC*100);
	XDrawString(display, win, sta_gc, cs-SizeX(s)/2, TEXT_LINE, s, strlen(s));

	cs+=space;
	XCopyArea(display, plane, win, sta_gc,
		0, 0, plane_width, plane_height, cs-plane_width/2 , SAMPLE_LINE);
	sprintf(s, "%d", PLANE_SC*100);
	XDrawString(display, win, sta_gc, cs-SizeX(s)/2, TEXT_LINE, s, strlen(s));

	cs+=space;
	XCopyArea(display, smart1, win, sta_gc,
		0, 0, smart1_width, smart1_height, cs-smart1_width/2 , SAMPLE_LINE);
	sprintf(s, "%d", SMART_SC*100);
	XDrawString(display, win, sta_gc, cs-SizeX(s)/2, TEXT_LINE, s, strlen(s));
	
	while (!XCheckMaskEvent(display, event, &report))
		;

	XClearWindow(display, win);
	XSync(display, TRUE);
}

int PickDest(void) {
int dest, count=0;;

	dest = rrandom(9);
	while (!intact[dest] && count < 20) {
		dest  = rrandom(9);
		count++;
	}

	return dest;
}

void IncScore(int v) {
static char s[80];

	sprintf(s, "Score: %d00",score);
	XDrawString(display, win, erase_gc, 10, TOPY-5, s, strlen(s));
	score+=v;
	sprintf(s, "Score: %d00",score);
	XDrawString(display, win, sta_gc, 10, TOPY-5, s, strlen(s));
}

void SetupBres(int a) {
int h, x1, x2, y2, y1;

	x1=Miss[a].sx; x2=Miss[a].destx;
	y1=Miss[a].sy; y2=Miss[a].desty;

	Miss[a].dx=abs(x1-x2);
	Miss[a].dy=abs(y1-y2);

	Miss[a].c_x=x1;
	Miss[a].xi= (x1<x2) ? 1 : -1;
	Miss[a].c_y=y1;
	Miss[a].yi= (y1<y2) ? 1 : -1;

	if (Miss[a].dx>Miss[a].dy) {
		Miss[a].c=Miss[a].dx;
		Miss[a].p=2*Miss[a].dy-Miss[a].dx;
		Miss[a].c1=2*Miss[a].dy;
		Miss[a].c2=2*(Miss[a].dy-Miss[a].dx);
	} else {
		Miss[a].c=Miss[a].dy;
		Miss[a].p=2*Miss[a].dx-Miss[a].dy;
		Miss[a].c1=2*Miss[a].dx;
		Miss[a].c2=2*(Miss[a].dx-Miss[a].dy);
	}
}

void InitMissle(int a, int starty, int som, int depth) {
int b;

	Miss[a].c_x=Miss[a].sx=rrandom(MAXX);
	Miss[a].c_y=Miss[a].sy=starty;

	Miss[a].city  = PickDest();
	Miss[a].destx = locX[Miss[a].city];
	Miss[a].desty = MAXY - base_height + 2;

	Miss[a].sonofmirv=som;
	Miss[a].depth=depth;

	Miss[a].Mirved = FALSE;

	if (rrandom(5)==0 && Miss[a].depth<2) {
		Miss[a].IsMirv = TRUE;
		Miss[a].MirvAtY = starty+((MAXY-starty)/2)-rrandom(100);

		Miss[a].destx = rrandom(MAXX);
		Miss[a].desty = Miss[a].MirvAtY;

		Miss[a].NumMirvs=rrandom(2)+2; 

		for (b=0; b<Miss[a].NumMirvs; b++) 
			Miss[a].mirv[b]=MaxMiss+b;

		MaxMiss+=Miss[a].NumMirvs;

		for (b=0; b<Miss[a].NumMirvs; b++)
			InitMissle(Miss[a].mirv[b], Miss[a].MirvAtY, TRUE, depth+1);
	} else 
		Miss[a].IsMirv=FALSE;

	SetupBres(a);

	Miss[a].alive=(som) ? FALSE : TRUE;
}

void InitMissles(void) {
int a;

	nMiss=rrandom(5)+5; MaxMiss=nMiss; NumAlive=nMiss;

	missledelay-=nMiss*MISSLEDELAY;

	for (a=0; a<nMiss; a++)
		InitMissle(a,TOPY+1,FALSE,0);
}

void LoseShot(int base) {
	if (!intact[base])
		return;
	shots[base]--;
	XFillRectangle(display, win, sta_gc,
		locX[base] + missileStorage[shots[base]].x,
		MAXY - missileStorage[shots[base]].y,
		smallshot_width,
		smallshot_height);
}

void DrawBoard(void) {
int a, b;
static char s[40];

	XDrawLine(display, win, sta_gc, 0, TOPY, MAXX, TOPY);

	for (a = 0; a <= 8; a += 4) {
		if (intact[a]) {
			XCopyArea(display, base, win, sta_gc,
				0, 0, base_width, base_height, 
				locX[a] - base_width / 2, MAXY - base_height);

			for (b = 0; b < shots[a]; b++)
				XCopyArea(display, smallshot, win, sta_gc,
					0, 0, smallshot_width, smallshot_height,
					locX[a] + missileStorage[b].x,
					MAXY - missileStorage[b].y);
		}
	}

	for (a=0; a<3; a++) {
		if (intact[1+a])
			XCopyArea(display, city, win, sta_gc,
				0, 0, city_width, city_height, 
				locX[1+a] - city_width / 2, MAXY - city_height);
		if (intact[5+a])
			XCopyArea(display, city, win, sta_gc,
				0, 0, city_width, city_height, 
				locX[5+a] - city_width / 2, MAXY - city_height);
	}

	IncScore(0);

	sprintf(s, "Level %d", level);
	XDrawString(display, win, sta_gc, 790 - XTextWidth(the_font, s, strlen(s)), TOPY-5, s, strlen(s));

}

void
grab_pointer()
{
	XGrabPointer(display, win, True,
			ButtonReleaseMask | ButtonPressMask,
			GrabModeAsync, GrabModeAsync, grab_win,
			cursor, CurrentTime);
}

void
ungrab_pointer()
{
	XUngrabPointer(display, CurrentTime);
}

void InitGame(void) {
unsigned long valuemask;
XGCValues gc;
int a;

	score=0;
	for (a=0; a<9; a++) 
		intact[a]=TRUE;

	xserver_fd = ConnectionNumber(display);
	FD_ZERO(&check_mask);
	FD_SET(xserver_fd, &check_mask);

	valuemask = GCGraphicsExposures | GCForeground;
	gc.foreground = colors[BLUE];
	gc.graphics_exposures = 0;
	fall_gc=XCreateGC(display, win, valuemask, &gc);

	gc.foreground = colors[BLACK];
	sta_gc=XCreateGC(display, win, valuemask, &gc);

	gc.foreground = colors[WHITE];
	erase_gc=XCreateGC(display, win, valuemask, &gc);

	valuemask = GCFillStyle | GCBackground | GCLineWidth | GCGraphicsExposures | GCForeground;
	gc.foreground = colors[BLACK];
	gc.background = colors[RED];
	gc.line_width = 2;
	gc.fill_style = FillOpaqueStippled;
	circ_gc=XCreateGC(display, win, valuemask, &gc);

	if ((the_font = XLoadQueryFont(display, fontname)) == NULL)
		the_font = XQueryFont(display, XGContextFromGC(sta_gc));
	else {
		XSetFont(display, sta_gc, the_font->fid);
		XSetFont(display, erase_gc, the_font->fid);
	}

	fire1 = XCreatePixmapFromBitmapData(display, win, 
				fire1_bits, fire1_width, fire1_height, 
				colors[RED], colors[WHITE],8);

	fire2 = XCreatePixmapFromBitmapData(display, win, 
				fire2_bits, fire2_width, fire2_height, 
				colors[RED], colors[WHITE],8);

	fire3 = XCreatePixmapFromBitmapData(display, win, 
				fire3_bits, fire3_width, fire3_height, 
				colors[RED], colors[WHITE],8);

	smart1 = XCreatePixmapFromBitmapData(display, win, 
				smart1_bits, smart1_width, smart1_height, 
				colors[RED], colors[WHITE],8);

	smart2 = XCreatePixmapFromBitmapData(display, win, 
				smart2_bits, smart2_width, smart2_height, 
				colors[RED], colors[WHITE],8);

	noplane = XCreatePixmapFromBitmapData(display, win, 
				noplane_bits, noplane_width, noplane_height, 
				colors[RED], colors[WHITE],8);

	plane = XCreatePixmapFromBitmapData(display, win, 
				plane_bits, plane_width, plane_height, 
				colors[RED], colors[WHITE],8);

	shot = XCreatePixmapFromBitmapData(display, win, 
				shot_bits, shot_width, shot_height, 
				colors[RED], colors[WHITE],8);

	smallshot = XCreatePixmapFromBitmapData(display, win,
				smallshot_bits, smallshot_width,
				smallshot_height,
				colors[YELLOW], colors[WHITE],8);

	base = XCreatePixmapFromBitmapData(display, win, 
				base_bits, base_width, base_height, 
				colors[BLACK], colors[WHITE],8);

	city = XCreatePixmapFromBitmapData(display, win, 
				city_bits, city_width, city_height, 
				colors[BLACK], colors[WHITE],8);

	cross = XCreatePixmapFromBitmapData(display, win, 
				cross_bits, cross_width, cross_height, 
				colors[BLACK], colors[WHITE],8);

	cloud0 = XCreatePixmapFromBitmapData(display, win, 
				cloud0_bits, cloud0_width, cloud0_height, 
				colors[WHITE], colors[WHITE],8);

	cloud1 = XCreatePixmapFromBitmapData(display, win, 
				cloud1_bits, cloud1_width, cloud1_height, 
				colors[RED], colors[WHITE],8);

	cloud2 = XCreatePixmapFromBitmapData(display, win,
				cloud2_bits, cloud2_width, cloud2_height,
				colors[RED], colors[WHITE],8);

	cloud3 = XCreatePixmapFromBitmapData(display, win,
				cloud3_bits, cloud3_width, cloud3_height,
				colors[RED], colors[WHITE],8);

	cloud4 = XCreatePixmapFromBitmapData(display, win,
				cloud4_bits, cloud4_width, cloud4_height,
				colors[RED], colors[WHITE],8);

	cloud5 = XCreatePixmapFromBitmapData(display, win,
				cloud5_bits, cloud5_width, cloud5_height,
				colors[RED], colors[WHITE],8);

	grab_win = XCreateWindow(display, win, 0, TOPY,
		MAXX, BOTTOMY - TOPY + 1,
		0, CopyFromParent, InputOnly, CopyFromParent, 0, NULL);
	XMapWindow(display, grab_win);
	cursor = XCreateFontCursor(display, XC_cross);
}

int CheckParents(void) {
int a,b,all;

	for (a=0; a<MaxMiss; a++) {
		if (Miss[a].alive && Miss[a].IsMirv) 
			if (Miss[a].Mirved) {
				all=TRUE;
				for (b=0; b<Miss[a].NumMirvs; b++)
					if (Miss[Miss[a].mirv[b]].alive)
						all=FALSE;

				if (all) {
					Miss[a].alive=FALSE;
					XDrawLine(display, win, erase_gc, 
						Miss[a].sx, Miss[a].sy,
						Miss[a].destx, Miss[a].desty);
					NumDead++;
					missledelay+=MISSLEDELAY;

					CheckParents();
				}
			}
	}
}

int CheckIfHit(int a) {

	if (Miss[a].IsMirv) 
		return FALSE;

	Miss[a].alive=FALSE;

	XDrawLine(display, win, erase_gc, 
		Miss[a].sx, Miss[a].sy,
		Miss[a].destx, Miss[a].desty);

	DropBomb(Miss[a].destx, MAXY - cloud0_height / 2,TRUE);

	NumDead++;
	missledelay+=MISSLEDELAY;

	intact[Miss[a].city]=FALSE;
	if (Miss[a].city==0 || Miss[a].city==4 || Miss[a].city==8)
		shots[Miss[a].city]=0;

	firestage[Miss[a].city]=1;

	CheckParents();

	return TRUE;
}
	
void MoveMissle(int a) {
int b;
int hit=FALSE;
	
	if (Miss[a].dx>Miss[a].dy) {

		if (Miss[a].c>0) {
			Miss[a].c_x+=Miss[a].xi;
			Miss[a].c--;
			if (Miss[a].p<0)
				Miss[a].p+=Miss[a].c1;
			else {
				Miss[a].p+=Miss[a].c2;
				Miss[a].c_y+=Miss[a].yi;
			}
		} else hit=CheckIfHit(a);
	} else {

		if (Miss[a].c>0) {
			Miss[a].c_y+=Miss[a].yi;
			Miss[a].c--;
			if (Miss[a].p<0)
				Miss[a].p+=Miss[a].c1;
			else {
				Miss[a].p+=Miss[a].c2;
				Miss[a].c_x+=Miss[a].xi;
			}
		} else hit=CheckIfHit(a);
	}

	if (hit)
		return;

	XDrawPoint(display, win, fall_gc, Miss[a].c_x, Miss[a].c_y);

	if (Miss[a].c_y>MAXY)
		Miss[a].alive=FALSE;

	if (Miss[a].c_y == Miss[a].MirvAtY && Miss[a].IsMirv && !Miss[a].Mirved) {

		Miss[a].Mirved=TRUE;

		NumAlive+=Miss[a].NumMirvs;
		missledelay-=Miss[a].NumMirvs*MISSLEDELAY;

		for (b=0; b<Miss[a].NumMirvs; b++) {

			Miss[Miss[a].mirv[b]].alive=TRUE;
			Miss[Miss[a].mirv[b]].sy=Miss[a].c_y;
			Miss[Miss[a].mirv[b]].sx=Miss[a].c_x;

			SetupBres(Miss[a].mirv[b]);
		}
	}
}

void HandleIt(void) {
int a;

	for (a=0; a<MaxMiss; a++)
		if (Miss[a].alive) {
			if (!Miss[a].IsMirv)
				MoveMissle(a);
			else if (!Miss[a].Mirved)
				MoveMissle(a);
		}
}

void FinishGame(void) {
	XFreeGC(display, fall_gc);
	XFreeGC(display, erase_gc);
	XFreeGC(display, sta_gc);
}

void CheckIntercept(int x1,int y1, int x2, int y2) {
int wid, a;
int hit;
SMART *curr;

	for (a=0; a<MaxMiss; a++) 
		if ((Miss[a].alive && !Miss[a].IsMirv) ||
			(Miss[a].alive && Miss[a].IsMirv && !Miss[a].Mirved)) {
				if ((Miss[a].c_x>x1 && Miss[a].c_x<x2) &&
					(Miss[a].c_y>y1 && Miss[a].c_y<y2)) {
						Miss[a].alive=FALSE;
						XDrawLine(display, win, erase_gc, 
							Miss[a].sx, Miss[a].sy,
							Miss[a].destx, Miss[a].desty);

						DropBomb(Miss[a].c_x, Miss[a].c_y, TRUE);
						NumDead++;
						IncScore(HIT_MISSILE_SC);

						missledelay+=MISSLEDELAY;

						CheckParents();
				}
			}

	if (ship.active && !ship.flown) {

		hit=FALSE;

		if (ship.cx+5>x1 && ship.cx+5<x2 && ship.cy>y1 && ship.cy<y2)
			hit=TRUE;
		else if (ship.cx+plane_width>x1 && ship.cx+plane_width<x2 && 
				ship.cy+plane_height>y1 && ship.cy+plane_height<y2)
			hit=TRUE;

		if (hit) {
			ship.active=FALSE;
			ship.flown=TRUE;

			XCopyArea(display, noplane, win, fall_gc, 0,0, 
				noplane_width, noplane_height, ship.cx, ship.cy);

			DropBomb(ship.cx+plane_width/2, ship.cy+plane_height/2, TRUE);
			IncScore(PLANE_SC);
		}
	}

	wid=smart1_width/2-2;
	curr=first_smart;
	while (curr!=NULL) {
		if ((curr->cx+wid>x1 && curr->cx+wid<x2 && curr->cy+wid>y1 && curr->cy+wid<y2) ||  
			(curr->cx-wid>x1 && curr->cx-wid<x2 && curr->cy-wid>y1 && curr->cy-wid<y2)) {
				curr=KillSmart(curr, FALSE);
				IncScore(SMART_SC);
		} else curr=curr->next;
	}
}

void UpdateBombs(void) {
int a, x, y, sz;
BOMB *curr=first_bomb;
BOMB *temp;
Pixmap p;

	while (curr!=NULL) {
		x=curr->x;
		y=curr->y;

#ifndef USE_CIRCLE
		switch(curr->stage) {
			case 0: p=cloud1; break;
			case 1: p=cloud2; break;
			case 2: p=cloud3; break;
			case 3: p=cloud4; break;
			case 4: p=cloud5; break;
			case 5: p=cloud4; break;
			case 6: p=cloud3; break;
			case 7: p=cloud2; break;
			case 8: p=cloud1; break;
			case 9: p=cloud0; break;
		}
#endif
		sz=stagesize[curr->stage];

#ifdef USE_CIRCLE
		if (curr->stage==9) 
			XFillArc(display, win, erase_gc, x-sz, y-sz, sz*2, sz*2, 0, 360*64);
		else 
			XFillArc(display, win, circ_gc, x-sz, y-sz, sz*2, sz*2, 0, 360*64);
#else
		XCopyArea(display, p, win, fall_gc, 0, 0, sz*2, sz*2, x-sz, y-sz);
#endif

		if (curr->check) 
			CheckIntercept(x-sz,y-sz,x+sz,y+sz);

		if (curr->pause-- < 1) {
			curr->pause=PAUSE;
			curr->stage++;
		}

		curr=curr->next;
	}

	curr=first_bomb;
	while(curr!=NULL)
		if (curr->stage==10) {
			if (curr->prev==NULL)
				first_bomb=curr->next;
			else 
				curr->prev->next=curr->next;

			if (curr->next==NULL)
				last_bomb=curr->prev;
			else
				curr->next->prev=curr->prev;

			temp=curr->next;
			free(curr);
			curr=temp;

			bombdelay+=BOMBDELAY;

		} else curr=curr->next;
}

void DropBomb(int x, int y, int chk) {
BOMB *new;

	if ((new=(BOMB *)malloc(sizeof(BOMB)))==NULL) {
		fprintf(stderr, "No bomb room\n");
		exit(1);
	}

	bombdelay-=BOMBDELAY;

	new->stage=0;
	new->x=x;
	new->y=y;
	new->pause=0;
	new->check=chk;

	new->next=NULL;

	if (first_bomb==NULL)
		first_bomb=new;
	
	if (last_bomb!=NULL)
		last_bomb->next=new;

	new->prev=last_bomb;

	last_bomb=new;
}

void LaunchSTA(int base, int x, int y) {
int h, x1, x2, y2, y1;
STA *new;

	if (y>BOTTOMY || !intact[base] || shots[base]<1) {
		XBell(display, 0);
		return;
	}

	LoseShot(base);

	if ((new=(STA *)malloc(sizeof(STA)))==NULL) {
		fprintf(stderr, "Cannot make more STA's\n");
		exit(1);
	}

	stadelay-=STADELAY;

	new->sx=x1=locX[base]; 
	new->sy=y1=MAXY - base_height + 2; 

	new->destx=x2=x; 
	new->desty=y2=y;

	XCopyArea(display, cross, win, fall_gc, 
		0,0, cross_width, cross_height, x-8,y-8);

	new->dx=abs(x1-x2);
	new->dy=abs(y1-y2);

	new->c_x=x1;
	new->xi= (x1<x2) ? 1 : -1;
	new->c_y=y1;
	new->yi= (y1<y2) ? 1 : -1;

	if (new->dx>new->dy) {
		new->c=new->dx;
		new->p=2*new->dy-new->dx;
		new->c1=2*new->dy;
		new->c2=2*(new->dy-new->dx);
	} else {
		new->c=new->dy;
		new->p=2*new->dx-new->dy;
		new->c1=2*new->dx;
		new->c2=2*(new->dx-new->dy);
	}
	new->active=TRUE;

	new->next=NULL;

	if (first_sta==NULL)
		first_sta=new;
	
	if (last_sta!=NULL)
		last_sta->next=new;

	new->prev=last_sta;

	last_sta=new;
}

void MoveSta(void) {
int a;
STA *curr=first_sta;
STA *temp;

	while (curr!=NULL) {
		if (curr->active) {
			if (curr->dx>curr->dy) {

				if (curr->c>0) {
					curr->c_x+=curr->xi;
					curr->c--;
					if (curr->p<0)
						curr->p+=curr->c1;
					else {
						curr->p+=curr->c2;
						curr->c_y+=curr->yi;
					}
				} else curr->active=FALSE;
			} else {

				if (curr->c>0) {
					curr->c_y+=curr->yi;
					curr->c--;
					if (curr->p<0)
						curr->p+=curr->c1;
					else {
						curr->p+=curr->c2;
						curr->c_x+=curr->xi;
					}
				} else curr->active=FALSE;
			}
			XDrawPoint(display, win, sta_gc, curr->c_x, curr->c_y);
		}
		curr=curr->next;
	}
	
	curr=first_sta;
	while(curr!=NULL) {
		if (!curr->active) {
			DropBomb(curr->destx, curr->desty, TRUE);
			XDrawLine(display, win, erase_gc, 
				curr->sx, curr->sy,
				curr->destx, curr->desty);

			if (curr->prev==NULL)
				first_sta=curr->next;
			else 
				curr->prev->next=curr->next;

			if (curr->next==NULL)
				last_sta=curr->prev;
			else
				curr->next->prev=curr->prev;

			temp=curr->next;

			free(curr);

			stadelay+=STADELAY;

			curr=temp;

		} else curr=curr->next;
	}
}

int ResetGame(void) {
int a;

	for (a=0; a<10; a++)
		firestage[a]=0;

	NumDead=0;
	numsmart=0;
	level++;
	stadelay=1000; missledelay=1000; bombdelay=1000;

	InitMissles();

	first_bomb=last_bomb=NULL;
	first_sta=last_sta=NULL;
	first_smart=last_smart=NULL;

	intact[0]=intact[4]=intact[8]=TRUE;

	shots[0]=SHOTS_PER_BASE;
	shots[4]=SHOTS_PER_BASE;
	shots[8]=SHOTS_PER_BASE;

	ship.active=FALSE;
	ship.flown=FALSE;

	XClearWindow(display, win);
	XSync(display, TRUE);

	DrawBoard();
	XFlush(display);
	sleep(1);

	basedelay = level * 250;
	if (basedelay > 9000)
		basedelay = 1000;
	else
		basedelay = 10000 - basedelay;
	PAUSE = PAUSEINC * level;
	if (PAUSE > 10)
		PAUSE = 10;

	MaxSmartPerLevel=(level/5)-1;
	if (MaxSmartPerLevel > 5)
		MaxSmartPerLevel=5;

	MaxSmart=level/10;

	TotalSmart=0;
	return FALSE;
}

int
CheckingSleep(long usec)
{
	fd_set rmask;
	struct timeval t;
	XEvent ev;
	char key;
	static char pauseMessage[] = "Paused";

	rmask = check_mask;
	t.tv_sec = usec / 1000000;
	t.tv_usec = usec % 1000000;
	while (select(xserver_fd+1, &rmask, (fd_set *) 0, (fd_set *) 0, &t) > 0) {
		if (XCheckTypedEvent(display, KeyPress, &ev)) {
			XLookupString(&ev, &key, 1, NULL, NULL);
			switch (key) {
			case 'p':
			case 'P':
				ungrab_pointer();
				XDrawString(display, win, sta_gc,
					MAXX / 2, TOPY - 5,
					pauseMessage, strlen(pauseMessage));
				XFlush(display);
				do {
					XNextEvent(display, &ev);
				} while (ev.type != KeyPress);
				XDrawString(display, win, erase_gc,
					MAXX / 2, TOPY - 5,
					pauseMessage, strlen(pauseMessage));
				grab_pointer();
				break;
			case 'q':
			case 'Q':
			case ' ':
				return TRUE;
			}
		}
	}
	return FALSE;
}

int
GiveBonus(int countDown) {
static char s1[]="Missiles Remaining:";
static char s2[]="Cities Remaining:";
char s3[20];
int i;
int nShots, nCities, c;

	nShots = shots[0] + shots[4] + shots[8];
	nCities = 0;
	for (i = 0; i < 3; i++) {
		if (intact[1+i])
			nCities++;
		if (intact[5+i])
			nCities++;
	}

	if (nShots != 0) {
		c = 0;
		XDrawString(display, win, sta_gc, 200, 200, s1, strlen(s1));
		XFlush(display);
		if (CheckingSleep(750000))
			return TRUE;
		for (i = 0; i < nShots; i++) {
			while (shots[c] == 0)
				c += 4;
			LoseShot(c);
			XCopyArea(display, shot, win, fall_gc, 0,0, 
				shot_width, shot_height, 200+(i*15),220);
			IncScore(SAVE_MISSILE_SC);
			XFlush(display);
			if (CheckingSleep(50000))
				return TRUE;
		}
		if (CheckingSleep(500000))
			return TRUE;
	}

	if (nCities != 0) {
		c = 1;
		XDrawString(display, win, sta_gc, 200, 300, s2, strlen(s2));
		XFlush(display);
		if (CheckingSleep(750000))
			return;
		for (i=0; i < nCities; i++) {
			while (!intact[c])
				if (++c == 4)
					c = 5;
			XFillRectangle(display, win, erase_gc,
				locX[c] - city_width / 2,
				MAXY - city_height,
				city_width, city_height);
			XCopyArea(display, city, win, fall_gc, 0,0, 
				city_width, city_height, 200+(i*40),320);
			IncScore(CITY_SC);
			XFlush(display);
			if (CheckingSleep(250000))
				return TRUE;
			if (++c == 4)
				c = 5;
		}
		if (level < 29 || !countDown) {
			if (CheckingSleep(4000000))
				return TRUE;
		} else {
			for (i = 10; i > 0; i--) {
				sprintf(s3, "next level in %d", i);
				XDrawString(display, win, sta_gc, 200, 400,
					s3, strlen(s3));
				XFlush(display);
				if (CheckingSleep(400000))
					return TRUE;
				XDrawString(display, win, erase_gc, 200, 400,
					s3, strlen(s3));
			}
		}
	} else if (nShots != 0)
		return CheckingSleep(1000000);
}

void RedrawMissles(void) {
int a;

	for (a=0; a<MaxMiss; a++)
		if (Miss[a].alive)
			XDrawLine(display, win, fall_gc, 
				Miss[a].sx, Miss[a].sy, Miss[a].c_x, Miss[a].c_y);
}

void CheckPlane(void) {
int max, Extras, a;

	if (ship.flown)
		return;

	if (!ship.active)
		if (rrandom(200)==0) {
			ship.active=TRUE;
			ship.cx=0;
			ship.cy=100+rrandom(200);
			ship.dropped=FALSE;
			ship.dropat=rrandom(400)+100;
		}

	if (!ship.active)
		return;

	if (ship.cx>=MAXX) {

		ship.flown=TRUE;
		ship.active=FALSE;
		XCopyArea(display, noplane, win, fall_gc, 0,0, 
			noplane_width, noplane_height, ship.cx, ship.cy);

	} else {

		XCopyArea(display, plane, win, fall_gc, 0,0, 
			plane_width, plane_height, ship.cx, ship.cy);

		ship.cx+=1;

		if (!ship.dropped) {
			if (ship.cx>ship.dropat) {
				ship.dropped=TRUE;

				Extras=rrandom(2)+2;

				MaxMiss+=Extras; NumAlive+=Extras;

				missledelay-=Extras*MISSLEDELAY;
				max=MaxMiss;

				for (a=max-Extras; a<max; a++) {
					InitMissle(a,ship.cy+plane_height+5,FALSE,1);

					Miss[a].sx=ship.cx+(plane_width/2);

					SetupBres(a);
				}
			}
		}
	}
}

void SetupSmartBomb(SMART *c) {
	/* Set up Bres algorithm for smart bomb */
	c->dx=abs(c->sx-c->destx);
	c->dy=abs(c->sy-c->desty);

	c->cx=c->sx;
	c->xi= (c->sx<c->destx) ? 1 : -1;
	c->cy=c->sy;
	c->yi= (c->sy<c->desty) ? 1 : -1;

	if (c->dx>c->dy) {
		c->c=c->dx;
		c->p=2*c->dy-c->dx;
		c->c1=2*c->dy;
		c->c2=2*(c->dy-c->dx);
	} else {
		c->c=c->dy;
		c->p=2*c->dx-c->dy;
		c->c1=2*c->dx;
		c->c2=2*(c->dx-c->dy);
	}
}

void CreateSmart(void) {
SMART *new;
	
	if ((new=(SMART *) malloc(sizeof(SMART)))==NULL) {
		printf("Can't make any more smart bombs\n");
		exit(1);
	}

	numsmart++;
	TotalSmart++;

	/* Stick it in the list */
	new->next=NULL;

	if (first_smart==NULL)
		first_smart=new;
	
	if (last_smart!=NULL)
		last_smart->next=new;

	new->prev=last_smart;

	last_smart=new;

	/* Heres where it starts from */
	new->sx=rrandom(MAXX-100)+50;
	new->sy=TOPY+10;

	/* Heres where its going */
	new->dest = PickDest();
	new->destx=locX[new->dest];
	new->desty=MAXY-base_height;

	new->good=TRUE;
	new->frame=1;

	SetupSmartBomb(new);

	XCopyArea(display, smart1, win, fall_gc, 0,0, 
		smart1_width, smart1_height, new->cx, new->cy);
}

SMART *KillSmart(SMART *curr, int detonated) {
SMART *temp;

	XFillRectangle(display, win, erase_gc, 
		curr->cx, curr->cy, smart1_width, smart1_height);

	if (detonated) {
		intact[curr->dest]=FALSE;
		firestage[curr->dest]=TRUE;
		if (curr->dest==0 || curr->dest==4 || curr->dest==8)
			shots[curr->dest]=0;

		DropBomb(locX[curr->dest], MAXY-base_height/2,TRUE);
	} else 
		DropBomb(curr->cx, curr->cy, TRUE);

	if (curr->prev==NULL)
		first_smart=curr->next;
	else 
		curr->prev->next=curr->next;

	if (curr->next==NULL)
		last_smart=curr->prev;
	else
		curr->next->prev=curr->prev;

	numsmart--;
	temp=curr->next;
	free(curr);
	return temp;
}

int GetMask(int xx, int yy, int sz, int x, int y) {
int s=0;

	if (x < xx-sz) s|=LEFT;
	if (x > xx+sz) s|=RIGHT;
	if (y > yy-sz) s|=TOP;
	if (y > yy+sz) s|=BOTTOM;

	return s;
}

int Intersect(SMART *cs, int x, int y, int width) { 
int bot;
int x1, y1, x2, y2;
float dx, dy;
int xx, yy;
int p1, p2;

	bot= y+width+smart1_height - cs->cy;

	if (bot>0 && bot < 150) {
		if (cs->good) {
			x1=cs->sx; y1=cs->sy;
			x2=cs->destx; y2=cs->desty;
		} else {
			x1=cs->cx; y1=cs->cy;
			x2=locX[cs->dest]; 
			y2=MAXY-base_height/2;
		}

		yy=y+width; 
		dy=y2-y1;
		dx=x2-x1;

		xx=x1+(int) (((float)(yy-y1))*dx/dy);

		p1=GetMask(x, y, width, x1, y1);
		p2=GetMask(x, y, width, xx, yy);

		if ((p1 & p2)==0) 
			return TRUE;
	} 
	return FALSE;
}

void SetPathX(SMART *cs, int inc) {

	cs->destx+=inc;

	if (cs->destx<0) 
		cs->destx=smart1_width*3;
	if (cs->destx>MAXX)
		cs->destx=MAXX-smart1_width*3;
}

void MovePath(SMART *cs, int x, int y, int dir) {
	
	cs->destx=x;
	SetPathX(cs, (dir==LEFT) ? -cloud0_width*2 : cloud0_width*2);

	cs->desty=y;
	if (abs(cs->desty-cs->cy) < cloud0_height) {
		cs->desty+=cloud0_height;
		SetPathX(cs, (dir==LEFT) ? -cloud0_width : cloud0_width);
	}

	if (cs->desty > MAXY-base_height) 
		cs->desty = MAXY-base_height;

	if (cs->desty<cs->cy)
		cs->desty=cs->cy;

	cs->sx=cs->cx;
	cs->sy=cs->cy;

	SetupSmartBomb(cs);
}

void ResetSmartToDest(SMART *cs) {
	cs->sx=cs->cx;
	cs->sy=cs->cy;
	cs->destx=locX[cs->dest];
	cs->desty=MAXY-base_height/2;
	cs->good=TRUE;

	SetupSmartBomb(cs);
}

void CheckPath(SMART *cs) {
BOMB *curr;

	curr=first_bomb;
	while (curr!=NULL) {
		if (Intersect(cs, curr->x, curr->y, stagesize[4])) {
			cs->good=FALSE;
			if (cs->cx < curr->x)
				MovePath(cs, curr->x, curr->y, LEFT);
			else 
				MovePath(cs, curr->x, curr->y, RIGHT);
		} else {
		/*
			if (!cs->good) 
				ResetSmartToDest(cs);
		*/
		}
		curr=curr->next;
	}
}

void CheckSmart(int increment) {
SMART *curr;
int done;
	
	if (numsmart<MaxSmart && TotalSmart<MaxSmartPerLevel) {
		if (rrandom(90)==0) 
			CreateSmart();
		else if (first_smart==NULL) 
			return;
	}

	curr=first_smart;
	while (curr!=NULL) {

		done=FALSE;

		if (increment || !curr->good) {
			CheckPath(curr);
			if (curr->dx>curr->dy) {

				if (curr->c>0) {
					curr->cx+=curr->xi;
					curr->c--;
					if (curr->p<0)
						curr->p+=curr->c1;
					else {
						curr->p+=curr->c2;
						curr->cy+=curr->yi;
					}
				} else {
					if (curr->good) {
						curr=KillSmart(curr, TRUE);
						done=TRUE;
					} else ResetSmartToDest(curr);
				}
			} else {

				if (curr->c>0) {
					curr->cy+=curr->yi;
					curr->c--;
					if (curr->p<0)
						curr->p+=curr->c1;
					else {
						curr->p+=curr->c2;
						curr->cx+=curr->xi;
					}
				} else {
					if (curr->good) {
						curr=KillSmart(curr, TRUE);
						done=TRUE;
					} else ResetSmartToDest(curr);
				}
			}
		}

		if (!done) {
			curr->frame=!curr->frame;

			if (curr->frame)
				XCopyArea(display, smart1, win, fall_gc, 0,0, 
					smart1_width, smart1_height, curr->cx, curr->cy);
			else 
				XCopyArea(display, smart2, win, fall_gc, 0,0, 
					smart2_width, smart2_height, curr->cx, curr->cy);

			curr=curr->next;
		}
	}
}

void Flicker(void) {
Pixmap p;
int a;

	for (a=0; a<10; a++) 
		if (firestage[a]>0) {
			switch(firestage[a]) {
				case 1: p=fire1; break;
				case 2: p=fire2; break;
				case 3: p=fire3; break;
			}
			
			XCopyArea(display,p , win, fall_gc, 0,0, 
			fire1_width, fire1_height, locX[a]-fire1_width/2, MAXY-fire1_height);

			if (++firestage[a] > MAXFIRE)
				firestage[a]=1;
		}
}
	
void PlayGame(int scoresOnly, int disableButtons, int countDown, int startLevel) {
int a,b;
int cont=TRUE;
int quit=FALSE;
int smartdelay=0;
int firedelay=0;
int user_quit = FALSE;
XEvent report;
char *name;
long event = 
	KeyPressMask | ExposureMask | VisibilityChangeMask;
char key;

	if (!disableButtons)
		event |= ButtonPressMask;
	level = startLevel - 1;
	if (level < 0)
		level = 0;
	InitGame();

	if (scoresOnly) {
		update_scores(-1, -1);
		display_scores();
		FinishGame();
		return;
	}

	grab_pointer();
	TitlePage();

	while (!quit) {

		if (user_quit = ResetGame())
			break;

		cont=TRUE;

		while(cont) {

			HandleIt();

			for (a=0; a<10; a++)
				MoveSta();

			UpdateBombs();

			if (level>PLANELEVEL)
				CheckPlane();

			CheckSmart((smartdelay>SMARTWAIT));
			if (smartdelay++>SMARTWAIT)
				smartdelay=0;

			if (firedelay++>5) {
				Flicker();
				firedelay=0;
			}

			if (XCheckMaskEvent(display, event, &report)) {
				switch(report.type) {
				case ButtonPress:
					if (report.xbutton.button == Button1) 
						LaunchSTA(0, report.xbutton.x, report.xbutton.y);
					else if (report.xbutton.button == Button2) 
						LaunchSTA(4, report.xbutton.x, report.xbutton.y);
					else if (report.xbutton.button == Button3) 
						LaunchSTA(8, report.xbutton.x, report.xbutton.y);
					break;

				case KeyPress:
					XLookupString(&report, &key, 1, NULL, NULL);
					switch (key) {
					case 'q':
					case 'Q':
					case ' ':
						cont=FALSE;
						quit=TRUE;
						user_quit = TRUE;
						break;
					case 'z':
					case '1':
						LaunchSTA(0, report.xkey.x, report.xkey.y);
						break;
					case 'x':
					case '2':
						LaunchSTA(4, report.xkey.x, report.xkey.y);
						break;
					case 'c':
					case '3':
						LaunchSTA(8, report.xkey.x, report.xkey.y);
						break;
					}
					break;

				case Expose:
				case VisibilityNotify:
					DrawBoard();
					RedrawMissles();
					break;
					
				}
			}

			usleep(basedelay+stadelay+missledelay+bombdelay);

			if (NumDead == NumAlive && first_bomb==NULL &&
				first_sta==NULL && !ship.active && first_smart==NULL)
					cont=FALSE;
		}

		if (!quit && (user_quit = GiveBonus(countDown)))
			break;

		if (!intact[1] && !intact[2] && !intact[3] &&
		    !intact[5] && !intact[6] && !intact[7])
				quit=TRUE;
	}

	ungrab_pointer();

	if (!user_quit)
		the_end();
	if (update_scores(score, level) || !user_quit)
		display_scores();

	FinishGame();
}
