#include "guts.h"
#include "bitmaps/missle"
#include "time.h"

Display *display;
int screen_num;
Window win;
int colors[MAX_COLORS];
char *window_Name = "Missile X";
char *icon_Name = "Missile X";
static char *cname[] = {"Red", "Yellow", "Green", "Blue", "Black", "White"};
char *progname;

int rrandom(int x) { 
long num; 
	return (random() % x); 
}

int ErrorHandler(Display *disp, XErrorEvent *err) {
char msg[80];

	XGetErrorText(disp, err->error_code, msg, 80);
	fprintf(stderr, "Error code %s\n", msg);
}

void
usage(void)
{
	fprintf(stderr, "usage: %s [-s] [-c] [-l level]\n", progname);
	exit(1);
}

void main(int argc, char *argv[]) {
char *display_name = NULL;
unsigned int disp_x, disp_y;
XEvent report;
XWMHints wm_hints;
XClassHint class_hints;
XSizeHints size_hints;
XTextProperty windowName, iconName;
Pixmap icon_pixmap;
XSetWindowAttributes setwinattr;
unsigned long valuemask;
Colormap cmap;
int i, startLevel = 1, scoresOnly = FALSE, countDown = FALSE;
int disableButtons = FALSE;
XColor exact_def;
GC gc;
extern int optind;
extern char *optarg;

	progname = argv[0];

	while ((i = getopt(argc, argv, "sckl:")) != EOF) {
		switch (i) {
		case '?':
			usage();
			break;
		case 's':
			scoresOnly = TRUE;
			break;
		case 'c':
			countDown = TRUE;
			break;
		case 'k':
			disableButtons = TRUE;
			break;
		case 'l':
			startLevel = atoi(optarg);
			break;
		}
	}
	if (optind != argc)
		usage();

	if ((display=XOpenDisplay(display_name))==NULL) {
		fprintf(stderr, "%s: Cannot connect to X server.\n",progname);
		exit(1);
	}

	srandom(time(0));

	XSetErrorHandler(ErrorHandler);

	screen_num=DefaultScreen(display);
	disp_x=DisplayWidth(display,  screen_num);
	disp_y=DisplayHeight(display, screen_num);

	win=XCreateSimpleWindow(display, RootWindow(display, screen_num),
			0, 0, MAXX, MAXY, 4,
			BlackPixel(display, screen_num),
			WhitePixel(display, screen_num)
		);

	cmap = DefaultColormap(display, screen_num);
	for (i=0; i<MAX_COLORS; i++) {
		if (!XParseColor(display, cmap, cname[i], &exact_def)) {
			fprintf(stderr, "%s Color name %s not in database\n", 
				progname, cname[i]);
			exit(1);
		}
		if (!XAllocColor(display, cmap, &exact_def)) {
			/* Moan and complain */;
		}
		colors[i]=exact_def.pixel;
	}

/*
	valuemask = CWBackPixel;
	setwinattr.background_pixel = colors[BLUE];
	XChangeWindowAttributes(display, win, valuemask, &setwinattr);
*/

	icon_pixmap = XCreateBitmapFromData(display, win, 
					missle_bits, missle_width, missle_height);

	/* Set window manager properties */
	if (XStringListToTextProperty(&window_Name, 1, &windowName)==0) {
		fprintf(stderr,"%s:windowName alloc() failed\n",progname);
		exit(-1);
	}

	if (XStringListToTextProperty(&icon_Name, 1, &iconName)==0) {
		fprintf(stderr,"%s:iconName alloc() failed\n",progname);
		exit(-1);
	}

	size_hints.flags = PPosition | PSize | PMinSize;
	size_hints.min_width = 800;
	size_hints.min_height= 600;

	wm_hints.initial_state = NormalState;
	wm_hints.input = True; 
	wm_hints.icon_pixmap = icon_pixmap; 
	wm_hints.flags = StateHint | IconPixmapHint | InputHint; 

	class_hints.res_name=progname;
	class_hints.res_class = "Missile X";

	XSetWMProperties(display, win, &windowName, &iconName, 
		argv, argc, &size_hints, &wm_hints, &class_hints);

	XSelectInput(display, win, ExposureMask | KeyPressMask | ButtonPressMask | StructureNotifyMask);
	XMapWindow(display, win);

	do 
		XNextEvent(display, &report);
	while (report.type!=MapNotify);

	PlayGame(scoresOnly, disableButtons, countDown, startLevel);

	XCloseDisplay(display);
}
